/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ca.universe.basic;

import java.io.Serializable;
import org.encog.ca.CellularAutomataError;
import org.encog.ca.universe.Universe;
import org.encog.ca.universe.UniverseCell;
import org.encog.ca.universe.UniverseCellFactory;
import org.encog.ml.BasicML;

public class BasicUniverse
extends BasicML
implements Universe,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ELEMENT_COUNT = "elementCount";
    private final UniverseCell[][] data;
    private final UniverseCellFactory cellFactory;

    public BasicUniverse(int height, int width, UniverseCellFactory theCellFactory) {
        this.data = new UniverseCell[height][width];
        this.cellFactory = theCellFactory;
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                this.data[row][col] = this.cellFactory.factor();
            }
        }
    }

    @Override
    public Object clone() {
        BasicUniverse result = new BasicUniverse(this.getRows(), this.getColumns(), this.cellFactory);
        result.copy(this);
        return result;
    }

    @Override
    public void copy(Universe source) {
        if (!(source instanceof BasicUniverse)) {
            throw new CellularAutomataError("Can only copy another BasicUniverse");
        }
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                this.data[row][col].copy(source.get(row, col));
            }
        }
    }

    @Override
    public double compare(Universe otherWorld) {
        if (!(otherWorld instanceof BasicUniverse)) {
            throw new CellularAutomataError("Can only compare another BasicUniverse");
        }
        int result = 0;
        int total = 0;
        for (int row = 0; row < otherWorld.getRows(); ++row) {
            for (int col = 0; col < otherWorld.getColumns(); ++col) {
                int d2;
                int d1 = Math.abs((int)(255.0 * this.get(row, col).getAvg()));
                if (Math.abs(d1 - (d2 = Math.abs((int)(255.0 * otherWorld.get(row, col).getAvg())))) > 10) {
                    ++result;
                }
                ++total;
            }
        }
        return (double)result / (double)total;
    }

    @Override
    public int getColumns() {
        return this.data[0].length;
    }

    @Override
    public int getRows() {
        return this.data.length;
    }

    @Override
    public void randomize() {
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                for (int i = 0; i < 3; ++i) {
                    this.data[row][col].randomize();
                }
            }
        }
    }

    @Override
    public UniverseCell get(int row, int col) {
        return this.data[row][col];
    }

    @Override
    public boolean isValid(int row, int col) {
        return row >= 0 && col >= 0 && row < this.getRows() && col < this.getColumns();
    }

    @Override
    public UniverseCellFactory getCellFactory() {
        return this.cellFactory;
    }

    @Override
    public void updateProperties() {
    }

    @Override
    public double calculatePercentInvalid() {
        int result = 0;
        int total = 0;
        for (int row = 0; row < this.getRows(); ++row) {
            for (int col = 0; col < this.getColumns(); ++col) {
                UniverseCell cell = this.get(row, col);
                for (int i = 0; i < cell.size(); ++i) {
                    if (cell.get(i) < -1.0 || cell.get(i) > 1.0) {
                        ++result;
                    }
                    ++total;
                }
            }
        }
        return (double)result / (double)total;
    }
}

