/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Util;

public class UndoableFieldChange
extends AbstractUndoableEdit {
    private BibtexEntry entry;
    private String field;
    private String oldValue;
    private String newValue;

    public UndoableFieldChange(BibtexEntry entry, String field, String oldValue, String newValue) {
        this.entry = entry;
        this.field = field;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public String getUndoPresentationName() {
        return "Undo: change field";
    }

    @Override
    public String getRedoPresentationName() {
        return "Redo: change field";
    }

    @Override
    public void undo() {
        super.undo();
        try {
            if (this.oldValue != null) {
                this.entry.setField(this.field, this.oldValue);
            } else {
                this.entry.clearField(this.field);
            }
        }
        catch (Throwable ex) {
            Util.pr(ex.getMessage());
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            if (this.newValue != null) {
                this.entry.setField(this.field, this.newValue);
            } else {
                this.entry.clearField(this.field);
            }
        }
        catch (Throwable ex) {
            Util.pr(ex.getMessage());
        }
    }
}

