/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class INSPIREBibtexFilterReader
extends FilterReader {
    protected BufferedReader in;
    private String line;
    private int pos;
    private boolean pre;

    INSPIREBibtexFilterReader(Reader _in) {
        super(_in);
        this.in = new BufferedReader(_in);
        this.pos = -1;
        this.pre = false;
    }

    private String readpreLine() throws IOException {
        String l;
        do {
            if ((l = this.in.readLine()) == null) {
                return null;
            }
            if (l.equals("<pre>")) {
                this.pre = true;
                l = this.in.readLine();
            }
            if (!l.equals("</pre>")) continue;
            this.pre = false;
        } while (!this.pre);
        return l;
    }

    private String fixBibkey(String in) {
        if (in == null) {
            return null;
        }
        if (in.matches("@Article\\{.*,")) {
            return in.replace(' ', '_');
        }
        return in;
    }

    @Override
    public int read() throws IOException {
        if (this.pos < 0) {
            this.line = this.fixBibkey(this.readpreLine());
            this.pos = 0;
            if (this.line == null) {
                return -1;
            }
        }
        if (this.pos >= this.line.length()) {
            this.pos = -1;
            return 10;
        }
        return this.line.charAt(this.pos++);
    }
}

