/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.gui.EntryTypeList;
import net.sf.jabref.gui.FieldSetComponent;

public class EntryCustomizationDialog2
extends JDialog
implements ListSelectionListener,
ActionListener {
    protected JabRefFrame frame;
    protected GridBagLayout gbl = new GridBagLayout();
    protected GridBagConstraints con = new GridBagConstraints();
    protected FieldSetComponent reqComp;
    protected FieldSetComponent optComp;
    protected FieldSetComponent optComp2;
    protected EntryTypeList typeComp;
    protected JButton ok;
    protected JButton cancel;
    protected JButton apply;
    protected JButton helpButton;
    protected JButton delete;
    protected JButton importTypes;
    protected JButton exportTypes;
    protected final List<String> preset = Arrays.asList(BibtexFields.getAllFieldNames());
    protected String lastSelected = null;
    protected Map<String, List<String>> reqLists = new HashMap<String, List<String>>();
    protected Map<String, List<String>> optLists = new HashMap<String, List<String>>();
    protected Map<String, List<String>> opt2Lists = new HashMap<String, List<String>>();
    protected Set<String> defaulted = new HashSet<String>();
    protected Set<String> changed = new HashSet<String>();
    boolean biblatexMode;

    public EntryCustomizationDialog2(JabRefFrame frame) {
        super(frame, Globals.lang("Customize entry types"), false);
        this.frame = frame;
        this.initGui();
    }

    protected final void initGui() {
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        this.biblatexMode = Globals.prefs.getBoolean("biblatexMode");
        JPanel main = new JPanel();
        JPanel buttons = new JPanel();
        JPanel right = new JPanel();
        main.setLayout(new BorderLayout());
        right.setLayout(new GridLayout(this.biblatexMode ? 2 : 1, 2));
        ArrayList<String> entryTypes = new ArrayList<String>();
        Iterator<String> i = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (i.hasNext()) {
            entryTypes.add(i.next());
        }
        this.typeComp = new EntryTypeList(entryTypes);
        this.typeComp.addListSelectionListener(this);
        this.typeComp.addAdditionActionListener(this);
        this.typeComp.addDefaultActionListener(new DefaultListener());
        this.typeComp.setListSelectionMode(0);
        this.reqComp = new FieldSetComponent(Globals.lang("Required fields"), new ArrayList<String>(), this.preset, true, true);
        this.reqComp.setEnabled(false);
        this.reqComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        DataListener dataListener = new DataListener();
        this.reqComp.addListDataListener(dataListener);
        this.optComp = new FieldSetComponent(Globals.lang("Optional fields"), new ArrayList<String>(), this.preset, true, true);
        this.optComp.setEnabled(false);
        this.optComp.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.optComp.addListDataListener(dataListener);
        right.add(this.reqComp);
        right.add(this.optComp);
        if (this.biblatexMode) {
            this.optComp2 = new FieldSetComponent(Globals.lang("Optional fields") + " 2", new ArrayList<String>(), this.preset, true, true);
            this.optComp2.setEnabled(false);
            this.optComp2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.optComp2.addListDataListener(dataListener);
            right.add(new JPanel());
            right.add(this.optComp2);
        }
        right.setBorder(BorderFactory.createEtchedBorder());
        this.ok = new JButton("OK");
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.apply = new JButton(Globals.lang("Apply"));
        this.ok.addActionListener(this);
        this.apply.addActionListener(this);
        this.cancel.addActionListener(this);
        ButtonBarBuilder bb = new ButtonBarBuilder(buttons);
        buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)this.ok);
        bb.addButton((JComponent)this.apply);
        bb.addButton((JComponent)this.cancel);
        bb.addGlue();
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EntryCustomizationDialog2.this.dispose();
            }
        };
        ActionMap am = main.getActionMap();
        InputMap im = main.getInputMap(2);
        im.put(Globals.prefs.getKey("Close dialog"), "close");
        am.put("close", closeAction);
        main.add((Component)this.typeComp, "West");
        main.add((Component)right, "Center");
        main.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pane.add((Component)main, "Center");
        pane.add((Component)buttons, "South");
        this.pack();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        String s;
        if (e.getValueIsAdjusting()) {
            return;
        }
        if (this.lastSelected != null) {
            this.reqLists.put(this.lastSelected, this.reqComp.getFields());
            this.optLists.put(this.lastSelected, this.optComp.getFields());
            if (this.biblatexMode) {
                this.opt2Lists.put(this.lastSelected, this.optComp2.getFields());
            }
        }
        if ((s = this.typeComp.getFirstSelected()) == null) {
            return;
        }
        List<String> rl = this.reqLists.get(s);
        if (rl == null) {
            BibtexEntryType type = BibtexEntryType.getType(s);
            if (type != null) {
                List<String> opt;
                String[] rf = type.getRequiredFieldsForCustomization();
                String[] of = type.getOptionalFields();
                List<String> req = rf != null ? Arrays.asList(rf) : new ArrayList<String>();
                if (!this.biblatexMode) {
                    opt = of != null ? Arrays.asList(of) : new ArrayList<String>();
                } else {
                    String[] priOf = type.getPrimaryOptionalFields();
                    opt = priOf != null ? Arrays.asList(priOf) : new ArrayList<String>();
                    ArrayList<String> opt2 = new ArrayList<String>();
                    if (of != null) {
                        for (int i = 0; i < of.length; ++i) {
                            if (opt.contains(of[i])) continue;
                            opt2.add(of[i]);
                        }
                    }
                    this.optComp2.setFields(opt2);
                    this.optComp2.setEnabled(true);
                }
                this.reqComp.setFields(req);
                this.reqComp.setEnabled(true);
                this.optComp.setFields(opt);
                this.optComp.setEnabled(true);
            } else {
                this.reqComp.setFields(new ArrayList<String>());
                this.reqComp.setEnabled(true);
                this.optComp.setFields(new ArrayList<String>());
                this.optComp.setEnabled(true);
                new FocusRequester(this.reqComp);
            }
        } else {
            this.reqComp.setFields(rl);
            this.optComp.setFields(this.optLists.get(s));
        }
        this.lastSelected = s;
        this.typeComp.enable(s, this.changed.contains(this.lastSelected) && !this.defaulted.contains(this.lastSelected));
    }

    protected void applyChanges() {
        this.valueChanged(new ListSelectionEvent(new JList(), 0, 0, false));
        List<String> types = this.typeComp.getFields();
        for (String typeName : this.reqLists.keySet()) {
            if (!types.contains(typeName)) continue;
            List<String> reqFields = this.reqLists.get(typeName);
            List<String> optFields = this.optLists.get(typeName);
            List<String> opt2Fields = this.opt2Lists.get(typeName);
            String[] reqStr = new String[reqFields.size()];
            reqStr = reqFields.toArray(reqStr);
            String[] optStr = new String[optFields.size()];
            optStr = optFields.toArray(optStr);
            String[] opt2Str = opt2Fields != null ? opt2Fields.toArray(new String[opt2Fields.size()]) : new String[]{};
            boolean changesMade = true;
            if (this.defaulted.contains(typeName)) {
                String nm = Util.nCase(typeName);
                BibtexEntryType.removeType(nm);
                this.updateTypesForEntries(nm);
                continue;
            }
            BibtexEntryType oldType = BibtexEntryType.getType(typeName);
            if (oldType != null) {
                String[] oldReq = oldType.getRequiredFields();
                String[] oldOpt = oldType.getOptionalFields();
                if (this.biblatexMode) {
                    String[] priOpt = oldType.getPrimaryOptionalFields();
                    ArrayList<String> secOpt = new ArrayList<String>();
                    for (int j = 0; j < oldOpt.length; ++j) {
                        boolean inPri = false;
                        for (int k = 0; k < priOpt.length; ++k) {
                            if (!priOpt[k].equals(oldOpt[j])) continue;
                            inPri = true;
                            break;
                        }
                        if (inPri) continue;
                        secOpt.add(oldOpt[j]);
                    }
                    String[] secOptArray = secOpt.toArray(new String[secOpt.size()]);
                    if (this.equalArrays(oldReq, reqStr) && this.equalArrays(oldOpt, optStr) && this.equalArrays(secOptArray, opt2Str)) {
                        changesMade = false;
                    }
                } else if (this.equalArrays(oldReq, reqStr) && this.equalArrays(oldOpt, optStr)) {
                    changesMade = false;
                }
            }
            if (!changesMade) continue;
            CustomEntryType typ = this.biblatexMode ? new CustomEntryType(Util.nCase(typeName), reqStr, optStr, opt2Str) : new CustomEntryType(Util.nCase(typeName), reqStr, optStr);
            BibtexEntryType.ALL_TYPES.put(typeName.toLowerCase(), typ);
            this.updateTypesForEntries(typ.getName());
        }
        HashSet<String> toRemove = new HashSet<String>();
        for (String o : BibtexEntryType.ALL_TYPES.keySet()) {
            if (types.contains(o)) continue;
            toRemove.add(o);
        }
        if (toRemove.size() > 0) {
            Iterator<String> i = toRemove.iterator();
            while (i.hasNext()) {
                this.typeDeletion(i.next());
            }
        }
        this.updateTables();
    }

    protected void typeDeletion(String name) {
        BibtexEntryType type = BibtexEntryType.getType(name);
        if (type instanceof CustomEntryType) {
            int reply;
            if (BibtexEntryType.getStandardType(name) == null && (reply = JOptionPane.showConfirmDialog(this.frame, Globals.lang("All entries of this type will be declared typeless. Continue?"), Globals.lang("Delete custom format") + " '" + Util.nCase(name) + "'", 0, 2)) != 0) {
                return;
            }
            BibtexEntryType.removeType(name);
            this.updateTypesForEntries(Util.nCase(name));
            this.changed.remove(name);
            this.reqLists.remove(name);
            this.optLists.remove(name);
        }
    }

    protected boolean equalArrays(String[] one, String[] two) {
        if (one == null && two == null) {
            return true;
        }
        if (one == null || two == null) {
            return false;
        }
        if (one.length != two.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (one[i].equals(two[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            this.applyChanges();
            this.dispose();
        } else if (e.getSource() == this.cancel) {
            this.dispose();
        } else if (e.getSource() == this.apply) {
            this.applyChanges();
        } else if (e.getSource() == this.typeComp) {
            this.typeComp.selectField(e.getActionCommand());
        }
    }

    private void updateTypesForEntries(String typeName) {
        if (this.frame.getTabbedPane().getTabCount() == 0) {
            return;
        }
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            BasePanel bp = (BasePanel)this.frame.getTabbedPane().getComponentAt(i);
            bp.entryEditors.remove(typeName);
            for (BibtexEntry entry : bp.database().getEntries()) {
                entry.updateType();
            }
        }
    }

    private void updateTables() {
        if (this.frame.getTabbedPane().getTabCount() == 0) {
            return;
        }
        for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
            this.frame.getTabbedPane().getComponentAt(i);
        }
    }

    class DataListener
    implements ListDataListener {
        DataListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.record();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.record();
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.record();
        }

        private void record() {
            if (EntryCustomizationDialog2.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog2.this.defaulted.remove(EntryCustomizationDialog2.this.lastSelected);
            EntryCustomizationDialog2.this.changed.add(EntryCustomizationDialog2.this.lastSelected);
            EntryCustomizationDialog2.this.typeComp.enable(EntryCustomizationDialog2.this.lastSelected, true);
        }
    }

    class DefaultListener
    implements ActionListener {
        DefaultListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EntryCustomizationDialog2.this.lastSelected == null) {
                return;
            }
            EntryCustomizationDialog2.this.defaulted.add(EntryCustomizationDialog2.this.lastSelected);
            BibtexEntryType type = BibtexEntryType.getStandardType(EntryCustomizationDialog2.this.lastSelected);
            if (type != null) {
                String[] rf = type.getRequiredFieldsForCustomization();
                String[] of = type.getOptionalFields();
                List<String> req = rf != null ? Arrays.asList(rf) : new ArrayList<String>();
                List<String> opt = of != null ? Arrays.asList(of) : new ArrayList<String>();
                EntryCustomizationDialog2.this.reqComp.setFields(req);
                EntryCustomizationDialog2.this.reqComp.setEnabled(true);
                EntryCustomizationDialog2.this.optComp.setFields(opt);
            }
        }
    }
}

