/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionModificationException;

public class FloatOption
extends Option {
    private float value;

    public FloatOption() {
        this(0.0f);
    }

    public FloatOption(FloatOption op) {
        super(op);
        op.value = op.getValue();
    }

    public FloatOption(float value) {
        this(value, null);
    }

    public FloatOption(float value, String longOption) {
        this(value, longOption, '\u0000');
    }

    public FloatOption(float value, char shortOption) {
        this(value, null, shortOption);
    }

    public FloatOption(float value, String longOption, char shortOption) {
        super(longOption, shortOption);
        this.value = value;
    }

    @Override
    public Object getObject() {
        return new Float(this.value);
    }

    @Override
    public void modify(String value) throws OptionModificationException {
        try {
            this.value = Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new OptionModificationException("Error. A float must be specified, not '" + value + "'.");
        }
    }

    public void setValue(String value) throws OptionModificationException {
        this.modify(value);
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public String getStringValue() {
        return Float.toString(this.value);
    }

    @Override
    public String getTypeName() {
        return "FLOAT";
    }

    public String toString() {
        return this.getStringValue();
    }
}

