/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.agent;

import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import net.sf.profiler4j.agent.Agent;
import net.sf.profiler4j.agent.BytecodeTransformer;
import net.sf.profiler4j.agent.ClassUtil;
import net.sf.profiler4j.agent.Config;
import net.sf.profiler4j.agent.Log;
import net.sf.profiler4j.agent.Profiler4JError;
import net.sf.profiler4j.agent.ThreadProfiler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transformer
implements ClassFileTransformer {
    private Config config;
    private static long lastTimestamp = System.currentTimeMillis();
    private static List<ClassBatchEntry> scheduledClasses = new ArrayList<ClassBatchEntry>();
    static final Thread transformerThread = new TransformerThread();

    public Transformer(Config config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] currentBytes) throws IllegalClassFormatException {
        if (Agent.beingShutdown) {
            return null;
        }
        if (this.rejectByDefault(className = className.replace('/', '.'))) {
            return null;
        }
        try {
            Object object = ThreadProfiler.globalLock;
            synchronized (object) {
                if (!ClassUtil.getClassFile(className, loader).exists()) {
                    ClassUtil.saveClassBackup(className, loader, currentBytes);
                }
                if (classBeingRedefined == null) {
                    Transformer.scheduleRedefine(loader, className, null);
                    return null;
                }
                if (Thread.currentThread() != transformerThread) {
                    throw new Profiler4JError("[CRITICAL] Cannot redefine from any other thread than " + transformerThread.getName());
                }
                return BytecodeTransformer.transform(className, loader, currentBytes, this.config);
            }
        }
        catch (Throwable t) {
            Log.print(0, "Could not transform class " + className, t);
            if (this.config.isExitVmOnFailure()) {
                System.exit(1);
            }
            return null;
        }
    }

    public boolean rejectByDefault(String className) {
        if (className == null) {
            return true;
        }
        if (className.startsWith("java.net.sf.profiler4j.test.")) {
            return false;
        }
        if (className.startsWith("[") || className.startsWith("java.net.sf.profiler4j.agent.") || className.startsWith("java.util.") || className.startsWith("java.lang.") || className.startsWith("java.lang.Thread") || className.startsWith("java.lang.reflect.") || className.startsWith("java.lang.ref.") || className.equals("com.sun.tools.javac.util.DefaultFileManager") || className.startsWith("sun.security.") || className.startsWith("java.security.MessageDigest$") || className.startsWith("sun.reflect.") || className.startsWith("$Proxy") || className.contains("ByCGLIB$$")) {
            return true;
        }
        if (this.config.getExclusions() != null) {
            for (String cn : this.config.getExclusions()) {
                if (!className.startsWith(cn)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scheduleRedefine(ClassLoader loader, String className, Callback callback) {
        if (Agent.beingShutdown) {
            return;
        }
        List<ClassBatchEntry> list = scheduledClasses;
        synchronized (list) {
            ClassBatchEntry key = new ClassBatchEntry();
            key.className = className;
            key.loader = new WeakReference<ClassLoader>(loader == null ? ClassLoader.getSystemClassLoader() : loader);
            key.callback = callback;
            lastTimestamp = System.currentTimeMillis();
            scheduledClasses.add(key);
            Log.print(1, "Scheduling redefinition of " + className);
        }
    }

    static {
        transformerThread.start();
    }

    private static class TransformerThread
    extends Thread {
        private static final int SLEEP_INTERVAL = 100;
        private static final int STABILIZATION_INTERVAL = 1000;

        public TransformerThread() {
            super("P4J_TRANSFORMER");
            this.setPriority(1);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                ClassBatchEntry[] array;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (Agent.beingShutdown) {
                    return;
                }
                if (System.currentTimeMillis() - lastTimestamp < 1000L) continue;
                List list = scheduledClasses;
                synchronized (list) {
                    if (scheduledClasses.isEmpty()) {
                        continue;
                    }
                    array = scheduledClasses.toArray(new ClassBatchEntry[0]);
                    scheduledClasses.clear();
                }
                Log.print(0, "Starting to reload scheduled classes (" + array.length + " in queue)...");
                int errors = 0;
                int n = 0;
                long t0 = System.currentTimeMillis();
                int batchSequence = 0;
                for (ClassBatchEntry key : array) {
                    if (Agent.beingShutdown) {
                        return;
                    }
                    try {
                        Class<?> cl = null;
                        ClassLoader loader = (ClassLoader)key.loader.get();
                        if (loader != null) {
                            try {
                                cl = Class.forName(key.className, false, loader);
                            }
                            catch (NoClassDefFoundError e) {
                                // empty catch block
                            }
                        }
                        if (cl != null && Agent.mustRedefineClass(cl)) {
                            ++n;
                            byte[] bytes = ClassUtil.loadClassBackup(cl);
                            Log.print(1, "Reloading class " + key.className);
                            ClassDefinition cd = new ClassDefinition(cl, bytes);
                            Agent.inst.redefineClasses(cd);
                        }
                    }
                    catch (Throwable e) {
                        ++errors;
                        Log.print(0, "*** ERROR reloading " + key.className, e);
                    }
                    ++batchSequence;
                    if (key.callback == null) continue;
                    key.callback.notifyClassTransformed(key.className, batchSequence, array.length);
                }
                long dt = System.currentTimeMillis() - t0;
                if (errors == 0) {
                    if (n == 0) {
                        Log.print(0, "No classes needed to be reloaded");
                        continue;
                    }
                    Log.print(0, "Reloaded " + n + " classes in " + dt + "ms");
                    continue;
                }
                Log.print(0, "Reloaded " + n + " classes in " + dt + "ms  (" + errors + " error(s) found)");
            }
        }
    }

    public static interface Callback {
        public void notifyClassTransformed(String var1, int var2, int var3);
    }

    private static class ClassBatchEntry {
        String className;
        WeakReference<ClassLoader> loader;
        Callback callback;

        private ClassBatchEntry() {
        }
    }
}

