/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.IIRCSession;
import com.ircclouds.irc.api.commands.ICommand;
import com.ircclouds.irc.api.commands.SendServerPingReplyCmd;
import com.ircclouds.irc.api.domain.messages.ServerPing;
import com.ircclouds.irc.api.domain.messages.ServerPongMessage;
import com.ircclouds.irc.api.listeners.VariousMessageListenerAdapter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPingVersionListener
extends VariousMessageListenerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPingVersionListener.class);

    @Override
    public void onServerPing(ServerPing aMsg) {
        this.execute(new SendServerPingReplyCmd(new ServerPongMessage(aMsg.getText())));
    }

    protected abstract IIRCSession getSession();

    private void execute(ICommand aCmd) {
        try {
            this.getSession().getCommandServer().execute(aCmd);
        }
        catch (IOException aExc) {
            LOG.error("Error Executing Command [" + aCmd.asString() + "]", (Throwable)aExc);
        }
    }
}

