/*
 * Decompiled with CFR 0.152.
 */
package net.sf.fmj.media.codec.video.jpeg;

import net.sf.fmj.utility.ArrayUtility;

public class JpegStripper {
    private static boolean STRIP = false;

    static void dump(int[] s) {
        JpegStripper.dump(s, 10);
    }

    static void dump(int[] s, int length) {
        for (int i = 0; i < s.length / length + 1; ++i) {
            for (int j = i * length; j < i * length + length && j < s.length; ++j) {
                String tmp = Integer.toHexString(s[j]);
                if (tmp.length() < 2) {
                    tmp = 0 + tmp;
                }
                System.out.print(tmp + " ");
            }
            System.out.println("");
        }
        System.out.println("Length: " + s.length);
    }

    private static int findNextMarker(int[] output) {
        for (int i = 0; i < output.length; ++i) {
            if (output[i] != 255 || output[i + 1] == 0 || output[i + 1] >= 208 && output[i + 1] <= 215) continue;
            STRIP = true;
            return i;
        }
        STRIP = false;
        return output.length;
    }

    public static byte[] removeHeaders(byte[] ba) {
        int i;
        int[] ia = new int[ba.length];
        for (i = 0; i < ba.length; ++i) {
            ia[i] = ba[i] & 0xFF;
        }
        ia = JpegStripper.removeHeaders(ia);
        ba = new byte[ia.length];
        for (i = 0; i < ia.length; ++i) {
            ba[i] = (byte)ia[i];
        }
        return ba;
    }

    public static int[] removeHeaders(int[] input) {
        input = JpegStripper.stripLeadingHeaders(input);
        input = JpegStripper.stripTrailingHeaders(input);
        return input;
    }

    private static int[] stripHeader(int[] s) {
        return ArrayUtility.copyOfRange(s, 2, s.length);
    }

    private static int[] stripHeaderContent(int[] s) {
        s = JpegStripper.stripHeader(s);
        int begin = s[0] * 256 + s[1];
        return ArrayUtility.copyOfRange(s, begin, s.length);
    }

    private static int[] stripLeadingHeaders(int[] input) {
        int[] output = input;
        if (input[0] == 255) {
            switch (input[1]) {
                case 192: 
                case 196: 
                case 218: 
                case 219: 
                case 221: 
                case 224: {
                    output = JpegStripper.stripHeaderContent(output);
                    output = JpegStripper.stripLeadingHeaders(output);
                    break;
                }
            }
            if (input[1] == 216) {
                output = JpegStripper.stripLeadingHeaders(JpegStripper.stripHeader(output));
            }
        }
        return output;
    }

    private static int[] stripOtherMarkers(int[] output) {
        int i = JpegStripper.findNextMarker(output);
        int[] array = ArrayUtility.copyOfRange(output, 0, i);
        return array;
    }

    private static int[] stripTrailingHeaders(int[] output) {
        output = JpegStripper.stripOtherMarkers(output);
        if (STRIP) {
            output = JpegStripper.stripTrailingHeaders(output);
        }
        return output;
    }
}

