/*
 * Decompiled with CFR 0.152.
 */
package net.java.dict4j;

import net.java.dict4j.DictReturnCode;

public class DictException
extends Exception {
    private int code;
    private String message = null;
    private Exception exception;

    public DictException(int n) {
        this.code = n;
    }

    public DictException(String string) {
        this.code = Integer.parseInt(string);
    }

    public DictException(int n, String string) {
        this.code = n;
        this.message = string;
    }

    public DictException(Exception exception) {
        this.code = DictReturnCode.JAVA_ERROR;
        this.message = exception.toString();
        this.exception = exception;
    }

    public int getErrorCode() {
        return this.code;
    }

    public String getMessage() {
        if (this.message == null) {
            this.message = this.generateMessage();
        }
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    private String generateMessage() {
        String string;
        switch (this.code) {
            case 110: {
                string = "n databases present";
                break;
            }
            case 111: {
                string = "n strategies available";
                break;
            }
            case 112: {
                string = "database information follows";
                break;
            }
            case 113: {
                string = "help text follows";
                break;
            }
            case 114: {
                string = "server information follows";
                break;
            }
            case 130: {
                string = "challenge follows";
                break;
            }
            case 150: {
                string = "n definitions retrieved";
                break;
            }
            case 151: {
                string = "word database name";
                break;
            }
            case 152: {
                string = "n matches found";
                break;
            }
            case 210: {
                string = "optional timing";
                break;
            }
            case 220: {
                string = "Connexion OK";
                break;
            }
            case 221: {
                string = "Closing Connection";
                break;
            }
            case 230: {
                string = "Authentification successful";
                break;
            }
            case 250: {
                string = "Ok";
                break;
            }
            case 330: {
                string = "send response";
                break;
            }
            case 420: {
                string = "Server temporarily unavailable";
                break;
            }
            case 421: {
                string = "Server shutting down at operator request";
                break;
            }
            case 500: {
                string = "Syntax error, command not recognized";
                break;
            }
            case 501: {
                string = "Syntax error, illegal parameters";
                break;
            }
            case 502: {
                string = "Command not implemented";
                break;
            }
            case 503: {
                string = "Command parameter not implemented";
                break;
            }
            case 530: {
                string = "Access denied";
                break;
            }
            case 531: {
                string = "Access denied, use SHOW INFO for server information";
                break;
            }
            case 532: {
                string = "Access denied, unknown mechanism";
                break;
            }
            case 550: {
                string = "Invalid database, use SHOW DB for list of databases";
                break;
            }
            case 551: {
                string = "Invalid strategy, use(this.error). SHOW STRAT for a list of strategies";
                break;
            }
            case 552: {
                string = "No match";
                break;
            }
            case 554: {
                string = "No databases present";
                break;
            }
            case 555: {
                string = "No strategies available";
                break;
            }
            default: {
                string = this.code >= DictReturnCode.JAVA_ERROR ? this.message : this.errorGen(this.code);
            }
        }
        return string;
    }

    private String errorGen(int n) {
        String string = Integer.toString(n);
        String string2 = new String();
        if (string.startsWith("1")) {
            string2 = "Positive Preliminary reply : ";
        } else if (string.startsWith("2")) {
            string2 = "Positive Completion reply : ";
        } else if (string.startsWith("3")) {
            string2 = "Positive Intermediate reply : ";
        } else if (string.startsWith("4")) {
            string2 = "Transient Negative Completion reply : ";
        } else if (string.startsWith("5")) {
            string2 = "Permanent Negative Completion reply : ";
        } else {
            return "Unknown error";
        }
        if (string.charAt(1) == '0') {
            string2 = string2 + "Syntax";
        } else if (string.charAt(1) == '1') {
            string2 = string2 + "Information";
        } else if (string.charAt(1) == '2') {
            string2 = string2 + "Connections";
        } else if (string.charAt(1) == '3') {
            string2 = string2 + "Authentication";
        } else if (string.charAt(1) == '4') {
            string2 = string2 + "Unspecified as yet";
        } else if (string.charAt(1) == '5') {
            string2 = string2 + "DICT System";
        } else if (string.charAt(1) == '8') {
            string2 = string2 + "Nonstandard (private implementation) extensions";
        }
        return string2;
    }
}

