/*
 * Decompiled with CFR 0.152.
 */
package mozilla.thunderbird;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mork.ExceptionHandler;
import mork.MorkDocument;
import mork.Row;
import mork.Table;
import mozilla.thunderbird.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressBook {
    private final List<Address> addresses = new LinkedList<Address>();
    private ExceptionHandler exceptionHandler;

    public void load(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream must not be null");
        }
        MorkDocument morkDocument = new MorkDocument(new InputStreamReader(inputStream), this.exceptionHandler);
        for (Row row : morkDocument.getRows()) {
            Address address = new Address(row.getAliases());
            this.addresses.add(address);
        }
        for (Table table : morkDocument.getTables()) {
            for (Row row : table.getRows()) {
                if (row.getValue("DisplayName") == null) continue;
                Address address = new Address(row.getAliases());
                this.addresses.add(address);
            }
        }
    }

    public List<Address> getAddresses() {
        return Collections.unmodifiableList(this.addresses);
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }
}

