/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import ymsg.network.AccountLockedException;
import ymsg.network.ChallengeResponseV10;
import ymsg.network.ChallengeResponseV16;
import ymsg.network.ChallengeResponseV9;
import ymsg.network.ConnectionHandler;
import ymsg.network.DirectConnectionHandler;
import ymsg.network.FileTransferFailedException;
import ymsg.network.HTTPConnection;
import ymsg.network.HTTPConnectionHandler;
import ymsg.network.IllegalIdentityException;
import ymsg.network.LoginRefusedException;
import ymsg.network.NetworkConstants;
import ymsg.network.NoSuchChatroomException;
import ymsg.network.NoSuchConferenceException;
import ymsg.network.PacketBodyBuffer;
import ymsg.network.SOCKSConnectionHandler;
import ymsg.network.ServiceConstants;
import ymsg.network.SessionPicture;
import ymsg.network.StatusConstants;
import ymsg.network.UserStore;
import ymsg.network.Util;
import ymsg.network.YMSG9BadFormatException;
import ymsg.network.YMSG9Packet;
import ymsg.network.YahooChatCategory;
import ymsg.network.YahooChatLobby;
import ymsg.network.YahooChatUser;
import ymsg.network.YahooConference;
import ymsg.network.YahooException;
import ymsg.network.YahooGroup;
import ymsg.network.YahooIdentity;
import ymsg.network.YahooUser;
import ymsg.network.event.SessionAuthorizationEvent;
import ymsg.network.event.SessionChatEvent;
import ymsg.network.event.SessionConferenceEvent;
import ymsg.network.event.SessionErrorEvent;
import ymsg.network.event.SessionEvent;
import ymsg.network.event.SessionExceptionEvent;
import ymsg.network.event.SessionFileTransferEvent;
import ymsg.network.event.SessionFileTransferListener;
import ymsg.network.event.SessionFriendEvent;
import ymsg.network.event.SessionListener;
import ymsg.network.event.SessionNewMailEvent;
import ymsg.network.event.SessionNotifyEvent;
import ymsg.network.event.SessionPictureEvent;

public class Session
implements StatusConstants,
ServiceConstants,
NetworkConstants {
    private static Logger logger = Logger.getLogger(Session.class.getName());
    private String primaryID;
    private String loginID;
    private String password;
    private String cookieY;
    private String cookieT;
    private String cookieC;
    private String imvironment;
    private long status;
    private String customStatusMessage;
    private boolean customStatusBusy;
    private YahooGroup[] groups;
    private YahooIdentity[] identities;
    private int conferenceCount;
    private UserStore userStore;
    private int sessionStatus;
    private long sessionId = 0L;
    private Vector listeners;
    private ConnectionHandler network;
    private ThreadGroup ymsgThreads;
    private InputThread ipThread;
    private PingThread pingThread;
    private Hashtable typingNotifiers;
    private boolean loginOver = false;
    private boolean receivedListFired = false;
    private YahooException loginException = null;
    private YMSG9Packet cachePacket;
    private Hashtable conferences;
    private boolean chatConnectOver = false;
    private boolean chatLoginOver = false;
    private int chatSessionStatus;
    private YahooChatLobby currentLobby = null;
    private String chatID;
    private SessionPicture picture = null;
    private String pictureURL = "";
    private ArrayList<SessionFileTransferListener> sessionFileTransferListeners = new ArrayList();
    Hashtable<String, XFer> currentTransfers = new Hashtable();

    public Session(ConnectionHandler connectionHandler) {
        this.network = connectionHandler;
        this._init();
    }

    public Session() {
        Properties properties = System.getProperties();
        this.network = properties.containsKey("socksProxyHost") ? new SOCKSConnectionHandler() : (properties.containsKey("http.proxyHost") || properties.containsKey("proxyHost") ? new HTTPConnectionHandler() : new DirectConnectionHandler());
        this._init();
    }

    private void _init() {
        this.status = 0x5A55AA55L;
        this.sessionId = 0L;
        this.sessionStatus = 0;
        this.ymsgThreads = new ThreadGroup("YMSG Threads");
        this.groups = null;
        this.identities = null;
        this.listeners = new Vector();
        this.conferences = new Hashtable();
        this.typingNotifiers = new Hashtable();
        this.userStore = new UserStore();
        this.network.install(this, this.ymsgThreads);
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (this.listeners.indexOf(sessionListener) < 0) {
            this.listeners.addElement(sessionListener);
        }
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.removeElement(sessionListener);
    }

    public void addSessionFileListener(SessionFileTransferListener sessionFileTransferListener) {
        if (this.sessionFileTransferListeners.indexOf(sessionFileTransferListener) < 0) {
            this.sessionFileTransferListeners.add(sessionFileTransferListener);
        }
    }

    public void removeSessionFileListener(SessionFileTransferListener sessionFileTransferListener) {
        this.listeners.remove(sessionFileTransferListener);
    }

    public ConnectionHandler getConnectionHandler() {
        return this.network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login(String string, String string2) throws IllegalStateException, IOException, AccountLockedException, LoginRefusedException {
        if (this.sessionStatus != 0) {
            throw new IllegalStateException("Session should be unstarted");
        }
        string = string.toLowerCase();
        this.resetData();
        this.loginID = string;
        this.primaryID = null;
        this.password = string2;
        this.sessionId = 0L;
        this.imvironment = "0";
        this.network.open();
        this.loginOver = false;
        this.startThreads();
        this.transmitAuth();
        long l = System.currentTimeMillis() + (long)Util.loginTimeout(60);
        while (!this.loginOver && !this.past(l)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.past(l)) {
            this.sessionStatus = 3;
            this.closeNetwork();
            throw new InterruptedIOException("Login timed out");
        }
        if (this.sessionStatus == 3 && this.loginException != null) {
            throw (LoginRefusedException)this.loginException;
        }
    }

    public synchronized void logout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.sessionStatus = 0;
        this.transmitLogoff();
    }

    public synchronized void reset() throws IllegalStateException {
        if (this.sessionStatus != 3 && this.sessionStatus != 0) {
            throw new IllegalStateException("Session currently active");
        }
        this.sessionStatus = 0;
        this.chatSessionStatus = 0;
        this.resetData();
    }

    public void sendMessage(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitMessage(string, this.loginID, string2);
    }

    public void sendMessage(String string, String string2, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yahooIdentity);
        this.transmitMessage(string, yahooIdentity.getId(), string2);
    }

    public void sendBuzz(String string) throws IllegalStateException, IOException {
        this.sendMessage(string, "<ding>");
    }

    public void sendBuzz(String string, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, IllegalIdentityException {
        this.sendMessage(string, "<ding>", yahooIdentity);
    }

    public int getSessionStatus() {
        return this.sessionStatus;
    }

    public long getStatus() {
        return this.status;
    }

    public synchronized void setStatus(long l) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == 0 && l != 0L && l != 12L) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (l == 99L) {
            throw new IllegalArgumentException("Cannot set custom state without message");
        }
        long l2 = this.status;
        this.status = l;
        this.customStatusMessage = null;
        if (this.sessionStatus == 2) {
            this._doStatus();
            if (l2 == 12L) {
                this.transmitToggleVisibility(true);
            }
        }
    }

    public synchronized void setStatus(String string, boolean bl) throws IllegalArgumentException, IOException {
        if (this.sessionStatus == 0) {
            throw new IllegalArgumentException("Unstarted sessions can be available or invisible only");
        }
        if (string == null) {
            throw new IllegalArgumentException("Cannot set custom state with null message");
        }
        this.status = 99L;
        this.customStatusMessage = string;
        this.customStatusBusy = bl;
        this._doStatus();
    }

    private void _doStatus() throws IllegalStateException, IOException {
        if (this.status == 0L) {
            this.transmitIsBack();
        } else if (this.status == 12L) {
            this.transmitToggleVisibility(false);
        } else if (this.status == 99L) {
            this.transmitIsAway(this.customStatusMessage, this.customStatusBusy);
        } else {
            this.transmitIsAway();
        }
    }

    public String getCustomStatusMessage() {
        return this.customStatusMessage;
    }

    public boolean isCustomBusy() {
        return this.customStatusBusy;
    }

    public void refreshStats() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitUserStat();
    }

    public YahooIdentity[] getIdentities() {
        if (this.identities == null) {
            return null;
        }
        return (YahooIdentity[])this.identities.clone();
    }

    public YahooIdentity getPrimaryIdentity() {
        return this.identityIdToObject(this.primaryID);
    }

    public YahooIdentity getLoginIdentity() {
        return this.identityIdToObject(this.loginID);
    }

    public void activateIdentity(YahooIdentity yahooIdentity, boolean bl) throws IllegalStateException, IllegalIdentityException, IOException {
        this.checkStatus();
        this.checkIdentity(yahooIdentity);
        if (yahooIdentity.getId().equals(this.primaryID)) {
            throw new IllegalIdentityException("Primary identity cannot be de/activated");
        }
        if (bl) {
            this.transmitIdActivate(yahooIdentity.getId());
        } else {
            this.transmitIdDeactivate(yahooIdentity.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTypingNotification(String string, Component component) {
        String string2 = this.primaryID;
        String string3 = "user\n" + string2;
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            if (this.typingNotifiers.containsKey(string3)) {
                return;
            }
            this.typingNotifiers.put(string3, new TypingNotifier(component, string, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTypingNotification(String string) {
        String string2 = this.primaryID;
        String string3 = "user\n" + string2;
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            TypingNotifier typingNotifier = (TypingNotifier)this.typingNotifiers.get(string3);
            if (typingNotifier == null) {
                return;
            }
            typingNotifier.quit = true;
            typingNotifier.interrupt();
            this.typingNotifiers.remove(string3);
        }
    }

    public void keyTyped(String string) {
        String string2 = this.primaryID;
        String string3 = "user\n" + string2;
        TypingNotifier typingNotifier = (TypingNotifier)this.typingNotifiers.get(string3);
        if (typingNotifier != null) {
            typingNotifier.keyTyped();
        }
    }

    public YahooGroup[] getGroups() {
        return (YahooGroup[])this.groups.clone();
    }

    public Hashtable getUsers() {
        return (Hashtable)this.userStore.getUsers().clone();
    }

    public YahooUser getUser(String string) {
        return this.userStore.get(string);
    }

    public YahooUser addUserbyID(String string) {
        return this.userStore.getOrCreate(string);
    }

    public String getImvironment() {
        return this.imvironment;
    }

    public String[] getCookies() {
        String[] stringArray = new String[]{this.cookieY, this.cookieT, this.cookieC};
        return stringArray;
    }

    public YahooConference createConference(String[] stringArray, String string) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkIdentityNotOnList(stringArray);
        return this.createConference(stringArray, string, this.identityIdToObject(this.loginID));
    }

    public YahooConference createConference(String[] stringArray, String string, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yahooIdentity);
        this.checkIdentityNotOnList(stringArray);
        String string2 = this.getConferenceName(yahooIdentity.getId());
        this.transmitConfInvite(stringArray, yahooIdentity.getId(), string2, string);
        try {
            return this.getConference(string2);
        }
        catch (NoSuchConferenceException noSuchConferenceException) {
            return null;
        }
    }

    public void acceptConferenceInvite(YahooConference yahooConference) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogon(yahooConference.getName(), yahooConference.getIdentity().getId());
    }

    public void declineConferenceInvite(YahooConference yahooConference, String string) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfDecline(yahooConference.getName(), yahooConference.getIdentity().getId(), string);
    }

    public void extendConference(YahooConference yahooConference, String string, String string2) throws IllegalStateException, IOException, NoSuchConferenceException, IllegalIdentityException {
        this.checkStatus();
        String[] stringArray = new String[]{string};
        this.checkIdentityNotOnList(stringArray);
        this.transmitConfAddInvite(string, yahooConference.getName(), yahooConference.getIdentity().getId(), string2);
    }

    public void sendConferenceMessage(YahooConference yahooConference, String string) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfMsg(yahooConference.getName(), yahooConference.getIdentity().getId(), string);
    }

    public void leaveConference(YahooConference yahooConference) throws IllegalStateException, IOException, NoSuchConferenceException {
        this.checkStatus();
        this.transmitConfLogoff(yahooConference.getName(), yahooConference.getIdentity().getId());
    }

    public void addFriend(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendAdd(string, string2);
    }

    public void removeFriend(String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitFriendRemove(string, string2);
    }

    public void rejectContact(SessionEvent sessionEvent, String string) throws IllegalArgumentException, IllegalStateException, IOException {
        if (sessionEvent.getFrom() == null || sessionEvent.getTo() == null) {
            throw new IllegalArgumentException("Missing to or from field in event object.");
        }
        this.checkStatus();
        this.transmitContactReject(sessionEvent.getFrom(), sessionEvent.getTo(), string);
    }

    public void ignoreContact(String string, boolean bl) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitContactIgnore(string, bl);
    }

    public void refreshFriends() throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitList();
    }

    public void rejectFriendAuthorization(SessionAuthorizationEvent sessionAuthorizationEvent, String string, String string2) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitRejectBuddy(string, sessionAuthorizationEvent.getTo(), string2);
    }

    public void acceptFriendAuthorization(SessionAuthorizationEvent sessionAuthorizationEvent, String string) throws IllegalStateException, IOException {
        this.checkStatus();
        this.transmitAcceptBuddy(string, sessionAuthorizationEvent.getTo());
    }

    public void sendFileTransfer(String string, String string2, String string3) throws IllegalStateException, FileTransferFailedException, IOException {
        this.checkStatus();
        YahooUser yahooUser = this.userStore.get(string);
        if (yahooUser == null || yahooUser.versionId > 500000L) {
            // empty if block
        }
        this.transmitFileTransfer(string, string3, string2);
    }

    public void saveFileTransferAs(SessionFileTransferEvent sessionFileTransferEvent, String string) throws FileTransferFailedException, IOException {
        this.saveFT(sessionFileTransferEvent, null, string);
    }

    public void saveFileTransferTo(SessionFileTransferEvent sessionFileTransferEvent, String string) throws FileTransferFailedException, IOException {
        if (!string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        this.saveFT(sessionFileTransferEvent, string, sessionFileTransferEvent.getFilenameFromLocation());
    }

    private void saveFT(SessionFileTransferEvent sessionFileTransferEvent, String string, String string2) throws FileTransferFailedException, IOException {
        int n;
        byte[] byArray = new byte[4096];
        String string3 = "Content-Disposition: filename=";
        HTTPConnection hTTPConnection = new HTTPConnection("GET", sessionFileTransferEvent.getLocation());
        hTTPConnection.println("Host: " + sessionFileTransferEvent.getLocation().getHost());
        hTTPConnection.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        hTTPConnection.println("Cookie: " + this.cookieY + "; " + this.cookieT);
        hTTPConnection.println("");
        hTTPConnection.flush();
        String string4 = hTTPConnection.readLine();
        if (string4.indexOf(" 200 ") < 0) {
            throw new FileTransferFailedException("Server HTTP error code: " + string4);
        }
        do {
            string4 = hTTPConnection.readLine();
            if (string == null || string4 == null || !string4.startsWith(string3) || (string2 = string4.substring(string3.length())).charAt(0) != '\"') continue;
            string2 = string2.substring(1, string2.length() - 1);
        } while (string4 != null && string4.trim().length() > 0);
        if (string4 == null) {
            throw new FileTransferFailedException("Server premature end of reply");
        }
        if (string != null) {
            string2 = string + string2;
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
        do {
            if ((n = hTTPConnection.read(byArray)) <= 0) continue;
            dataOutputStream.write(byArray, 0, n);
        } while (n >= 0);
        dataOutputStream.flush();
        dataOutputStream.close();
        hTTPConnection.close();
    }

    public synchronized void chatLogin(YahooChatLobby yahooChatLobby) throws IllegalStateException, IOException, LoginRefusedException {
        this.chatLogin(yahooChatLobby, this.identityIdToObject(this.loginID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void chatLogin(YahooChatLobby yahooChatLobby, YahooIdentity yahooIdentity) throws IllegalStateException, IOException, LoginRefusedException, IllegalIdentityException {
        this.checkStatus();
        this.checkIdentity(yahooIdentity);
        if (this.chatSessionStatus != 0 && this.chatSessionStatus != 2) {
            throw new IllegalStateException("Chat session should be unstarted or messaging");
        }
        this.chatConnectOver = false;
        this.chatLoginOver = false;
        this.chatID = yahooIdentity.getId();
        try {
            long l = System.currentTimeMillis() + (long)Util.loginTimeout(60);
            if (this.currentLobby == null) {
                this.transmitChatConnect(yahooIdentity.getId());
                while (!this.chatConnectOver && !this.past(l)) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.past(l)) {
                    throw new InterruptedIOException("Chat connect timed out");
                }
            }
            this.transmitChatLogon(yahooChatLobby.getNetworkName(), yahooChatLobby.getParent().getId());
            while (!this.chatLoginOver && !this.past(l)) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.past(l)) {
                throw new InterruptedIOException("Chat login timed out");
            }
            if (this.chatSessionStatus == 3 && this.loginException != null) {
                throw (LoginRefusedException)this.loginException;
            }
            this.currentLobby = this.chatSessionStatus == 2 ? yahooChatLobby : null;
        }
        finally {
            if (this.chatSessionStatus != 2) {
                this.chatSessionStatus = 3;
                this.chatID = null;
            }
        }
    }

    public synchronized void chatLogout() throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatDisconnect(this.currentLobby.getNetworkName());
        this.currentLobby = null;
    }

    public void sendChatMessage(String string) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), string, false);
    }

    public void sendChatEmote(String string) throws IllegalStateException, IOException {
        this.checkStatus();
        this.checkChatStatus();
        this.transmitChatMsg(this.currentLobby.getNetworkName(), string, true);
    }

    public YahooChatLobby getCurrentChatLobby() {
        return this.currentLobby;
    }

    public int getChatSessionStatus() {
        return this.chatSessionStatus;
    }

    public void resetChat() throws IllegalStateException {
        if (this.chatSessionStatus != 3 && this.chatSessionStatus != 0) {
            throw new IllegalStateException("Chat session currently active");
        }
        this.chatSessionStatus = 0;
    }

    public void __test1(String string, String string2) {
        try {
            this.network.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void __test2() {
    }

    protected void transmitAuth() throws IOException {
        this.sessionStatus = 1;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        this.sendPacket(packetBodyBuffer, 87);
    }

    protected void transmitAuthResp(String string, String string2, String string3) throws IOException {
        if (string3 == null) {
            PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
            packetBodyBuffer.addElement("0", this.loginID);
            packetBodyBuffer.addElement("6", string);
            packetBodyBuffer.addElement("96", string2);
            packetBodyBuffer.addElement("2", this.loginID);
            packetBodyBuffer.addElement("2", "1");
            packetBodyBuffer.addElement("244", "2097087");
            packetBodyBuffer.addElement("148", "180");
            packetBodyBuffer.addElement("135", "9.0.0.2152");
            packetBodyBuffer.addElement("1", this.loginID);
            if (this.picture != null && this.getPictureChecksum() != null) {
                packetBodyBuffer.addElement("192", this.getPictureChecksum());
            }
            this.sendPacket(packetBodyBuffer, 84, this.status);
        } else {
            PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
            packetBodyBuffer.addElement("1", this.loginID);
            packetBodyBuffer.addElement("0", this.loginID);
            packetBodyBuffer.addElement("277", string);
            packetBodyBuffer.addElement("278", string2);
            packetBodyBuffer.addElement("307", string3);
            packetBodyBuffer.addElement("244", "4194239");
            packetBodyBuffer.addElement("2", this.loginID);
            packetBodyBuffer.addElement("2", "1");
            packetBodyBuffer.addElement("135", "9.0.0.2152");
            if (this.picture != null && this.getPictureChecksum() != null) {
                packetBodyBuffer.addElement("192", this.getPictureChecksum());
            }
            this.sendPacket(packetBodyBuffer, 84, this.status);
        }
    }

    protected void transmitChatConnect(String string) throws IOException {
        this.chatSessionStatus = 100;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("109", this.primaryID);
        packetBodyBuffer.addElement("1", string);
        packetBodyBuffer.addElement("6", "abcde");
        packetBodyBuffer.addElement("98", YahooChatCategory.getLocale());
        packetBodyBuffer.addElement("135", "9.0.0.2152");
        this.sendPacket(packetBodyBuffer, 150);
    }

    protected void transmitChatDisconnect(String string) throws IOException {
        this.chatSessionStatus = 0;
        this.currentLobby = null;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("109", this.chatID);
        this.sendPacket(packetBodyBuffer, 160);
    }

    protected void transmitChatLogon(String string, long l) throws IOException {
        this.chatSessionStatus = 1;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.chatID);
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("129", "" + l);
        packetBodyBuffer.addElement("62", "2");
        this.sendPacket(packetBodyBuffer, 152);
    }

    protected void transmitChatMsg(String string, String string2, boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.chatID);
        packetBodyBuffer.addElement("104", string);
        packetBodyBuffer.addElement("117", string2);
        if (bl) {
            packetBodyBuffer.addElement("124", "2");
        } else {
            packetBodyBuffer.addElement("124", "1");
        }
        if (Util.isUtf8(string2)) {
            packetBodyBuffer.addElement("97", "1");
        }
        this.sendPacket(packetBodyBuffer, 168);
    }

    protected void transmitChatPM(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("14", string2);
        this.sendPacket(packetBodyBuffer, 32);
    }

    protected void transmitChatPing() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.sendPacket(packetBodyBuffer, 161);
    }

    protected void transmitConfAddInvite(String string, String string2, String string3, String string4) throws IOException, NoSuchConferenceException {
        int n;
        this.getConference(string2);
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string3);
        packetBodyBuffer.addElement("51", string);
        packetBodyBuffer.addElement("57", string2);
        Vector vector = this.getConference(string2).getUsers();
        for (n = 0; n < vector.size(); ++n) {
            packetBodyBuffer.addElement("52", ((YahooUser)vector.elementAt(n)).getId());
        }
        for (n = 0; n < vector.size(); ++n) {
            packetBodyBuffer.addElement("53", ((YahooUser)vector.elementAt(n)).getId());
        }
        packetBodyBuffer.addElement("58", string4);
        packetBodyBuffer.addElement("13", "0");
        this.sendPacket(packetBodyBuffer, 28);
    }

    protected void transmitConfDecline(String string, String string2, String string3) throws IOException, NoSuchConferenceException {
        YahooConference yahooConference = this.getConference(string);
        yahooConference.closeConference();
        Vector vector = yahooConference.getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (int i = 0; i < vector.size(); ++i) {
            packetBodyBuffer.addElement("3", ((YahooUser)vector.elementAt(i)).getId());
        }
        packetBodyBuffer.addElement("57", string);
        packetBodyBuffer.addElement("14", string3);
        this.sendPacket(packetBodyBuffer, 26);
    }

    protected void transmitConfInvite(String[] stringArray, String string, String string2, String string3) throws IOException {
        this.conferences.put(string2, new YahooConference(this.userStore, this.identityIdToObject(string), string2, this, false));
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string);
        packetBodyBuffer.addElement("50", this.primaryID);
        for (int i = 0; i < stringArray.length; ++i) {
            packetBodyBuffer.addElement("52", stringArray[i]);
        }
        packetBodyBuffer.addElement("57", string2);
        packetBodyBuffer.addElement("58", string3);
        packetBodyBuffer.addElement("13", "0");
        this.sendPacket(packetBodyBuffer, 24);
    }

    protected void transmitConfLogoff(String string, String string2) throws IOException, NoSuchConferenceException {
        YahooConference yahooConference = this.getConference(string);
        yahooConference.closeConference();
        Vector vector = yahooConference.getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (int i = 0; i < vector.size(); ++i) {
            packetBodyBuffer.addElement("3", ((YahooUser)vector.elementAt(i)).getId());
        }
        packetBodyBuffer.addElement("57", string);
        this.sendPacket(packetBodyBuffer, 27);
    }

    protected void transmitConfLogon(String string, String string2) throws IOException, NoSuchConferenceException {
        Vector vector = this.getConference(string).getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (int i = 0; i < vector.size(); ++i) {
            packetBodyBuffer.addElement("3", ((YahooUser)vector.elementAt(i)).getId());
        }
        packetBodyBuffer.addElement("57", string);
        this.sendPacket(packetBodyBuffer, 25);
    }

    protected void transmitConfMsg(String string, String string2, String string3) throws IOException, NoSuchConferenceException {
        Vector vector = this.getConference(string).getUsers();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        for (int i = 0; i < vector.size(); ++i) {
            packetBodyBuffer.addElement("53", ((YahooUser)vector.elementAt(i)).getId());
        }
        packetBodyBuffer.addElement("57", string);
        packetBodyBuffer.addElement("14", string3);
        if (Util.isUtf8(string3)) {
            packetBodyBuffer.addElement("97", "1");
        }
        this.sendPacket(packetBodyBuffer, 29);
    }

    protected void transmitContactIgnore(String string, boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID);
        packetBodyBuffer.addElement("7", string);
        if (bl) {
            packetBodyBuffer.addElement("13", "1");
        } else {
            packetBodyBuffer.addElement("13", "2");
        }
        this.sendPacket(packetBodyBuffer, 133);
    }

    protected void transmitContactReject(String string, String string2, String string3) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("14", string3);
        this.sendPacket(packetBodyBuffer, 134);
    }

    protected void transmitRejectBuddy(String string, String string2, String string3) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("13", "2");
        if (string3 != null) {
            packetBodyBuffer.addElement("14", string3);
        }
        this.sendPacket(packetBodyBuffer, 214);
    }

    protected void transmitAcceptBuddy(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("13", "1");
        this.sendPacket(packetBodyBuffer, 214);
    }

    protected void transmitFileTransfer(String string, String string2, String string3) throws FileTransferFailedException, IOException {
        String string4;
        String string5 = this.cookieY + "; " + this.cookieT;
        int n = -1;
        byte[] byArray = new byte[]{50, 57, -64, -128};
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string3));
        n = dataInputStream.available();
        if (n <= 0) {
            throw new FileTransferFailedException("File transfer: missing or empty file");
        }
        byte[] byArray2 = new byte[n];
        dataInputStream.readFully(byArray2);
        dataInputStream.close();
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.primaryID);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("28", n + "");
        packetBodyBuffer.addElement("27", new File(string3).getName());
        packetBodyBuffer.addElement("14", string2);
        byte[] byArray3 = packetBodyBuffer.getBuffer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.write(MAGIC, 0, 4);
        dataOutputStream.write(VERSION, 0, 4);
        dataOutputStream.writeShort(byArray3.length + 4 & 0xFFFF);
        dataOutputStream.writeShort(70);
        dataOutputStream.writeInt((int)(this.status & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
        dataOutputStream.write(byArray3, 0, byArray3.length);
        dataOutputStream.write(byArray, 0, 4);
        byArray3 = byteArrayOutputStream.toByteArray();
        String string6 = Util.fileTransferHost();
        String string7 = "http://" + string6 + ":80/notifyft";
        HTTPConnection hTTPConnection = new HTTPConnection("POST", new URL(string7));
        hTTPConnection.println("Content-Length: " + (n + byArray3.length));
        hTTPConnection.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
        hTTPConnection.println("Host: " + string6);
        hTTPConnection.println("Cookie: " + string5);
        hTTPConnection.println("");
        hTTPConnection.write(byArray3);
        hTTPConnection.write(byArray2);
        hTTPConnection.flush();
        String string8 = string4 = hTTPConnection.readLine();
        if (string4 != null) {
            byte[] byArray4 = new byte[4096];
            while (hTTPConnection.read(byArray4) > 0) {
            }
        }
        hTTPConnection.close();
        if (string8.indexOf(" 200 ") < 0) {
            throw new FileTransferFailedException("Server rejected upload");
        }
    }

    protected void transmitFriendAdd(String string, String string2) throws IOException {
        if (string.contains("id=")) {
            string = string.substring(3, string.indexOf(" "));
        }
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID);
        packetBodyBuffer.addElement("302", "319");
        packetBodyBuffer.addElement("300", "319");
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("241", "0");
        packetBodyBuffer.addElement("301", "319");
        packetBodyBuffer.addElement("303", "319");
        packetBodyBuffer.addElement("65", string2);
        packetBodyBuffer.addElement("14", "");
        packetBodyBuffer.addElement("216", "");
        packetBodyBuffer.addElement("254", "");
        packetBodyBuffer.addElement("97", "1");
        this.sendPacket(packetBodyBuffer, 131);
    }

    protected void transmitFriendRemove(String string, String string2) throws IOException {
        if (string.contains("id=")) {
            string = string.substring(3, string.indexOf(" "));
        }
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID);
        packetBodyBuffer.addElement("7", string);
        packetBodyBuffer.addElement("65", string2);
        this.sendPacket(packetBodyBuffer, 132);
    }

    protected void transmitGroupRename(String string, String string2) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID);
        packetBodyBuffer.addElement("65", string);
        packetBodyBuffer.addElement("67", string2);
        this.sendPacket(packetBodyBuffer, 19);
    }

    protected void transmitIdActivate(String string) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("3", string);
        this.sendPacket(packetBodyBuffer, 7);
    }

    protected void transmitIdDeactivate(String string) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("3", string);
        this.sendPacket(packetBodyBuffer, 8);
    }

    protected void transmitIdle() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("0", this.primaryID);
        this.sendPacket(packetBodyBuffer, 5);
    }

    protected void transmitIsAway() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("10", this.status + "");
        packetBodyBuffer.addElement("138", "");
        this.sendPacket(packetBodyBuffer, 198, 0L);
    }

    protected void transmitIsAway(String string, boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.status = 99L;
        packetBodyBuffer.addElement("10", this.status + "");
        packetBodyBuffer.addElement("19", string);
        if (bl) {
            packetBodyBuffer.addElement("47", "1");
        } else {
            packetBodyBuffer.addElement("47", "0");
        }
        packetBodyBuffer.addElement("138", "");
        this.sendPacket(packetBodyBuffer, 198, 0L);
    }

    protected void transmitToggleVisibility(boolean bl) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        if (bl) {
            packetBodyBuffer.addElement("13", "1");
        } else {
            packetBodyBuffer.addElement("13", "2");
        }
        this.sendPacket(packetBodyBuffer, 197, 0L);
    }

    protected void transmitIsBack() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("10", this.status + "");
        packetBodyBuffer.addElement("138", "");
        this.sendPacket(packetBodyBuffer, 198, 0L);
    }

    protected void transmitList() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.primaryID);
        this.sendPacket(packetBodyBuffer, 85);
    }

    protected void transmitLogoff() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.loginID);
        this.sendPacket(packetBodyBuffer, 2);
    }

    protected void transmitMessage(String string, String string2, String string3) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("0", this.primaryID);
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("14", string3);
        if (Util.isUtf8(string3)) {
            packetBodyBuffer.addElement("97", "1");
        }
        packetBodyBuffer.addElement("63", ";" + this.imvironment);
        packetBodyBuffer.addElement("64", "0");
        this.sendPacket(packetBodyBuffer, 6, 0x5A55AA56L);
        TypingNotifier typingNotifier = (TypingNotifier)this.typingNotifiers.get(string);
        if (typingNotifier != null) {
            typingNotifier.stopTyping();
        }
    }

    protected void transmitNotify(String string, String string2, boolean bl, String string3, String string4) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", string2);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("14", string3);
        if (bl) {
            packetBodyBuffer.addElement("13", "1");
        } else {
            packetBodyBuffer.addElement("13", "0");
        }
        packetBodyBuffer.addElement("49", string4);
        this.sendPacket(packetBodyBuffer, 75, 22L);
    }

    protected void transmitPing() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.sendPacket(packetBodyBuffer, 18);
    }

    protected void transmitUserStat() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        this.sendPacket(packetBodyBuffer, 10);
    }

    protected void receiveAddIgnore(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveAuth(YMSG9Packet yMSG9Packet) throws IOException, NoSuchAlgorithmException, LoginRefusedException {
        String[] stringArray;
        String string = yMSG9Packet.getValue("13");
        String string2 = yMSG9Packet.getValue("94");
        try {
            stringArray = string != null && string.equals("1") ? ChallengeResponseV10.getStrings(this.loginID, this.password, string2) : (string != null && string.equals("0") ? ChallengeResponseV9.getStrings(this.loginID, this.password, string2) : this.yahooAuth16Stage1(string2));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw noSuchAlgorithmException;
        }
        catch (LoginRefusedException loginRefusedException) {
            throw loginRefusedException;
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("auth", false, exception);
        }
        if (stringArray.length > 2) {
            this.transmitAuthResp(stringArray[0], stringArray[1], stringArray[2]);
        } else {
            this.transmitAuthResp(stringArray[0], stringArray[1], null);
        }
    }

    private void throwLoginRefused(String string, long l) throws LoginRefusedException {
        LoginRefusedException loginRefusedException = new LoginRefusedException(string, l);
        this.loginException = loginRefusedException;
        this.ipThread.quit = true;
        this.sessionStatus = 3;
        this.loginOver = true;
        throw loginRefusedException;
    }

    private String[] yahooAuth16Stage1(String string) throws LoginRefusedException, IOException, NoSuchAlgorithmException {
        int n;
        String string2 = "https://login.yahoo.com/config/pwtoken_get?src=ymsgr&ts=&login=" + this.loginID + "&passwd=" + URLEncoder.encode(this.password, "UTF-8") + "&chal=" + URLEncoder.encode(string, "UTF-8");
        URL uRL = new URL(string2);
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) == 200) {
            String string3;
            InputStream inputStream = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = -1;
            byte[] byArray = new byte[256];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\r\n");
            if (stringTokenizer.countTokens() <= 0) {
                this.throwLoginRefused("Login Failed, wrong response in stage 1:" + ((HttpURLConnection)uRLConnection).getResponseMessage(), -1L);
            }
            int n3 = -1;
            try {
                n3 = Integer.valueOf(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                this.throwLoginRefused("Login Failed, wrong response in stage 1:" + ((HttpURLConnection)uRLConnection).getResponseMessage(), -1L);
            }
            if (n3 != 0 || !stringTokenizer.hasMoreTokens()) {
                switch (n3) {
                    case 1235: {
                        this.throwLoginRefused("Login Failed, Invalid username", 3L);
                    }
                    case 1212: {
                        this.throwLoginRefused("Login Failed, Wrong password", 13L);
                    }
                    case 1213: {
                        this.throwLoginRefused("Login locked: Too many failed login attempts", 14L);
                    }
                    case 1236: {
                        this.throwLoginRefused("Login locked", 14L);
                    }
                    case 100: {
                        this.throwLoginRefused("Username or password missing", 13L);
                    }
                }
                this.throwLoginRefused("Login Failed, Unkown error", 13L);
            }
            if ((string3 = stringTokenizer.nextToken()).indexOf("ymsgr=") == -1 && stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            string3 = string3.replaceAll("ymsgr=", "");
            return this.yahooAuth16Stage2(string3, string);
        }
        this.throwLoginRefused("Login Failed, unable to retrieve stage 1 url", -1L);
        return new String[0];
    }

    private String[] yahooAuth16Stage2(String string, String string2) throws LoginRefusedException, IOException, NoSuchAlgorithmException {
        int n;
        String string3 = "https://login.yahoo.com/config/pwtoken_login?src=ymsgr&ts=&token=" + string;
        URL uRL = new URL(string3);
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && (n = ((HttpURLConnection)uRLConnection).getResponseCode()) == 200) {
            InputStream inputStream = uRLConnection.getInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = -1;
            byte[] byArray = new byte[256];
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            int n3 = -1;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(byteArrayOutputStream.toString(), "\r\n");
            if (stringTokenizer.countTokens() <= 0) {
                this.throwLoginRefused("Login Failed, wrong response in stage 2:" + ((HttpURLConnection)uRLConnection).getResponseMessage(), -1L);
            }
            try {
                n3 = Integer.valueOf(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                this.throwLoginRefused("Login Failed, wrong response in stage 2:" + ((HttpURLConnection)uRLConnection).getResponseMessage(), -1L);
            }
            if (n3 != 0 || !stringTokenizer.hasMoreTokens()) {
                this.throwLoginRefused("Login Failed, Unkown error", 13L);
            }
            while (stringTokenizer.hasMoreTokens()) {
                String string7 = stringTokenizer.nextToken();
                if (string7.startsWith("crumb=")) {
                    string4 = string7.replaceAll("crumb=", "");
                    continue;
                }
                if (string7.startsWith("Y=")) {
                    string5 = string7.replaceAll("Y=", "");
                    continue;
                }
                if (!string7.startsWith("T=")) continue;
                string6 = string7.replaceAll("T=", "");
            }
            if (string4 == null || string6 == null || string5 == null) {
                this.throwLoginRefused("Login Failed, Unkown error", 13L);
            }
            this.cookieY = string5;
            this.cookieT = string6;
            return this.yahooAuth16Stage3(string4 + string2, string5, string6);
        }
        this.throwLoginRefused("Login Failed, unable to retrieve stage 2 url", -1L);
        return new String[0];
    }

    private String[] yahooAuth16Stage3(String string, String string2, String string3) throws NoSuchAlgorithmException {
        return ChallengeResponseV16.getStrings(string2, string3, string);
    }

    protected void receiveAuthResp(YMSG9Packet yMSG9Packet) {
        block10: {
            try {
                if (!yMSG9Packet.exists("66")) break block10;
                long l = Long.parseLong(yMSG9Packet.getValue("66"));
                if (l == 14L) {
                    URL uRL;
                    try {
                        uRL = new URL(yMSG9Packet.getValue("20"));
                    }
                    catch (Exception exception) {
                        uRL = null;
                    }
                    this.loginException = new AccountLockedException("User " + this.loginID + " has been locked out", uRL);
                    break block10;
                }
                if (l == 13L || l == 29L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " refused login", l);
                } else if (l == 3L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " unknown", l);
                } else if (l == 99L) {
                    this.loginException = new LoginRefusedException("User " + this.loginID + " unknown", l);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.ipThread.quit = true;
        this.sessionStatus = 3;
        this.loginOver = true;
    }

    protected void receiveChatConnect(YMSG9Packet yMSG9Packet) {
        this.chatConnectOver = true;
    }

    protected void receiveChatDisconnect(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != 0) {
            new FireEvent().fire(new SessionEvent(this), 160);
        }
        this.chatSessionStatus = 0;
    }

    protected void receiveChatLogoff(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("104");
            String string2 = yMSG9Packet.getValue("109");
            YahooChatLobby yahooChatLobby = YahooChatCategory.getLobby(string);
            if (yahooChatLobby == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + string + " not found.");
            }
            YahooChatUser yahooChatUser = yahooChatLobby.getUser(string2);
            if (yahooChatUser != null) {
                yahooChatLobby.removeUser(yahooChatUser);
            } else {
                yahooChatUser = this.createChatUser(yMSG9Packet, 0);
            }
            SessionChatEvent sessionChatEvent = new SessionChatEvent((Object)this, 1, yahooChatLobby);
            sessionChatEvent.setChatUser(0, yahooChatUser);
            new FireEvent().fire(sessionChatEvent, 155);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("chat logoff", false, exception);
        }
    }

    protected void receiveChatLogon(YMSG9Packet yMSG9Packet) {
        boolean bl = false;
        try {
            int n;
            if (yMSG9Packet.exists("114")) {
                this.loginException = new LoginRefusedException("User " + this.chatID + " refused chat login");
                bl = true;
                this.chatSessionStatus = 3;
                return;
            }
            if ((yMSG9Packet = this.compoundChatLoginPacket(yMSG9Packet)) == null) {
                return;
            }
            String string = yMSG9Packet.getValue("104");
            YahooChatLobby yahooChatLobby = YahooChatCategory.getLobby(string);
            if (yahooChatLobby == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + string + " not found.");
            }
            for (n = Integer.parseInt(yMSG9Packet.getValue("108")); n > 0 && yMSG9Packet.getNthValue("109", n - 1) == null; --n) {
            }
            YahooChatUser yahooChatUser = yahooChatLobby.getUser(yMSG9Packet.getValue("109"));
            if (n == 1 && yahooChatUser != null) {
                yahooChatUser.update(yMSG9Packet.getValue("113"), yMSG9Packet.getValue("141"), yMSG9Packet.getValue("110"), yMSG9Packet.getValue("142"));
                SessionChatEvent sessionChatEvent = new SessionChatEvent((Object)this, 1, yahooChatLobby);
                sessionChatEvent.setChatUser(0, yahooChatUser);
                new FireEvent().fire(sessionChatEvent, 3844);
                return;
            }
            this.currentLobby = yahooChatLobby;
            bl = yMSG9Packet.exists("13");
            if (bl) {
                yahooChatLobby.clearUsers();
            }
            Hashtable<String, YahooChatUser> hashtable = new Hashtable<String, YahooChatUser>();
            for (int i = 0; i < n; ++i) {
                yahooChatUser = this.createChatUser(yMSG9Packet, i);
                hashtable.put(yahooChatUser.getId(), yahooChatUser);
            }
            SessionChatEvent sessionChatEvent = new SessionChatEvent((Object)this, n, yahooChatLobby);
            int n2 = 0;
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                yahooChatUser = (YahooChatUser)enumeration.nextElement();
                if (!yahooChatLobby.exists(yahooChatUser)) {
                    yahooChatLobby.addUser(yahooChatUser);
                }
                sessionChatEvent.setChatUser(n2++, yahooChatUser);
            }
            if (!bl) {
                if (sessionChatEvent.getChatUsers().length > 0) {
                    new FireEvent().fire(sessionChatEvent, 152);
                }
            } else {
                this.chatSessionStatus = 2;
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new YMSG9BadFormatException("chat login", false, exception);
        }
        finally {
            if (bl) {
                this.chatLoginOver = true;
            }
        }
    }

    protected void receiveChatMsg(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != 2) {
            return;
        }
        try {
            String string = yMSG9Packet.getValue("104");
            YahooChatLobby yahooChatLobby = YahooChatCategory.getLobby(string);
            if (yahooChatLobby == null) {
                throw new NoSuchChatroomException("Chatroom/lobby " + string + " not found.");
            }
            YahooChatUser yahooChatUser = yahooChatLobby.getUser(yMSG9Packet.getValue("109"));
            if (yahooChatUser == null) {
                yahooChatUser = this.createChatUser(yMSG9Packet, 0);
            }
            SessionChatEvent sessionChatEvent = new SessionChatEvent((Object)this, yahooChatUser, yMSG9Packet.getValue("117"), yMSG9Packet.getValue("124"), yahooChatLobby);
            new FireEvent().fire(sessionChatEvent, 168);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("chat message", false, exception);
        }
    }

    protected void receiveChatPM(YMSG9Packet yMSG9Packet) {
        if (this.chatSessionStatus != 2) {
            return;
        }
        try {
            SessionEvent sessionEvent = new SessionEvent(this, yMSG9Packet.getValue("5"), yMSG9Packet.getValue("4"), yMSG9Packet.getValue("14"));
            new FireEvent().fire(sessionEvent, 6);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("chat PM", false, exception);
        }
    }

    protected void receiveConfAddInvite(YMSG9Packet yMSG9Packet) {
        this.receiveConfInvite(yMSG9Packet);
    }

    protected void receiveConfDecline(YMSG9Packet yMSG9Packet) {
        try {
            YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
            SessionConferenceEvent sessionConferenceEvent = new SessionConferenceEvent(this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("54"), yMSG9Packet.getValue("14"), yahooConference, null);
            yahooConference.removeUser(sessionConferenceEvent.getFrom());
            if (!yahooConference.isClosed()) {
                new FireEvent().fire(sessionConferenceEvent, 26);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference decline", false, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfInvite(YMSG9Packet yMSG9Packet) {
        try {
            YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
            String[] stringArray = yMSG9Packet.getValues("52");
            SessionConferenceEvent sessionConferenceEvent = new SessionConferenceEvent(this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("50"), yMSG9Packet.getValue("58"), yahooConference, this.userStore.toUserArray(stringArray));
            yahooConference.addUsers(stringArray);
            yahooConference.addUser(sessionConferenceEvent.getFrom());
            if (!yahooConference.isClosed()) {
                new FireEvent().fire(sessionConferenceEvent, 24);
            }
            YahooConference yahooConference2 = yahooConference;
            synchronized (yahooConference2) {
                Vector vector = yahooConference.inviteReceived();
                for (int i = 0; i < vector.size(); ++i) {
                    this.ipThread.process((YMSG9Packet)vector.elementAt(i));
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference invite", false, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogoff(YMSG9Packet yMSG9Packet) {
        YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
        Object object = yahooConference;
        synchronized (object) {
            if (!yahooConference.isInvited()) {
                yahooConference.addPacket(yMSG9Packet);
                return;
            }
        }
        try {
            object = new SessionConferenceEvent((Object)this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("56"), null, yahooConference);
            yahooConference.removeUser(((SessionEvent)object).getFrom());
            if (!yahooConference.isClosed()) {
                new FireEvent().fire((SessionEvent)object, 27);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference logoff", false, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfLogon(YMSG9Packet yMSG9Packet) {
        YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
        Object object = yahooConference;
        synchronized (object) {
            if (!yahooConference.isInvited()) {
                yahooConference.addPacket(yMSG9Packet);
                return;
            }
        }
        try {
            object = new SessionConferenceEvent((Object)this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("53"), null, yahooConference);
            yahooConference.addUser(((SessionEvent)object).getFrom());
            if (!yahooConference.isClosed()) {
                new FireEvent().fire((SessionEvent)object, 25);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference logon", false, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveConfMsg(YMSG9Packet yMSG9Packet) {
        YahooConference yahooConference = this.getOrCreateConference(yMSG9Packet);
        Object object = yahooConference;
        synchronized (object) {
            if (!yahooConference.isInvited()) {
                yahooConference.addPacket(yMSG9Packet);
                return;
            }
        }
        try {
            object = new SessionConferenceEvent((Object)this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("3"), yMSG9Packet.getValue("14"), yahooConference);
            if (!yahooConference.isClosed()) {
                new FireEvent().fire((SessionEvent)object, 29);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("conference mesg", false, exception);
        }
    }

    protected void receiveContactIgnore(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("0");
            boolean bl = yMSG9Packet.getValue("13").charAt(0) == '1';
            int n = Integer.parseInt(yMSG9Packet.getValue("66"));
            if (n == 0) {
                YahooUser yahooUser = this.userStore.getOrCreate(string);
                yahooUser.setIgnored(bl);
                SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, 1);
                sessionFriendEvent.setUser(0, yahooUser);
                new FireEvent().fire(sessionFriendEvent, 3);
            } else {
                String string2 = "Contact ignore error: ";
                switch (n) {
                    case 2: {
                        string2 = string2 + "Already on ignore list";
                        break;
                    }
                    case 3: {
                        string2 = string2 + "Not currently ignored";
                        break;
                    }
                    case 12: {
                        string2 = string2 + "Cannot ignore friend";
                        break;
                    }
                    default: {
                        string2 = string2 + "Unknown error";
                    }
                }
                this.errorMessage(yMSG9Packet, string2);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("contact ignore", false, exception);
        }
    }

    protected void receiveContactNew(YMSG9Packet yMSG9Packet) {
        try {
            if (yMSG9Packet.length <= 0) {
                return;
            }
            if (yMSG9Packet.exists("7")) {
                this.updateFriendsStatus(yMSG9Packet);
                return;
            }
            if (yMSG9Packet.status == 7L) {
                SessionEvent sessionEvent = new SessionEvent(this, null, yMSG9Packet.getValue("3"), yMSG9Packet.getValue("14"));
                new FireEvent().fire(sessionEvent, 134);
            } else {
                SessionEvent sessionEvent = new SessionEvent(this, yMSG9Packet.getValue("1"), yMSG9Packet.getValue("3"), yMSG9Packet.getValue("14"), yMSG9Packet.getValue("15"));
                sessionEvent.setStatus(yMSG9Packet.status);
                new FireEvent().fire(sessionEvent, 15);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("contact request", false, exception);
        }
    }

    protected void receiveAuthorization(YMSG9Packet yMSG9Packet) {
        try {
            if (yMSG9Packet.length <= 0) {
                return;
            }
            String string = yMSG9Packet.getValue("4");
            String string2 = yMSG9Packet.getValue("14");
            String string3 = yMSG9Packet.getValue("216");
            String string4 = yMSG9Packet.getValue("254");
            String string5 = yMSG9Packet.getValue("5");
            int n = -1;
            String string6 = yMSG9Packet.getValue("13");
            if (string6 != null) {
                try {
                    n = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.log(Level.FINER, "state not a number", numberFormatException);
                }
            }
            SessionAuthorizationEvent sessionAuthorizationEvent = new SessionAuthorizationEvent(this, string5, string, string3, string4, string2);
            sessionAuthorizationEvent.setStatus(n);
            new FireEvent().fire(sessionAuthorizationEvent, 214);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("contact request", false, exception);
        }
    }

    protected void receiveFileTransfer(YMSG9Packet yMSG9Packet) {
        try {
            if (!yMSG9Packet.exists("38")) {
                SessionEvent sessionEvent = new SessionEvent(this, yMSG9Packet.getValue("5"), yMSG9Packet.getValue("4"), yMSG9Packet.getValue("14"));
                new FireEvent().fire(sessionEvent, 6);
            } else {
                SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)this, yMSG9Packet.getValue("5"), yMSG9Packet.getValue("4"), yMSG9Packet.getValue("14"), yMSG9Packet.getValue("38"), yMSG9Packet.getValue("20"));
                new FireEvent().fire(sessionFileTransferEvent, 70);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("file transfer", false, exception);
        }
    }

    protected void receiveFriendAdd(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("7");
            String string2 = yMSG9Packet.getValue("66");
            String string3 = yMSG9Packet.getValue("65");
            YahooUser yahooUser = this.userStore.getOrCreate(string);
            this.insertFriend(yahooUser, string3);
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent((Object)this, yahooUser, string3);
            new FireEvent().fire(sessionFriendEvent, 131);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("friend added", false, exception);
        }
    }

    protected void receiveFriendRemove(YMSG9Packet yMSG9Packet) {
        try {
            String string = yMSG9Packet.getValue("7");
            String string2 = yMSG9Packet.getValue("65");
            YahooUser yahooUser = this.userStore.get(string);
            if (yahooUser == null) {
                this.report("Unknown friend", yMSG9Packet);
                return;
            }
            this.deleteFriend(yahooUser, string2);
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent((Object)this, yahooUser, string2);
            new FireEvent().fire(sessionFriendEvent, 132);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("friend removed", false, exception);
        }
    }

    protected void receiveIdAct(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveIdDeact(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveIsAway(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.exists("7")) {
            this.updateFriendsStatus(yMSG9Packet);
        }
    }

    private void receiveStatus15(YMSG9Packet yMSG9Packet) {
        String string;
        YahooUser yahooUser = null;
        String string2 = null;
        ArrayList<YahooUser> arrayList = new ArrayList<YahooUser>();
        boolean bl = false;
        for (String[] object2 : yMSG9Packet.entries()) {
            String string3 = object2[0];
            if (string3.equals("7")) {
                if (yahooUser != null && string2 != null) {
                    yahooUser.setCustomStatusMessage(string2);
                }
                string2 = null;
                yahooUser = null;
                yahooUser = this.userStore.getOrCreate(object2[1]);
                arrayList.add(yahooUser);
                continue;
            }
            if (string3.equals("10")) {
                if (yahooUser == null) continue;
                int n = Integer.parseInt(object2[1]);
                yahooUser.status = n;
                continue;
            }
            if (string3.equals("19")) {
                string2 = object2[1];
                continue;
            }
            if (string3.equals("13")) {
                if (!object2[1].equals("0")) continue;
                yahooUser.status = 0x5A55AA56L;
                continue;
            }
            if (string3.equals("192")) continue;
            if (string3.equals("241")) {
                bl = true;
                continue;
            }
            if (!string3.equals("244")) continue;
            try {
                if (yahooUser == null) continue;
                yahooUser.versionId = Long.valueOf(object2[1]);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (arrayList.size() > 0) {
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                YahooUser yahooUser2 = (YahooUser)arrayList.get(i);
                sessionFriendEvent.setUser(i, yahooUser2);
            }
            new FireEvent().fire(sessionFriendEvent, 3);
        }
        if (((string = yMSG9Packet.getValue("7")) != null || bl) && !this.loginOver) {
            this.sessionStatus = 2;
            this.loginOver = true;
            this.identities = new YahooIdentity[1];
            this.identities[0] = new YahooIdentity(this.loginID);
            this.primaryID = this.loginID;
            this.identityIdToObject(this.primaryID).setPrimaryIdentity(true);
            this.identityIdToObject(this.loginID).setLoginIdentity(true);
            if (!this.receivedListFired) {
                new FireEvent().fire(new SessionEvent(this), 85);
            }
        }
    }

    protected void receiveIsBack(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.exists("7")) {
            this.updateFriendsStatus(yMSG9Packet);
        }
    }

    protected void receiveList(YMSG9Packet yMSG9Packet) {
        String[] stringArray = new String[]{"87", "88", "89"};
        if (this.cachePacket == null) {
            this.cachePacket = yMSG9Packet;
        } else {
            this.cachePacket.merge(yMSG9Packet, stringArray);
        }
        if (yMSG9Packet.exists("59")) {
            this._receiveList(this.cachePacket);
        }
    }

    private void _receiveList(YMSG9Packet yMSG9Packet) {
        StringTokenizer stringTokenizer;
        String[] stringArray;
        try {
            stringArray = yMSG9Packet.getValue("87");
            if (stringArray != null) {
                stringTokenizer = new StringTokenizer((String)stringArray, "\n");
                this.groups = new YahooGroup[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    this.groups[n] = new YahooGroup(string.substring(0, string.indexOf(":")));
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(string.indexOf(":") + 1), ",");
                    while (stringTokenizer2.hasMoreTokens()) {
                        String string2 = stringTokenizer2.nextToken();
                        YahooUser yahooUser = this.userStore.getOrCreate(string2);
                        this.groups[n].addUser(yahooUser);
                        yahooUser.adjustGroupCount(1);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("friends list in list", false, exception);
        }
        try {
            stringArray = yMSG9Packet.getValue("88");
            if (stringArray != null) {
                stringTokenizer = new StringTokenizer((String)stringArray, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray = stringTokenizer.nextToken();
                    YahooUser yahooUser = this.userStore.getOrCreate((String)stringArray);
                    yahooUser.setIgnored(true);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("ignored list in list", false, exception);
        }
        try {
            stringArray = yMSG9Packet.getValue("89");
            if (stringArray != null) {
                stringTokenizer = new StringTokenizer((String)stringArray, ",");
                int n = 0;
                this.identities = new YahooIdentity[stringTokenizer.countTokens()];
                while (stringTokenizer.hasMoreTokens()) {
                    this.identities[n++] = new YahooIdentity(stringTokenizer.nextToken());
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("identities list in list", false, exception);
        }
        try {
            stringArray = ConnectionHandler.extractCookies(yMSG9Packet);
            this.cookieY = stringArray[0];
            this.cookieT = stringArray[1];
            this.cookieC = stringArray[2];
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("cookies in list", false, exception);
        }
        try {
            this.primaryID = yMSG9Packet.exists("3") ? yMSG9Packet.getValue("3").trim() : this.loginID;
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("primary identity in list", false, exception);
        }
        this.identityIdToObject(this.primaryID).setPrimaryIdentity(true);
        this.identityIdToObject(this.loginID).setLoginIdentity(true);
        if (this.loginOver) {
            new FireEvent().fire(new SessionEvent(this), 85);
        }
    }

    private void receiveList15(YMSG9Packet yMSG9Packet) {
        String string = null;
        YahooGroup yahooGroup = null;
        Vector<YahooGroup> vector = new Vector<YahooGroup>();
        for (String[] stringArray : yMSG9Packet.entries()) {
            int n = Integer.valueOf(stringArray[0]);
            String string2 = stringArray[1];
            switch (n) {
                case 302: {
                    if (string2 == null || !string2.equals("320")) break;
                    yahooGroup = null;
                    break;
                }
                case 301: {
                    YahooUser yahooUser;
                    if (string == null) break;
                    if (yahooGroup != null) {
                        yahooUser = this.userStore.getOrCreate(string);
                        yahooGroup.addUser(yahooUser);
                        yahooUser.adjustGroupCount(1);
                    } else {
                        yahooUser = this.userStore.getOrCreate(string);
                        yahooUser.setIgnored(true);
                    }
                    string = null;
                    break;
                }
                case 300: {
                    break;
                }
                case 65: {
                    yahooGroup = new YahooGroup(string2);
                    vector.add(yahooGroup);
                    break;
                }
                case 7: {
                    string = string2;
                    break;
                }
                case 241: {
                    break;
                }
                case 59: {
                    break;
                }
            }
        }
        this.groups = new YahooGroup[vector.size()];
        this.groups = vector.toArray(this.groups);
        if (this.loginOver) {
            this.receivedListFired = true;
            new FireEvent().fire(new SessionEvent(this), 85);
        }
    }

    protected void receiveLogoff(YMSG9Packet yMSG9Packet) {
        if (!yMSG9Packet.exists("7")) {
            this.sessionStatus = 0;
            this.ipThread.quit = true;
        } else {
            try {
                this.updateFriendsStatus(yMSG9Packet);
            }
            catch (Exception exception) {
                throw new YMSG9BadFormatException("online friends in logoff", false, exception);
            }
        }
    }

    protected void receiveLogon(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.exists("7")) {
            try {
                this.updateFriendsStatus(yMSG9Packet);
            }
            catch (Exception exception) {
                throw new YMSG9BadFormatException("online friends in logon", false, exception);
            }
        }
        if (!this.loginOver) {
            try {
                if (this.status == 0L) {
                    this.transmitIsBack();
                } else {
                    this.transmitIsAway();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sessionStatus = 2;
            this.loginOver = true;
        }
    }

    protected void receiveMessage(YMSG9Packet yMSG9Packet) {
        try {
            if (!yMSG9Packet.exists("14")) {
                return;
            }
            if (yMSG9Packet.status == 5L) {
                int n = 0;
                String string = yMSG9Packet.getNthValue("31", n);
                while (string != null) {
                    SessionEvent sessionEvent = new SessionEvent(this, yMSG9Packet.getNthValue("5", n), yMSG9Packet.getNthValue("4", n), yMSG9Packet.getNthValue("14", n), yMSG9Packet.getNthValue("15", n));
                    new FireEvent().fire(sessionEvent, 3841);
                    string = yMSG9Packet.getNthValue("31", ++n);
                }
            } else {
                String string = yMSG9Packet.getValue("4");
                SessionEvent sessionEvent = new SessionEvent(this, yMSG9Packet.getValue("5"), string, yMSG9Packet.getValue("14"));
                if (sessionEvent.getMessage().equalsIgnoreCase("<ding>")) {
                    new FireEvent().fire(sessionEvent, 3843);
                } else {
                    new FireEvent().fire(sessionEvent, 6);
                }
                String string2 = yMSG9Packet.getValue("429");
                if (string2 != null) {
                    PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
                    packetBodyBuffer.addElement("1", this.loginID);
                    packetBodyBuffer.addElement("5", string);
                    packetBodyBuffer.addElement("302", "430");
                    packetBodyBuffer.addElement("430", string2);
                    packetBodyBuffer.addElement("303", "430");
                    packetBodyBuffer.addElement("450", "0");
                    this.sendPacket(packetBodyBuffer, 251, this.status);
                }
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("message", false, exception);
        }
    }

    protected void receiveNewMail(YMSG9Packet yMSG9Packet) {
        try {
            SessionNewMailEvent sessionNewMailEvent = !yMSG9Packet.exists("43") ? new SessionNewMailEvent(this, yMSG9Packet.getValue("9")) : new SessionNewMailEvent(this, yMSG9Packet.getValue("43"), yMSG9Packet.getValue("42"), yMSG9Packet.getValue("18"));
            new FireEvent().fire(sessionNewMailEvent, 11);
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("new mail", false, exception);
        }
    }

    protected void receiveNotify(YMSG9Packet yMSG9Packet) {
        try {
            if (yMSG9Packet.status == 1L) {
                SessionNotifyEvent sessionNotifyEvent = new SessionNotifyEvent(this, yMSG9Packet.getValue("5"), yMSG9Packet.getValue("4"), yMSG9Packet.getValue("14"), yMSG9Packet.getValue("49"), yMSG9Packet.getValue("13"));
                sessionNotifyEvent.setStatus(yMSG9Packet.status);
                new FireEvent().fire(sessionNotifyEvent, 75);
            }
        }
        catch (Exception exception) {
            throw new YMSG9BadFormatException("notify", false, exception);
        }
    }

    protected void receivePing(YMSG9Packet yMSG9Packet) {
    }

    protected void receiveUserStat(YMSG9Packet yMSG9Packet) {
        this.status = yMSG9Packet.status;
    }

    protected void erroneousChatLogin(YMSG9Packet yMSG9Packet) {
        this.chatSessionStatus = 3;
        this.chatLoginOver = true;
    }

    protected void sendPacket(PacketBodyBuffer packetBodyBuffer, int n, long l) throws IOException {
        this.network.sendPacket(packetBodyBuffer, n, l, this.sessionId);
    }

    protected void sendPacket(PacketBodyBuffer packetBodyBuffer, int n) throws IOException {
        this.sendPacket(packetBodyBuffer, n, 0L);
    }

    private void report(String string, YMSG9Packet yMSG9Packet) {
        System.err.println(string + "\n" + yMSG9Packet.toString() + "\n");
    }

    private boolean past(long l) {
        return System.currentTimeMillis() > l;
    }

    private void startThreads() {
        this.ipThread = new InputThread();
        this.pingThread = new PingThread();
    }

    private void closeNetwork() {
        if (this.pingThread != null) {
            this.pingThread.quit = true;
            this.pingThread.interrupt();
        }
        if (this.network != null) {
            try {
                this.network.close();
                this.network = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkStatus() throws IllegalStateException {
        if (this.sessionStatus != 2) {
            throw new IllegalStateException("Not logged in");
        }
    }

    private void checkChatStatus() throws IllegalStateException {
        if (this.chatSessionStatus != 2) {
            throw new IllegalStateException("Not logged in to a chatroom");
        }
    }

    private YahooIdentity identityIdToObject(String string) {
        for (int i = 0; i < this.identities.length; ++i) {
            if (!string.equals(this.identities[i].getId())) continue;
            return this.identities[i];
        }
        return null;
    }

    private void checkIdentity(YahooIdentity yahooIdentity) throws IllegalIdentityException {
        for (int i = 0; i < this.identities.length; ++i) {
            if (yahooIdentity != this.identities[i]) continue;
            return;
        }
        throw new IllegalIdentityException(yahooIdentity + " not a valid identity for this session");
    }

    private void checkIdentityNotOnList(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.identityIdToObject(stringArray[i]) == null) continue;
            throw new IllegalIdentityException(stringArray[i] + " is an identity of this session and cannot be used here");
        }
    }

    private void resetData() {
        this.primaryID = null;
        this.loginID = null;
        this.password = null;
        this.cookieY = null;
        this.cookieT = null;
        this.cookieC = null;
        this.imvironment = null;
        this.customStatusMessage = null;
        this.customStatusBusy = false;
        this.groups = null;
        this.identities = null;
        this.clearTypingNotifiers();
        this.loginOver = false;
        this.loginException = null;
        this.chatConnectOver = false;
        this.chatLoginOver = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTypingNotifiers() {
        Hashtable hashtable = this.typingNotifiers;
        synchronized (hashtable) {
            Enumeration enumeration = this.typingNotifiers.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                TypingNotifier typingNotifier = (TypingNotifier)this.typingNotifiers.get(string);
                typingNotifier.quit = true;
                typingNotifier.interrupt();
                this.typingNotifiers.remove(string);
            }
        }
    }

    private void errorMessage(YMSG9Packet yMSG9Packet, String string) {
        if (string == null) {
            string = yMSG9Packet.getValue("16");
        }
        SessionErrorEvent sessionErrorEvent = new SessionErrorEvent((Object)this, string, yMSG9Packet.service);
        if (yMSG9Packet.exists("114")) {
            sessionErrorEvent.setCode(Integer.parseInt(yMSG9Packet.getValue("114").trim()));
        }
        new FireEvent().fire(sessionErrorEvent, 3840);
    }

    private YMSG9Packet compoundChatLoginPacket(YMSG9Packet yMSG9Packet) {
        if (yMSG9Packet.status == 5L) {
            if (this.cachePacket == null) {
                this.cachePacket = yMSG9Packet;
            } else {
                this.cachePacket.append(yMSG9Packet);
            }
            return null;
        }
        if (yMSG9Packet.status == 1L) {
            if (this.cachePacket != null) {
                this.cachePacket.append(yMSG9Packet);
                yMSG9Packet = this.cachePacket;
                this.cachePacket = null;
            }
            return yMSG9Packet;
        }
        return yMSG9Packet;
    }

    private void updateFriendsStatus(YMSG9Packet yMSG9Packet) {
        boolean bl;
        String string = yMSG9Packet.getValue("8");
        if (string == null && yMSG9Packet.getValue("7") != null) {
            string = "1";
        }
        boolean bl2 = bl = yMSG9Packet.service == 2;
        if (string != null) {
            int n = Integer.parseInt(string);
            SessionFriendEvent sessionFriendEvent = new SessionFriendEvent(this, n);
            for (int i = 0; i < n; ++i) {
                YahooUser yahooUser = this.userStore.get(yMSG9Packet.getNthValue("7", i));
                if (yahooUser == null) {
                    String string2 = yMSG9Packet.getNthValue("7", i);
                    yahooUser = this.userStore.getOrCreate(string2);
                }
                if (yMSG9Packet.exists("17")) {
                    yahooUser.update(yMSG9Packet.getNthValue("7", i), bl ? "1515563606" : yMSG9Packet.getNthValue("10", i), yMSG9Packet.getNthValue("17", i), yMSG9Packet.getNthValue("13", i));
                } else {
                    yahooUser.update(yMSG9Packet.getNthValue("7", i), bl ? "1515563606" : yMSG9Packet.getNthValue("10", i), yMSG9Packet.getNthValue("13", i));
                }
                if (yMSG9Packet.getNthValue("19", i) != null && yMSG9Packet.getNthValue("47", i) != null) {
                    yahooUser.setCustom(yMSG9Packet.getNthValue("19", i), yMSG9Packet.getNthValue("47", i));
                }
                sessionFriendEvent.setUser(i, yahooUser);
            }
            new FireEvent().fire(sessionFriendEvent, 3);
        }
    }

    private void insertFriend(YahooUser yahooUser, String string) {
        int n;
        for (n = 0; n < this.groups.length && !this.groups[n].getName().equalsIgnoreCase(string); ++n) {
        }
        if (n >= this.groups.length) {
            int n2;
            YahooGroup[] yahooGroupArray = new YahooGroup[this.groups.length + 1];
            boolean bl = false;
            for (n2 = 0; n2 < this.groups.length && this.groups[n2].getName().compareTo(string) < 0; ++n2) {
                yahooGroupArray[n2] = this.groups[n2];
            }
            n = n2;
            yahooGroupArray[n] = new YahooGroup(string);
            while (n2 < this.groups.length) {
                yahooGroupArray[n2 + 1] = this.groups[n2];
                ++n2;
            }
            this.groups = yahooGroupArray;
        }
        if (this.groups[n].getIndexOfFriend(yahooUser.getId()) < 0) {
            this.groups[n].addUser(yahooUser);
            yahooUser.adjustGroupCount(1);
        }
    }

    private void deleteFriend(YahooUser yahooUser, String string) {
        int n;
        for (n = 0; n < this.groups.length && !this.groups[n].getName().equalsIgnoreCase(string); ++n) {
        }
        if (n >= this.groups.length) {
            return;
        }
        int n2 = this.groups[n].getIndexOfFriend(yahooUser.getId());
        if (n2 < 0) {
            return;
        }
        this.groups[n].removeUserAt(n2);
        yahooUser.adjustGroupCount(-1);
        if (this.groups[n].isEmpty()) {
            YahooGroup[] yahooGroupArray = new YahooGroup[this.groups.length - 1];
            for (n2 = 0; n2 < n; ++n2) {
                yahooGroupArray[n2] = this.groups[n2];
            }
            for (n2 = n; n2 < yahooGroupArray.length; ++n2) {
                yahooGroupArray[n2] = this.groups[n2 + 1];
            }
            this.groups = yahooGroupArray;
        }
    }

    private YahooChatUser createChatUser(YMSG9Packet yMSG9Packet, int n) {
        YahooUser yahooUser = this.userStore.getOrCreate(yMSG9Packet.getNthValue("109", n));
        return new YahooChatUser(yahooUser, yMSG9Packet.getValueFromNthSet("109", "113", n), yMSG9Packet.getValueFromNthSet("109", "141", n), yMSG9Packet.getValueFromNthSet("109", "110", n), yMSG9Packet.getValueFromNthSet("109", "142", n));
    }

    private String getConferenceName(String string) {
        return string + "-" + this.conferenceCount++;
    }

    private YahooConference getConference(String string) throws NoSuchConferenceException {
        YahooConference yahooConference = (YahooConference)this.conferences.get(string);
        if (yahooConference == null) {
            throw new NoSuchConferenceException("Conference " + string + " not found.");
        }
        return yahooConference;
    }

    private YahooConference getOrCreateConference(YMSG9Packet yMSG9Packet) {
        String string = yMSG9Packet.getValue("57");
        YahooIdentity yahooIdentity = this.identityIdToObject(yMSG9Packet.getValue("1"));
        YahooConference yahooConference = (YahooConference)this.conferences.get(string);
        if (yahooConference == null) {
            yahooConference = new YahooConference(this.userStore, yahooIdentity, string, this);
            this.conferences.put(string, yahooConference);
        }
        return yahooConference;
    }

    public static void dump(Session session) {
        YahooUser yahooUser;
        Object object;
        YahooGroup[] yahooGroupArray = session.getGroups();
        for (int i = 0; i < yahooGroupArray.length; ++i) {
            System.out.print(yahooGroupArray[i].getName() + ": ");
            object = yahooGroupArray[i].getMembers();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                yahooUser = (YahooUser)((Vector)object).elementAt(j);
                System.out.print(yahooUser.getId() + " ");
            }
            System.out.print("\n");
        }
        Hashtable hashtable = session.userStore.getUsers();
        object = hashtable.keys();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            yahooUser = (YahooUser)hashtable.get(string);
            System.out.println(string + " = " + yahooUser.getId());
        }
        object = session.getIdentities();
        for (int i = 0; i < ((YahooIdentity[])object).length; ++i) {
            System.out.print(((YahooIdentity)object[i]).getId() + " ");
        }
        System.out.print("\n");
    }

    public void requestPicture(String string) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("13", "1");
        this.sendPacket(packetBodyBuffer, 190);
    }

    protected void receivePicture(YMSG9Packet yMSG9Packet) {
        Object object;
        String object2 = null;
        String object3 = null;
        boolean bl = false;
        boolean bl2 = false;
        String object4 = null;
        int n = 0;
        for (String[] object5 : yMSG9Packet.entries()) {
            object = object5[0];
            if (((String)object).equals("1") || ((String)object).equals("4")) {
                object2 = object5[1];
                continue;
            }
            if (((String)object).equals("5")) {
                object3 = object5[1];
                continue;
            }
            if (((String)object).equals("13")) {
                if (object5[1].equals("1")) {
                    bl2 = true;
                    continue;
                }
                bl = true;
                continue;
            }
            if (((String)object).equals("20")) {
                object4 = object5[1];
                continue;
            }
            if (!((String)object).equals("192")) continue;
            n = Integer.valueOf(object5[1]);
        }
        if (object2 != null && bl && object4 != null) {
            try {
                int n2;
                URL exception = new URL(object4);
                object = exception.openStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n2 = ((InputStream)object).read(byArray)) > 0) {
                    byteArrayOutputStream.write(byArray, 0, n2);
                }
                ((InputStream)object).close();
                YahooUser yahooUser = this.userStore.get(object2);
                if (yahooUser != null) {
                    yahooUser.setImage(byteArrayOutputStream.toByteArray());
                }
                SessionPictureEvent sessionPictureEvent = new SessionPictureEvent((Object)this, object3, object2, byteArrayOutputStream.toByteArray());
                new FireEvent().fire(sessionPictureEvent, 190);
            }
            catch (Exception iOException) {
                logger.warning("Error retreiving picture " + iOException.getMessage());
            }
        } else {
            try {
                this.sendPictureInfo(object2);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Cannot send our picture info", iOException);
            }
        }
    }

    protected void receivePictureUpdate(YMSG9Packet yMSG9Packet) {
        String string = null;
        String string2 = null;
        for (Object object : yMSG9Packet.entries()) {
            String string3 = object[0];
            if (string3.equals("4")) {
                string = object[1];
                continue;
            }
            if (!string3.equals("206") && !string3.equals("213")) continue;
            string2 = object[1];
        }
        if (string != null) {
            if (string2.equals("2")) {
                try {
                    this.requestPicture(string);
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "Cannot send picture request", iOException);
                }
            } else if (string2.equals("0") || string2.equals("1")) {
                Object object;
                object = new SessionPictureEvent((Object)this, null, string, null);
                new FireEvent().fire((SessionEvent)object, 190);
            }
        }
    }

    protected void receivePictureUpload(YMSG9Packet yMSG9Packet) {
        String string = null;
        for (String[] stringArray : yMSG9Packet.entries()) {
            String string2 = stringArray[0];
            if (!string2.equals("20")) continue;
            string = stringArray[1];
        }
        if (string != null) {
            this.pictureURL = string;
            try {
                this.sendPictureChecksum();
                this.sendPictureUpdate(2);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Cannot send picture update", iOException);
            }
        }
    }

    private void sendPictureChecksum() throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("212", "1");
        packetBodyBuffer.addElement("192", this.getPictureChecksum());
        this.sendPacket(packetBodyBuffer, 189);
    }

    private void sendPictureUpdate(int n) throws IOException {
        for (String string : this.userStore.getUsers().keySet()) {
            YahooUser yahooUser = this.userStore.get(string);
            if (yahooUser == null) continue;
            this.sendPictureUpdate(string, n);
        }
    }

    private void sendPictureUpdate(String string, int n) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("206", String.valueOf(n));
        this.sendPacket(packetBodyBuffer, 193);
    }

    protected void receivePictureChecksum(YMSG9Packet yMSG9Packet) {
        YahooUser yahooUser;
        String string;
        String object2 = null;
        int n = 0;
        for (String[] object3 : yMSG9Packet.entries()) {
            string = object3[0];
            if (string.equals("4")) {
                object2 = object3[1];
                continue;
            }
            if (!string.equals("192")) continue;
            n = Integer.valueOf(object3[1]);
        }
        if (object2 != null && (yahooUser = this.userStore.get(object2)) != null && (string = this.getPictureChecksum(yahooUser.getImage())) != null && string.equals(String.valueOf(n))) {
            try {
                this.requestPicture(object2);
            }
            catch (IOException iOException) {
                logger.log(Level.SEVERE, "Cannot send picture request", iOException);
            }
        }
    }

    protected void receiveAvatarUpdate(YMSG9Packet yMSG9Packet) {
        String string = null;
        String string2 = null;
        for (Object object : yMSG9Packet.entries()) {
            String string3 = object[0];
            if (string3.equals("4")) {
                string = object[1];
                continue;
            }
            if (!string3.equals("206")) continue;
            string2 = object[1];
        }
        if (string != null) {
            if (string2 == null || string2.equals("2")) {
                try {
                    this.requestPicture(string);
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, "Cannot send picture request", iOException);
                }
            } else if (string2.equals("0") || string2.equals("1")) {
                Object object;
                object = new SessionPictureEvent((Object)this, null, string, null);
                new FireEvent().fire((SessionEvent)object, 190);
            }
        }
    }

    public void setSessionPicture(SessionPicture sessionPicture) {
        this.picture = sessionPicture;
        if (this.sessionStatus == 2) {
            try {
                this.updateBuddyPicture();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "Cannot update picture", exception);
            }
        }
    }

    private void sendPictureInfo(String string) throws IOException {
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("4", this.loginID);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("13", "2");
        packetBodyBuffer.addElement("20", this.pictureURL);
        packetBodyBuffer.addElement("192", this.getPictureChecksum());
        this.sendPacket(packetBodyBuffer, 190);
    }

    private void updateBuddyPicture() throws IOException {
        byte[] byArray = this.picture.getPicture();
        if (byArray == null) {
            this.sendPictureUpdate(0);
        } else {
            String string;
            Object object;
            try {
                object = ImageIO.read(new ByteArrayInputStream(byArray));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)object, "png", byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, "error converting picture to png", exception);
            }
            object = "T=" + this.cookieT + "; Y=" + this.cookieY;
            int n = byArray.length;
            byte[] byArray2 = new byte[]{50, 57, -64, -128};
            PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
            packetBodyBuffer.addElement("1", this.loginID);
            packetBodyBuffer.addElement("38", "604800");
            packetBodyBuffer.addElement("0", this.loginID);
            packetBodyBuffer.addElement("28", String.valueOf(byArray.length));
            packetBodyBuffer.addElement("27", this.picture.getPictureFileName() + ".png");
            packetBodyBuffer.addElement("14", "");
            byte[] byArray3 = packetBodyBuffer.getBuffer();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.write(MAGIC, 0, 4);
            dataOutputStream.write(VERSION, 0, 4);
            dataOutputStream.writeShort(byArray3.length + 4 & 0xFFFF);
            dataOutputStream.writeShort(194);
            dataOutputStream.writeInt((int)(this.status & 0xFFFFFFFFFFFFFFFFL));
            dataOutputStream.writeInt((int)(this.sessionId & 0xFFFFFFFFFFFFFFFFL));
            dataOutputStream.write(byArray3, 0, byArray3.length);
            dataOutputStream.write(byArray2, 0, 4);
            byArray3 = byteArrayOutputStream.toByteArray();
            String string2 = Util.fileTransferHost();
            String string3 = "http://" + string2 + ":80/notifyft";
            HTTPConnection hTTPConnection = new HTTPConnection("POST", new URL(string3));
            hTTPConnection.println("Content-Length: " + (n + byArray3.length));
            hTTPConnection.println("User-Agent: Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
            hTTPConnection.println("Host: " + string2);
            hTTPConnection.println("Cookie: " + (String)object);
            hTTPConnection.println("Cache-Control: no-cache");
            hTTPConnection.println("");
            hTTPConnection.write(byArray3);
            hTTPConnection.write(byArray);
            hTTPConnection.flush();
            String string4 = string = hTTPConnection.readLine();
            if (string != null) {
                byte[] byArray4 = new byte[4096];
                while (hTTPConnection.read(byArray4) > 0) {
                }
            }
            hTTPConnection.close();
            if (string4.indexOf(" 200 ") < 0) {
                throw new FileTransferFailedException("Server rejected picture upload");
            }
        }
    }

    private String getPictureChecksum() {
        if (this.picture == null || this.picture.getPicture() == null) {
            return "";
        }
        return this.getPictureChecksum(this.picture.getPicture());
    }

    private String getPictureChecksum(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n2-- > 0) {
            int n4;
            if ((n4 = (n = (n << 4) + byArray[n3++]) & 0xF0000000) != 0) {
                n ^= n4 >> 23;
            }
            n &= ~n4;
        }
        return String.valueOf(n);
    }

    private String xferNewId() {
        char[] cArray = new char[24];
        Arrays.fill(cArray, ' ');
        cArray[22] = 36;
        cArray[23] = 36;
        Random random = new Random();
        for (int i = 0; i < 22; ++i) {
            int n = random.nextInt(61);
            cArray[i] = n < 26 ? (char)(n + 97) : (n < 52 ? (char)(n - 26 + 65) : (char)(n - 52 + 48));
        }
        return new String(cArray);
    }

    private void xferCancelRemote(String string, List<String> list, boolean bl) {
        if (bl) {
            XFer xFer = this.currentTransfers.get(string);
            int n = 1;
            if (xFer.sending && xFer.sendFileThread != null) {
                xFer.sendFileThread.cancel();
            } else if (xFer.receiveFileThread == null) {
                n = 6;
            }
            SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)this, xFer.to, xFer.from, xFer.xferPeerIDstring, n);
            new FireEvent().fire(sessionFileTransferEvent, 220);
            this.currentTransfers.remove(string);
        }
    }

    protected void receiveFiletrans15(YMSG9Packet yMSG9Packet) throws IOException {
        Object object;
        Object object22;
        XFer xFer = new XFer();
        for (Object object22 : yMSG9Packet.entries()) {
            object = object22[0];
            if (((String)object).equals("4")) {
                xFer.from = object22[1];
                continue;
            }
            if (((String)object).equals("5")) {
                xFer.to = object22[1];
                continue;
            }
            if (((String)object).equals("265")) {
                xFer.xferPeerIDstring = object22[1];
                continue;
            }
            if (((String)object).equals("27")) {
                xFer.fileNames.add(object22[1]);
                continue;
            }
            if (((String)object).equals("28")) {
                xFer.fileSizes.add(object22[1]);
                continue;
            }
            if (((String)object).equals("222")) {
                try {
                    xFer.val_222 = Long.valueOf(object22[1]);
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (((String)object).equals("49")) {
                xFer.service = object22[1];
                continue;
            }
            if (!((String)object).equals("63")) continue;
            xFer.imv = object22[1];
        }
        if (xFer.xferPeerIDstring == null) {
            return;
        }
        if (xFer.val_222 == 2L || xFer.val_222 == 4L) {
            xFer = this.currentTransfers.get(xFer.xferPeerIDstring);
            this.xferCancelRemote(xFer.xferPeerIDstring, xFer.fileNames, true);
            return;
        }
        if (xFer.val_222 == 3L) {
            xFer = this.currentTransfers.get(xFer.xferPeerIDstring);
            if (xFer == null) {
                return;
            }
            int n = this.getNextFileIx(xFer);
            object = new PacketBodyBuffer();
            ((PacketBodyBuffer)object).addElement("1", this.loginID);
            ((PacketBodyBuffer)object).addElement("5", xFer.to);
            ((PacketBodyBuffer)object).addElement("265", xFer.xferPeerIDstring);
            ((PacketBodyBuffer)object).addElement("27", new File(xFer.fileNames.get(n)).getName());
            ((PacketBodyBuffer)object).addElement("249", "3");
            ((PacketBodyBuffer)object).addElement("250", InetAddress.getByName("relay.msg.yahoo.com").getHostAddress());
            this.sendPacket((PacketBodyBuffer)object, 221);
            return;
        }
        if (xFer.from == null) {
            return;
        }
        this.currentTransfers.put(xFer.xferPeerIDstring, xFer);
        object22 = new SessionFileTransferEvent(this, xFer.to, xFer.from, xFer.fileNames, xFer.fileSizes, xFer.xferPeerIDstring, 0);
        new FireEvent().fire((SessionEvent)object22, 220);
    }

    public void fileTransferAccept(String string, File file) {
        try {
            this.xferAccept(string, file);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Cannot accept file transfer!", exception);
        }
    }

    private void xferAccept(String string, File file) throws IOException {
        XFer xFer = this.currentTransfers.get(string);
        xFer.receiveFile = file;
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("5", xFer.from);
        packetBodyBuffer.addElement("265", string);
        packetBodyBuffer.addElement("222", "3");
        this.sendPacket(packetBodyBuffer, 220);
    }

    public void cancelRunningFileTransfer(String string) {
        try {
            this.xferCancel(string);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Cannot cancel file transfer!", exception);
        }
    }

    public void fileTransferReject(String string) {
        try {
            this.xferCancel(string);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, "Cannot reject file transfer!", exception);
        }
    }

    private void xferCancel(String string) throws IOException {
        XFer xFer = this.currentTransfers.get(string);
        if (xFer == null) {
            return;
        }
        if (xFer.sendFileThread != null) {
            xFer.sendFileThread.cancel();
        }
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        String string2 = null;
        string2 = this.loginID.equals(xFer.to) ? xFer.from : xFer.to;
        packetBodyBuffer.addElement("5", string2);
        packetBodyBuffer.addElement("265", string);
        packetBodyBuffer.addElement("66", "-1");
        this.sendPacket(packetBodyBuffer, 222, -1L);
        SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)this, xFer.to, xFer.from, xFer.xferPeerIDstring, 1);
        new FireEvent().fire(sessionFileTransferEvent, 220);
        this.currentTransfers.remove(string);
    }

    protected void receiveP2P(YMSG9Packet yMSG9Packet) {
        String string = null;
        String string2 = null;
        for (String[] stringArray : yMSG9Packet.entries()) {
            String string3 = stringArray[0];
            if (string3.equals("4")) {
                string = stringArray[1];
                continue;
            }
            if (!string3.equals("12")) continue;
            string2 = stringArray[1];
        }
    }

    protected void receiveFiletransInfo15(YMSG9Packet yMSG9Packet) throws IOException {
        Object object;
        Object object22;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        long l = 0L;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        for (Object object22 : yMSG9Packet.entries()) {
            object = object22[0];
            if (((String)object).equals("4")) {
                string = object22[1];
                continue;
            }
            if (((String)object).equals("5")) {
                string2 = object22[1];
                continue;
            }
            if (((String)object).equals("265")) {
                string6 = object22[1];
                continue;
            }
            if (((String)object).equals("27")) {
                string5 = object22[1];
                continue;
            }
            if (((String)object).equals("66")) {
                l = Long.valueOf(object22[1]);
                continue;
            }
            if (((String)object).equals("249")) {
                string4 = object22[1];
                continue;
            }
            if (((String)object).equals("250")) {
                string3 = object22[1];
                continue;
            }
            if (!((String)object).equals("251")) continue;
            string7 = object22[1];
        }
        if (string6 == null) {
            return;
        }
        object22 = this.currentTransfers.get(string6);
        if (object22 == null) {
            return;
        }
        if (object22.fileNamesReceived.contains(string5)) {
            return;
        }
        if (l == -1L) {
            this.xferCancelRemote(string6, object22.fileNames, true);
            return;
        }
        object22.val_249 = string4;
        object22.xferPeerIDstringRelay = string7;
        object22.fileNames.add(string5);
        try {
            if (!string3.startsWith("http")) {
                string3 = "http://" + string3;
            }
            new URL(string3);
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Cannot parse url for incoming file", exception);
            this.xferCancelRemote(string6, object22.fileNames, true);
            return;
        }
        object = new PacketBodyBuffer();
        ((PacketBodyBuffer)object).addElement("1", this.loginID);
        ((PacketBodyBuffer)object).addElement("5", string);
        ((PacketBodyBuffer)object).addElement("265", string6);
        ((PacketBodyBuffer)object).addElement("27", string5);
        ((PacketBodyBuffer)object).addElement("249", string4);
        ((PacketBodyBuffer)object).addElement("251", string7);
        this.sendPacket((PacketBodyBuffer)object, 222);
        this.xferConnect(string6, string5, string3, string7, string);
    }

    private void xferConnect(String string, String string2, String string3, String string4, String string5) throws IOException {
        XFer xFer = this.currentTransfers.get(string);
        xFer.to = string5;
        xFer.receiveFileThread = new ReceiveFileThread(string3, string4, string2, xFer);
        xFer.receiveFileThread.start();
    }

    protected void receiveFiletransAcc15(YMSG9Packet yMSG9Packet) throws IOException {
        Object object2;
        long l = 0L;
        String string = null;
        String string2 = null;
        String string3 = null;
        for (Object object2 : yMSG9Packet.entries()) {
            String string4 = object2[0];
            if (string4.equals("251")) {
                string3 = object2[1];
                continue;
            }
            if (string4.equals("265")) {
                string2 = object2[1];
                continue;
            }
            if (string4.equals("222")) {
                string = object2[1];
                continue;
            }
            if (!string4.equals("66")) continue;
            l = Long.valueOf(object2[1]);
        }
        if (string2 == null) {
            return;
        }
        object2 = this.currentTransfers.get(string2);
        if (object2 == null) {
            return;
        }
        if (l == -1L || string3 == null) {
            this.xferCancelRemote(string2, object2.fileNames, true);
            return;
        }
        if (string3 != null) {
            object2.xferPeerIDstringRelay = string3;
            object2.sending = true;
            object2.sendFileThread = new SendFileThread((XFer)object2);
            object2.sendFileThread.start();
        } else {
            int n = this.getNextFileIx((XFer)object2);
            PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
            packetBodyBuffer.addElement("1", this.loginID);
            packetBodyBuffer.addElement("5", object2.to);
            packetBodyBuffer.addElement("265", object2.xferPeerIDstring);
            packetBodyBuffer.addElement("27", new File(object2.fileNames.get(n)).getName());
            packetBodyBuffer.addElement("249", "3");
            packetBodyBuffer.addElement("250", InetAddress.getByName("relay.msg.yahoo.com").getHostAddress());
            this.sendPacket(packetBodyBuffer, 221);
        }
    }

    private int getNextFileIx(XFer xFer) {
        for (int i = 0; i < xFer.fileNames.size(); ++i) {
            String string = xFer.fileNames.get(i);
            if (xFer.fileNamesSent.contains(string)) continue;
            return i;
        }
        return 0;
    }

    public String sendFiles(List<String> list, String string) throws IOException {
        if (list.size() > 1) {
            XFer xFer = new XFer();
            xFer.sending = true;
            xFer.to = string;
            xFer.xferPeerIDstring = this.xferNewId();
            this.currentTransfers.put(xFer.xferPeerIDstring, xFer);
            PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
            packetBodyBuffer.addElement("1", this.loginID);
            packetBodyBuffer.addElement("5", string);
            packetBodyBuffer.addElement("265", xFer.xferPeerIDstring);
            packetBodyBuffer.addElement("222", "1");
            packetBodyBuffer.addElement("266", String.valueOf(list.size()));
            packetBodyBuffer.addElement("302", "268");
            packetBodyBuffer.addElement("300", "268");
            for (int i = 0; i < list.size(); ++i) {
                String string2 = list.get(i);
                xFer.fileNames.add(string2);
                File file = new File(string2);
                String string3 = String.valueOf(file.length());
                xFer.fileSizes.add(string3);
                packetBodyBuffer.addElement("27", file.getName());
                packetBodyBuffer.addElement("28", string3);
                packetBodyBuffer.addElement("301", "268");
                if (i < list.size() - 1) {
                    packetBodyBuffer.addElement("300", "268");
                    continue;
                }
                packetBodyBuffer.addElement("303", "268");
            }
            this.sendPacket(packetBodyBuffer, 220);
            return xFer.xferPeerIDstring;
        }
        File file = new File(list.get(0));
        XFer xFer = new XFer();
        xFer.sending = true;
        xFer.to = string;
        xFer.xferPeerIDstring = this.xferNewId();
        xFer.fileNames.addAll(list);
        xFer.fileSizes.add(String.valueOf(file.length()));
        this.currentTransfers.put(xFer.xferPeerIDstring, xFer);
        PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
        packetBodyBuffer.addElement("1", this.loginID);
        packetBodyBuffer.addElement("5", string);
        packetBodyBuffer.addElement("265", xFer.xferPeerIDstring);
        packetBodyBuffer.addElement("222", "1");
        packetBodyBuffer.addElement("266", "1");
        packetBodyBuffer.addElement("302", "268");
        packetBodyBuffer.addElement("300", "268");
        packetBodyBuffer.addElement("27", file.getName());
        packetBodyBuffer.addElement("28", xFer.fileSizes.get(0));
        packetBodyBuffer.addElement("301", "268");
        packetBodyBuffer.addElement("303", "268");
        this.sendPacket(packetBodyBuffer, 220);
        return xFer.xferPeerIDstring;
    }

    private class ReceiveFileThread
    extends Thread {
        String urlStr;
        String relayStr;
        String fileName;
        XFer xfer;

        ReceiveFileThread(String string, String string2, String string3, XFer xFer) {
            this.urlStr = string;
            this.relayStr = string2;
            this.fileName = string3;
            this.xfer = xFer;
        }

        @Override
        public void run() {
            block9: {
                try {
                    URL uRL = new URL(this.urlStr.trim() + "/relay?token=" + URLEncoder.encode(this.relayStr.trim(), "UTF-8") + "&sender=" + Session.this.loginID + "&recver=" + this.xfer.to.trim());
                    String string = "T=" + Session.this.cookieT + "; Y=" + Session.this.cookieY;
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setRequestProperty("Cookie", string);
                    uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
                    uRLConnection.setRequestProperty("Host", uRL.getHost());
                    uRLConnection.setRequestProperty("Connection", "Keep-Alive");
                    if (uRLConnection instanceof HttpURLConnection) {
                        int n = ((HttpURLConnection)uRLConnection).getResponseCode();
                        int n2 = ((HttpURLConnection)uRLConnection).getContentLength();
                        if (n == 200) {
                            InputStream inputStream = uRLConnection.getInputStream();
                            SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4);
                            new FireEvent().fire(sessionFileTransferEvent, 220);
                            FileOutputStream fileOutputStream = new FileOutputStream(this.xfer.receiveFile);
                            long l = 0L;
                            int n3 = -1;
                            byte[] byArray = new byte[1024];
                            while ((n3 = inputStream.read(byArray)) != -1) {
                                fileOutputStream.write(byArray, 0, n3);
                                new FireEvent().fire(new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4, l += (long)n3), 220);
                            }
                            inputStream.close();
                            fileOutputStream.flush();
                            fileOutputStream.close();
                            if ((long)n2 == l) {
                                this.xfer.fileNamesReceived.add(this.fileName);
                                sessionFileTransferEvent = new SessionFileTransferEvent((Object)Session.this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 2);
                                new FireEvent().fire(sessionFileTransferEvent, 220);
                                if (this.xfer.fileNames.size() != this.xfer.fileNamesReceived.size()) {
                                    PacketBodyBuffer packetBodyBuffer = new PacketBodyBuffer();
                                    packetBodyBuffer.addElement("1", Session.this.loginID);
                                    packetBodyBuffer.addElement("5", this.xfer.from);
                                    packetBodyBuffer.addElement("265", this.xfer.xferPeerIDstring);
                                    packetBodyBuffer.addElement("271", "1");
                                    Session.this.sendPacket(packetBodyBuffer, 222);
                                } else {
                                    Session.this.currentTransfers.remove(this.xfer.xferPeerIDstring);
                                }
                            } else {
                                logger.log(Level.WARNING, "File size doesn't match expected " + n2 + " is " + l + ". Probably filetransfer canceled!");
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Error receiving file", exception);
                    if (this.fileName == null) break block9;
                    SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)exception, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 5);
                    new FireEvent().fire(sessionFileTransferEvent, 220);
                }
            }
        }
    }

    private class SendFileThread
    extends Thread {
        XFer xfer;
        boolean running = false;

        SendFileThread(XFer xFer) {
            this.xfer = xFer;
        }

        @Override
        public void run() {
            block6: {
                String string = null;
                String string2 = null;
                try {
                    String string3;
                    this.running = true;
                    int n = Session.this.getNextFileIx(this.xfer);
                    URL uRL = new URL("http://relay.msg.yahoo.com/relay?token=" + URLEncoder.encode(this.xfer.xferPeerIDstringRelay, "UTF-8") + "&sender=" + Session.this.loginID + "&recver=" + this.xfer.to);
                    String string4 = "T=" + Session.this.cookieT + "; Y=" + Session.this.cookieY;
                    string = this.xfer.fileSizes.get(n);
                    string2 = this.xfer.fileNames.get(n);
                    URLConnection uRLConnection = uRL.openConnection();
                    uRLConnection.setDoOutput(true);
                    uRLConnection.setUseCaches(false);
                    uRLConnection.setAllowUserInteraction(false);
                    uRLConnection.setRequestProperty("Cookie", string4);
                    uRLConnection.setRequestProperty("User-Agent", "Mozilla/4.5 [en] (X11; U; FreeBSD 2.2.8-STABLE i386)");
                    uRLConnection.setRequestProperty("Host", uRL.getHost());
                    uRLConnection.setRequestProperty("Content-Length", string);
                    uRLConnection.setRequestProperty("Cache-Control", "no-cache");
                    OutputStream outputStream = uRLConnection.getOutputStream();
                    File file = new File(string2);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4);
                    new FireEvent().fire(sessionFileTransferEvent, 220);
                    long l = 0L;
                    int n2 = -1;
                    byte[] byArray = new byte[1024];
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        if (!this.running) {
                            fileInputStream.close();
                            outputStream.close();
                            return;
                        }
                        new FireEvent().fire(new SessionFileTransferEvent((Object)this, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 4, l += (long)n2), 220);
                        outputStream.write(byArray, 0, n2);
                        outputStream.flush();
                    }
                    fileInputStream.close();
                    this.xfer.fileNamesSent.add(string2);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((string3 = bufferedReader.readLine()) != null) {
                        stringBuffer.append(string3);
                    }
                    bufferedReader.close();
                    outputStream.close();
                    if (this.xfer.fileNamesSent.size() == this.xfer.fileNames.size()) {
                        Session.this.currentTransfers.remove(this.xfer.xferPeerIDstring);
                    }
                    sessionFileTransferEvent = new SessionFileTransferEvent((Object)string2, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 3);
                    new FireEvent().fire(sessionFileTransferEvent, 220);
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Error sending file", exception);
                    if (string2 == null) break block6;
                    SessionFileTransferEvent sessionFileTransferEvent = new SessionFileTransferEvent((Object)exception, this.xfer.to, this.xfer.from, this.xfer.xferPeerIDstring, 5);
                    new FireEvent().fire(sessionFileTransferEvent, 220);
                }
            }
        }

        void cancel() {
            this.running = false;
        }
    }

    private static class XFer {
        String from = null;
        String to = null;
        String imv = null;
        long val_222 = 0L;
        String service = null;
        String xferPeerIDstring = null;
        String xferPeerIDstringRelay = null;
        String val_249 = null;
        ArrayList<String> fileNames = new ArrayList();
        ArrayList<String> fileSizes = new ArrayList();
        boolean sending = false;
        ArrayList<String> fileNamesReceived = new ArrayList();
        ArrayList<String> fileNamesSent = new ArrayList();
        SendFileThread sendFileThread;
        ReceiveFileThread receiveFileThread;
        File receiveFile = null;

        private XFer() {
        }
    }

    private class FireEvent
    extends Thread {
        int type;
        SessionEvent ev;

        FireEvent() {
            super(Session.this.ymsgThreads, "Event Fired");
        }

        void fire(SessionEvent sessionEvent, int n) {
            this.ev = sessionEvent;
            this.type = n;
            this.start();
        }

        @Override
        public void start() {
            if (Session.this.listeners.size() > 0) {
                super.start();
            }
        }

        @Override
        public void run() {
            logger.finest("Will fire eventType=" + this.type + " event=" + this.ev + " to listeners count=" + Session.this.listeners.size());
            if (this.type == 220) {
                SessionFileTransferEvent sessionFileTransferEvent = (SessionFileTransferEvent)this.ev;
                for (int i = 0; i < Session.this.sessionFileTransferListeners.size(); ++i) {
                    try {
                        SessionFileTransferListener sessionFileTransferListener = (SessionFileTransferListener)Session.this.sessionFileTransferListeners.get(i);
                        if (sessionFileTransferEvent.getState() == 0) {
                            sessionFileTransferListener.fileTransferRequestReceived(sessionFileTransferEvent);
                            continue;
                        }
                        sessionFileTransferListener.statusChanged(sessionFileTransferEvent);
                        continue;
                    }
                    catch (Exception exception) {
                        logger.log(Level.SEVERE, null, exception);
                    }
                }
                return;
            }
            block32: for (int i = 0; i < Session.this.listeners.size(); ++i) {
                SessionListener sessionListener = (SessionListener)Session.this.listeners.elementAt(i);
                switch (this.type) {
                    case 2: {
                        sessionListener.connectionClosed(this.ev);
                        continue block32;
                    }
                    case 3: {
                        sessionListener.friendsUpdateReceived((SessionFriendEvent)this.ev);
                        continue block32;
                    }
                    case 6: {
                        sessionListener.messageReceived(this.ev);
                        continue block32;
                    }
                    case 3841: {
                        sessionListener.offlineMessageReceived(this.ev);
                        continue block32;
                    }
                    case 11: {
                        sessionListener.newMailReceived((SessionNewMailEvent)this.ev);
                        continue block32;
                    }
                    case 15: {
                        sessionListener.contactRequestReceived(this.ev);
                        continue block32;
                    }
                    case 26: {
                        sessionListener.conferenceInviteDeclinedReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 24: {
                        sessionListener.conferenceInviteReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 25: {
                        sessionListener.conferenceLogonReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 27: {
                        sessionListener.conferenceLogoffReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 29: {
                        sessionListener.conferenceMessageReceived((SessionConferenceEvent)this.ev);
                        continue block32;
                    }
                    case 70: {
                        sessionListener.fileTransferReceived((SessionFileTransferEvent)this.ev);
                        continue block32;
                    }
                    case 75: {
                        sessionListener.notifyReceived((SessionNotifyEvent)this.ev);
                        continue block32;
                    }
                    case 85: {
                        sessionListener.listReceived(this.ev);
                        continue block32;
                    }
                    case 131: {
                        sessionListener.friendAddedReceived((SessionFriendEvent)this.ev);
                        continue block32;
                    }
                    case 132: {
                        sessionListener.friendRemovedReceived((SessionFriendEvent)this.ev);
                        continue block32;
                    }
                    case 134: {
                        sessionListener.contactRejectionReceived(this.ev);
                        continue block32;
                    }
                    case 152: {
                        sessionListener.chatLogonReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 155: {
                        sessionListener.chatLogoffReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 160: {
                        sessionListener.chatConnectionClosed(this.ev);
                        continue block32;
                    }
                    case 168: {
                        sessionListener.chatMessageReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 3844: {
                        sessionListener.chatUserUpdateReceived((SessionChatEvent)this.ev);
                        continue block32;
                    }
                    case 3840: {
                        sessionListener.errorPacketReceived((SessionErrorEvent)this.ev);
                        continue block32;
                    }
                    case 3842: {
                        sessionListener.inputExceptionThrown((SessionExceptionEvent)this.ev);
                        continue block32;
                    }
                    case 3843: {
                        sessionListener.buzzReceived(this.ev);
                        continue block32;
                    }
                    case 190: {
                        sessionListener.pictureReceived((SessionPictureEvent)this.ev);
                        continue block32;
                    }
                    case 214: {
                        sessionListener.authorizationReceived((SessionAuthorizationEvent)this.ev);
                        continue block32;
                    }
                    default: {
                        logger.finest("UNKNOWN event: " + this.type);
                    }
                }
            }
        }
    }

    private class TypingNotifier
    extends KeyAdapter
    implements Runnable {
        public boolean quit = false;
        private long lastKey;
        private int timeout = 30000;
        private boolean typing = false;
        private Thread thread;
        private Component typeSource;
        private int listenerCnt = 0;
        private String target;
        private String identity;

        public TypingNotifier(Component component, String string, String string2) {
            this.typeSource = component;
            this.target = string;
            this.identity = string2;
            if (this.typeSource != null) {
                this.typeSource.addKeyListener(this);
            }
            this.thread = new Thread(Session.this.ymsgThreads, this, "Typing Notification: " + string2 + "->" + string);
            this.thread.setPriority(1);
            this.thread.start();
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.keyTyped();
        }

        void keyTyped() {
            if (!this.thread.isAlive() || Session.this.sessionStatus != 2) {
                return;
            }
            this.lastKey = System.currentTimeMillis();
            if (!this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, true, " ", "TYPING");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.typing = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.quit) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (Session.this.sessionStatus != 2 || !this.typing || System.currentTimeMillis() - this.lastKey <= (long)this.timeout) continue;
                    try {
                        Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.typing = false;
                }
            }
            finally {
                if (this.typeSource != null) {
                    this.typeSource.removeKeyListener(this);
                }
            }
        }

        public void interrupt() {
            this.thread.interrupt();
        }

        public void stopTyping() {
            if (this.typing) {
                try {
                    Session.this.transmitNotify(this.target, this.identity, false, " ", "TYPING");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.typing = false;
            }
        }
    }

    private class PingThread
    extends Thread {
        public boolean quit;
        public int time;

        public PingThread() {
            super(Session.this.ymsgThreads, "Ping");
            this.quit = false;
            this.time = 1200000;
            this.setPriority(1);
            this.start();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (!this.quit) {
                try {
                    Session.this.transmitPing();
                    if (Session.this.currentLobby != null) {
                        Session.this.transmitChatPing();
                    }
                    try {
                        Thread.sleep(this.time);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private class InputThread
    extends Thread {
        public boolean quit;

        public InputThread() {
            super(Session.this.ymsgThreads, "Network Input");
            this.quit = false;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                block9: while (true) {
                    while (!this.quit) {
                        try {
                            this.process(Session.this.network.receivePacket());
                        }
                        catch (SocketException socketException) {
                            break block11;
                        }
                        catch (LoginRefusedException loginRefusedException) {
                            break block11;
                        }
                        catch (Exception exception) {
                            try {
                                SessionExceptionEvent sessionExceptionEvent = new SessionExceptionEvent((Object)Session.this, "Source: InputThread", exception);
                                new FireEvent().fire(sessionExceptionEvent, 3842);
                                continue block9;
                            }
                            catch (Exception exception2) {
                                exception2.printStackTrace();
                            }
                        }
                    }
                    break block11;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    Session.this.closeNetwork();
                    new FireEvent().fire(new SessionEvent(this), 2);
                }
            }
        }

        void process(YMSG9Packet yMSG9Packet) throws Exception {
            if (yMSG9Packet == null) {
                this.quit = true;
                return;
            }
            if (yMSG9Packet.sessionId != 0L) {
                Session.this.sessionId = yMSG9Packet.sessionId;
            }
            logger.finest("Received a packet - status: " + yMSG9Packet.status + " service: " + yMSG9Packet.service + " packet:" + yMSG9Packet);
            if (yMSG9Packet.status == -1L && yMSG9Packet.service != 221 && yMSG9Packet.service != 222 && this.processError(yMSG9Packet)) {
                return;
            }
            switch (yMSG9Packet.service) {
                case 17: {
                    Session.this.receiveAddIgnore(yMSG9Packet);
                    break;
                }
                case 87: {
                    Session.this.receiveAuth(yMSG9Packet);
                    break;
                }
                case 84: {
                    Session.this.receiveAuthResp(yMSG9Packet);
                    break;
                }
                case 150: {
                    Session.this.receiveChatConnect(yMSG9Packet);
                    break;
                }
                case 160: {
                    Session.this.receiveChatDisconnect(yMSG9Packet);
                    break;
                }
                case 155: {
                    Session.this.receiveChatLogoff(yMSG9Packet);
                    break;
                }
                case 152: {
                    Session.this.receiveChatLogon(yMSG9Packet);
                    break;
                }
                case 168: {
                    Session.this.receiveChatMsg(yMSG9Packet);
                    break;
                }
                case 32: {
                    Session.this.receiveChatPM(yMSG9Packet);
                    break;
                }
                case 28: {
                    Session.this.receiveConfAddInvite(yMSG9Packet);
                    break;
                }
                case 26: {
                    Session.this.receiveConfDecline(yMSG9Packet);
                    break;
                }
                case 24: {
                    Session.this.receiveConfInvite(yMSG9Packet);
                    break;
                }
                case 27: {
                    Session.this.receiveConfLogoff(yMSG9Packet);
                    break;
                }
                case 25: {
                    Session.this.receiveConfLogon(yMSG9Packet);
                    break;
                }
                case 29: {
                    Session.this.receiveConfMsg(yMSG9Packet);
                    break;
                }
                case 133: {
                    Session.this.receiveContactIgnore(yMSG9Packet);
                    break;
                }
                case 15: {
                    Session.this.receiveContactNew(yMSG9Packet);
                    break;
                }
                case 70: {
                    Session.this.receiveFileTransfer(yMSG9Packet);
                    break;
                }
                case 131: {
                    Session.this.receiveFriendAdd(yMSG9Packet);
                    break;
                }
                case 132: {
                    Session.this.receiveFriendRemove(yMSG9Packet);
                    break;
                }
                case 7: {
                    Session.this.receiveIdAct(yMSG9Packet);
                    break;
                }
                case 8: {
                    Session.this.receiveIdDeact(yMSG9Packet);
                    break;
                }
                case 3: {
                    Session.this.receiveIsAway(yMSG9Packet);
                    break;
                }
                case 4: {
                    Session.this.receiveIsBack(yMSG9Packet);
                    break;
                }
                case 85: {
                    Session.this.receiveList(yMSG9Packet);
                    break;
                }
                case 241: {
                    Session.this.receiveList15(yMSG9Packet);
                    break;
                }
                case 2: {
                    Session.this.receiveLogoff(yMSG9Packet);
                    break;
                }
                case 1: {
                    Session.this.receiveLogon(yMSG9Packet);
                    break;
                }
                case 6: {
                    Session.this.receiveMessage(yMSG9Packet);
                    break;
                }
                case 11: {
                    Session.this.receiveNewMail(yMSG9Packet);
                    break;
                }
                case 75: {
                    Session.this.receiveNotify(yMSG9Packet);
                    break;
                }
                case 18: {
                    Session.this.receivePing(yMSG9Packet);
                    break;
                }
                case 10: {
                    Session.this.receiveUserStat(yMSG9Packet);
                    break;
                }
                case 198: {
                    Session.this.receiveIsAway(yMSG9Packet);
                    break;
                }
                case 240: {
                    Session.this.receiveStatus15(yMSG9Packet);
                    break;
                }
                case 214: {
                    Session.this.receiveAuthorization(yMSG9Packet);
                    break;
                }
                case 190: {
                    Session.this.receivePicture(yMSG9Packet);
                    break;
                }
                case 193: {
                    Session.this.receivePictureUpdate(yMSG9Packet);
                    break;
                }
                case 199: {
                    Session.this.receiveAvatarUpdate(yMSG9Packet);
                    break;
                }
                case 194: {
                    Session.this.receivePictureUpload(yMSG9Packet);
                    break;
                }
                case 189: {
                    Session.this.receivePictureChecksum(yMSG9Packet);
                    break;
                }
                case 220: {
                    Session.this.receiveFiletrans15(yMSG9Packet);
                    break;
                }
                case 79: {
                    Session.this.receiveP2P(yMSG9Packet);
                    break;
                }
                case 221: {
                    Session.this.receiveFiletransInfo15(yMSG9Packet);
                    break;
                }
                case 222: {
                    Session.this.receiveFiletransAcc15(yMSG9Packet);
                    break;
                }
                default: {
                    logger.finest("UNKNOWN: " + yMSG9Packet.toString());
                }
            }
        }

        boolean processError(YMSG9Packet yMSG9Packet) throws Exception {
            switch (yMSG9Packet.service) {
                case 84: {
                    Session.this.receiveAuthResp(yMSG9Packet);
                    return true;
                }
                case 152: {
                    Session.this.receiveChatLogon(yMSG9Packet);
                    return true;
                }
                case 2: {
                    Session.this.receiveLogoff(yMSG9Packet);
                    return true;
                }
            }
            Session.this.errorMessage(yMSG9Packet, null);
            return yMSG9Packet.body.length <= 2;
        }
    }
}

