/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl.algorithm;

import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionException;
import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.SubstitutionAlgorithm;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

public class StringReplacementAlgo
implements SubstitutionAlgorithm {
    private Map<String, String> _substitutionMap;

    public StringReplacementAlgo(Map<String, String> substitutionMap) {
        if (substitutionMap == null || substitutionMap.isEmpty()) {
            throw new IllegalArgumentException("Can not construct algorithm for null or empty map.");
        }
        this._substitutionMap = substitutionMap;
    }

    @Override
    public void substitute(Substitutable resolver) throws StringSubstitutionException {
        Reader reader = resolver.getReader();
        Writer writer = resolver.getWriter();
        try {
            String inputLine = null;
            char[] cbuffer = new char[8192];
            int count = 0;
            while ((count = reader.read(cbuffer)) > 0) {
                inputLine = new String(cbuffer, 0, count);
                for (String key : this._substitutionMap.keySet()) {
                    inputLine = inputLine.replace(key, this._substitutionMap.get(key));
                }
                writer.write(inputLine);
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new StringSubstitutionException("Error occurred while performing the String substitution", e);
        }
    }
}

