/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.apf.impl;

import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.apf.AnnotationHandler;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.IndexedFilter;
import org.glassfish.hk2.api.ServiceLocator;

public class AnnotationUtils {
    private static Logger logger;
    private static String whatToLog;

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.global;
        }
        return logger;
    }

    public static void setLogger(Logger lg) {
        logger = lg;
    }

    public static void setLoggerTarget(String what) {
        whatToLog = what;
    }

    public static String getLoggerTarget() {
        return whatToLog;
    }

    public static boolean shouldLog(String what) {
        if (logger.isLoggable(Level.FINER)) {
            if (whatToLog.indexOf(what) != -1) {
                return true;
            }
            if ("*".equals(whatToLog)) {
                return true;
            }
        }
        return false;
    }

    public static String getLocalString(String key, String defaultString, Object ... arguments) {
        return MessageFormat.format(defaultString, arguments);
    }

    public static ActiveDescriptor<AnnotationHandler> getAnnotationHandlerForDescriptor(ServiceLocator locator, final Class<?> forThis) {
        ActiveDescriptor<AnnotationHandler> retVal = locator.getBestDescriptor(new IndexedFilter(){

            @Override
            public boolean matches(Descriptor d) {
                Map<String, List<String>> metadata = d.getMetadata();
                List<String> handlerForList = metadata.get("AnnotationHandlerFor");
                if (handlerForList == null || handlerForList.isEmpty()) {
                    return false;
                }
                String descriptorForThis = handlerForList.get(0);
                return descriptorForThis.equals(forThis.getName());
            }

            @Override
            public String getAdvertisedContract() {
                return AnnotationHandler.class.getName();
            }

            @Override
            public String getName() {
                return null;
            }
        });
        return retVal;
    }

    static {
        whatToLog = "";
    }
}

