/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.jta;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ControlImpl;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.jta.SynchronizationImpl;
import com.sun.jts.jta.TransactionImpl;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.jtsxa.Utility;
import com.sun.jts.jtsxa.XID;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.Unavailable;

public class TransactionState {
    private static final int NOT_EXIST = -1;
    private static final int ASSOCIATED = 0;
    private static final int NOT_ASSOCIATED = 1;
    private static final int ASSOCIATION_SUSPENDED = 2;
    private static final int FAILED = 3;
    private static final int ROLLING_BACK = 4;
    private Map resourceStates = new HashMap();
    private Map resourceList = new HashMap();
    private Set seenXids = new HashSet();
    private List factories = new ArrayList();
    private SynchronizationImpl syncImpl;
    private GlobalTID gtid;
    private TransactionImpl tran;
    static Logger _logger = LogDomains.getLogger(TransactionState.class, (String)"javax.enterprise.system.core.transaction");

    public TransactionState(GlobalTID gtid, TransactionImpl tran) {
        this.gtid = gtid;
        this.tran = tran;
    }

    public synchronized void beforeCompletion() {
        boolean exceptionThrown = false;
        XAResource res = null;
        Iterator e = this.resourceStates.keySet().iterator();
        block8: while (e.hasNext()) {
            try {
                res = (XAResource)e.next();
                int XAState = this.getXAState(res);
                switch (XAState) {
                    case 1: 
                    case 3: {
                        continue block8;
                    }
                    case 0: 
                    case 2: {
                        Xid xid = (Xid)this.resourceList.get(res);
                        res.end(xid, 0x4000000);
                        this.setXAState(res, 1);
                        continue block8;
                    }
                }
                throw new IllegalStateException("Wrong XA State: " + XAState);
            }
            catch (Exception ex) {
                this.setXAState(res, 3);
                _logger.log(Level.WARNING, "jts.delist_exception", ex);
                exceptionThrown = true;
            }
        }
        if (exceptionThrown) {
            try {
                this.tran.setRollbackOnly();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public synchronized void rollback(XAResource res) throws IllegalStateException, XAException {
        this._rollback(res);
        for (XAResource res0 : this.resourceStates.keySet()) {
            if (!res0.isSameRM(res) || res0 == res) continue;
            this._end(res0);
        }
    }

    private synchronized void _rollback(XAResource res) throws IllegalStateException, XAException {
        Xid xid = (Xid)this.resourceList.get(res);
        TransactionState.assert_prejdk14(xid != null);
        int XAState = this.getXAState(res);
        switch (XAState) {
            case 1: 
            case 3: {
                res.rollback(xid);
                break;
            }
            case 0: 
            case 2: {
                try {
                    res.end(xid, 0x4000000);
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "jts.delist_exception", ex);
                }
                this.setXAState(res, 1);
                res.rollback(xid);
                break;
            }
            default: {
                throw new IllegalStateException("Wrong XAState: " + XAState);
            }
        }
    }

    private synchronized void _end(XAResource res) throws IllegalStateException, XAException {
        Xid xid = (Xid)this.resourceList.get(res);
        TransactionState.assert_prejdk14(xid != null);
        int XAState = this.getXAState(res);
        switch (XAState) {
            case 1: 
            case 3: {
                break;
            }
            case 0: 
            case 2: {
                try {
                    res.end(xid, 0x4000000);
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "jts.delist_exception", ex);
                }
                this.setXAState(res, 1);
                break;
            }
            default: {
                throw new IllegalStateException("Wrong XAState: " + XAState);
            }
        }
    }

    private Xid computeXid(XAResource res, Control control) throws Inactive, Unavailable, XAException {
        int size = this.factories.size();
        for (int i = 0; i < size; ++i) {
            XAResource fac = (XAResource)this.factories.get(i);
            if (!res.isSameRM(fac)) continue;
            Xid xid = (Xid)this.resourceList.get(fac);
            return xid;
        }
        XID xid = Configuration.isLocalFactory() ? Utility.getXID(((ControlImpl)control).get_localCoordinator()) : Utility.getXID(control.get_coordinator());
        this.factories.add(res);
        byte[] branchid = TransactionState.parseSize(size);
        byte[] sname = Configuration.getServerNameByteArray();
        byte[] branch = new byte[sname.length + 1 + branchid.length];
        System.arraycopy(sname, 0, branch, 0, sname.length);
        branch[sname.length] = 44;
        System.arraycopy(branchid, 0, branch, sname.length + 1, branchid.length);
        xid.setBranchQualifier(branch);
        return xid;
    }

    public synchronized void startAssociation(XAResource res, Control control, int status) throws XAException, SystemException, IllegalStateException, RollbackException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "startAssociation for " + res);
        }
        try {
            Xid xid = null;
            boolean newResource = false;
            boolean seenXid = false;
            if (this.resourceList.get(res) == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "startAssociation for unknown resource");
                }
                if (status != 0) {
                    throw new RollbackException();
                }
                newResource = true;
                xid = this.computeXid(res, control);
                seenXid = this.seenXids.contains(xid);
                if (!seenXid) {
                    OTSResourceImpl ref = new OTSResourceImpl(xid, res, this);
                    if (Configuration.isLocalFactory()) {
                        ((ControlImpl)control).get_localCoordinator().register_resource((Resource)ref);
                    } else {
                        control.get_coordinator().register_resource((Resource)ref);
                    }
                }
                this.resourceList.put(res, xid);
            } else {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "startAssociation for known resource");
                }
                xid = (Xid)this.resourceList.get(res);
                seenXid = this.seenXids.contains(xid);
            }
            int XAState = this.getXAState(res);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "startAssociation in state: " + XAState);
            }
            if (!seenXid) {
                this.seenXids.add(xid);
                res.start(xid, 0);
                this.setXAState(res, 0);
            } else {
                switch (XAState) {
                    case -1: 
                    case 1: {
                        res.start(xid, 0x200000);
                        this.setXAState(res, 0);
                        break;
                    }
                    case 2: {
                        res.start(xid, 0x8000000);
                        this.setXAState(res, 0);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Wrong XAState: " + XAState);
                    }
                }
            }
        }
        catch (XAException ex) {
            this.setXAState(res, 3);
            throw ex;
        }
        catch (Inactive ex) {
            _logger.log(Level.WARNING, "jts.transaction_inactive", ex);
            throw new SystemException();
        }
        catch (Unavailable ex) {
            _logger.log(Level.WARNING, "jts.object_unavailable", ex);
            throw new SystemException();
        }
    }

    public synchronized void endAssociation(XAResource xares, int flags) throws XAException, IllegalStateException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "endAssociation for " + xares);
        }
        try {
            Xid xid = (Xid)this.resourceList.get(xares);
            TransactionState.assert_prejdk14(xid != null);
            int XAState = this.getXAState(xares);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "endAssociation in state: " + XAState);
            }
            switch (XAState) {
                case 0: {
                    if ((flags & 0x4000000) != 0) {
                        xares.end(xid, 0x4000000);
                        this.setXAState(xares, 1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        xares.end(xid, 0x2000000);
                        this.setXAState(xares, 2);
                        break;
                    }
                    xares.end(xid, 0x20000000);
                    this.setXAState(xares, 3);
                    break;
                }
                case 4: {
                    xares.end(xid, 0x4000000);
                    this.setXAState(xares, 1);
                    xares.rollback(xid);
                    break;
                }
                case 2: {
                    if ((flags & 0x4000000) != 0) {
                        xares.end(xid, 0x4000000);
                        this.setXAState(xares, 1);
                        break;
                    }
                    if ((flags & 0x2000000) != 0) {
                        throw new IllegalStateException("Wrong XAState: " + XAState);
                    }
                    xares.end(xid, 0x20000000);
                    this.setXAState(xares, 3);
                    break;
                }
                default: {
                    throw new IllegalStateException("Wrong XAState: " + XAState);
                }
            }
        }
        catch (XAException ex) {
            this.setXAState(xares, 3);
            throw ex;
        }
    }

    void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tran.setRollbackOnly();
    }

    public synchronized void registerSynchronization(javax.transaction.Synchronization sync, Control control, boolean interposed) throws RollbackException, IllegalStateException, SystemException {
        try {
            if (this.syncImpl == null) {
                this.syncImpl = new SynchronizationImpl(this);
                if (Configuration.isLocalFactory()) {
                    ((ControlImpl)control).get_localCoordinator().register_synchronization((Synchronization)this.syncImpl);
                } else {
                    control.get_coordinator().register_synchronization((Synchronization)this.syncImpl);
                }
            }
            this.syncImpl.addSynchronization(sync, interposed);
        }
        catch (TRANSACTION_ROLLEDBACK ex) {
            throw new RollbackException();
        }
        catch (Unavailable ex) {
            _logger.log(Level.WARNING, "jts.object_unavailable", ex);
            throw new SystemException();
        }
        catch (Inactive ex) {
            _logger.log(Level.WARNING, "jts.transaction_inactive", ex);
            throw new IllegalStateException();
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "jts.exception_in_register_synchronization", ex);
            throw new SystemException();
        }
    }

    private void setXAState(XAResource res, Integer state) {
        if (_logger.isLoggable(Level.FINE)) {
            int oldValue = this.getXAState(res);
            _logger.log(Level.FINE, "transaction id : " + this.gtid);
            _logger.log(Level.FINE, "res: " + res + ", old state: " + oldValue + ", new state: " + state);
        }
        this.resourceStates.put(res, state);
    }

    private int getXAState(XAResource res) {
        Integer result = (Integer)this.resourceStates.get(res);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public Enumeration listXAResources() {
        return Collections.enumeration(this.resourceList.keySet());
    }

    public boolean containsXAResource(XAResource res) {
        return this.resourceList.containsKey(res);
    }

    private static void assert_prejdk14(boolean value) {
        if (!value) {
            Exception e = new Exception();
            _logger.log(Level.WARNING, "jts.assert", e);
        }
    }

    private static byte[] parseSize(int size) {
        switch (size) {
            case 0: {
                return new byte[]{0};
            }
            case 1: {
                return new byte[]{1};
            }
            case 2: {
                return new byte[]{2};
            }
            case 3: {
                return new byte[]{3};
            }
            case 4: {
                return new byte[]{4};
            }
            case 5: {
                return new byte[]{5};
            }
            case 6: {
                return new byte[]{6};
            }
            case 7: {
                return new byte[]{7};
            }
            case 8: {
                return new byte[]{8};
            }
            case 9: {
                return new byte[]{9};
            }
        }
        int j = 9;
        byte[] res = new byte[10];
        while (size > 0) {
            res[j--] = (byte)(size % 10);
            size /= 10;
        }
        int len = 9 - j;
        byte[] result = new byte[len];
        System.arraycopy(res, j + 1, result, 0, len);
        return result;
    }
}

