/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.PhysicalEntityManagerWrapper;
import com.sun.enterprise.container.common.impl.QueryWrapper;
import com.sun.enterprise.container.common.impl.StoreProcedureQueryWrapper;
import com.sun.enterprise.container.common.impl.TypedQueryWrapper;
import com.sun.enterprise.container.common.spi.JavaEEContainer;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.EntityManagerMethod;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.SimpleResource;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.PersistenceContextType;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.SynchronizationType;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.metamodel.Metamodel;
import javax.transaction.TransactionManager;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

public class EntityManagerWrapper
implements EntityManager,
Serializable {
    static Logger _logger = LogDomains.getLogger(EntityManagerWrapper.class, (String)"javax.enterprise.system.util");
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private SynchronizationType synchronizationType;
    private transient EntityManagerFactory entityManagerFactory;
    private transient TransactionManager txManager;
    private transient InvocationManager invMgr;
    private transient EntityManager extendedEntityManager;
    private transient ComponentEnvManager compEnvMgr;
    private transient CallFlowAgent callFlowAgent;
    private static final Class INVOCATION_PAYLOAD_KEY = EntityManagerWrapper.class;

    public EntityManagerWrapper(TransactionManager txManager, InvocationManager invMgr, ComponentEnvManager compEnvMgr, CallFlowAgent callFlowAgent) {
        this.txManager = txManager;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
        this.callFlowAgent = callFlowAgent;
    }

    public void initializeEMWrapper(String unitName, PersistenceContextType contextType, SynchronizationType synchronizationType, Map emProperties) {
        this.unitName = unitName;
        this.contextType = contextType;
        this.synchronizationType = synchronizationType;
        this.emProperties = emProperties;
        if (contextType == PersistenceContextType.EXTENDED) {
            this._getDelegate();
        }
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        if (this.getCurrentTransaction() == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        EntityManager delegate;
        if (this.entityManagerFactory == null) {
            this.init();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            JavaEETransaction tx = this.getCurrentTransaction();
            if (tx != null) {
                PhysicalEntityManagerWrapper propagatedPersistenceContext = EntityManagerWrapper.getExtendedEntityManager(tx, this.entityManagerFactory);
                if (propagatedPersistenceContext == null) {
                    propagatedPersistenceContext = EntityManagerWrapper.getTxEntityManager(tx, this.entityManagerFactory);
                    if (propagatedPersistenceContext == null) {
                        EntityManager em = this.entityManagerFactory.createEntityManager(this.synchronizationType, this.emProperties);
                        propagatedPersistenceContext = new PhysicalEntityManagerWrapper(em, this.synchronizationType);
                        tx.addTxEntityManagerMapping(this.entityManagerFactory, (SimpleResource)propagatedPersistenceContext);
                    } else if (this.synchronizationType == SynchronizationType.SYNCHRONIZED && propagatedPersistenceContext.getSynchronizationType() == SynchronizationType.UNSYNCHRONIZED) {
                        throw new IllegalStateException("Detected an UNSYNCHRONIZED  persistence context being propagated to SYNCHRONIZED persistence context.");
                    }
                }
                delegate = propagatedPersistenceContext.getEM();
            } else {
                delegate = this.getNonTxEMFromCurrentInvocation();
            }
        } else {
            Object cc;
            ComponentInvocation ci;
            if (this.extendedEntityManager == null && (ci = this.invMgr.getCurrentInvocation()) != null && (cc = ci.getContainer()) instanceof JavaEEContainer) {
                this.extendedEntityManager = ((JavaEEContainer)cc).lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("In EntityManagerWrapper::_getDelegate(). Logical entity manager  = " + this);
            _logger.fine("Physical entity manager = " + delegate);
        }
        return delegate;
    }

    private JavaEETransaction getCurrentTransaction() {
        try {
            return (JavaEETransaction)this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
    }

    private EntityManager getNonTxEMFromCurrentInvocation() {
        EntityManager nonTxEM;
        ComponentInvocation currentInvocation = this.invMgr.getCurrentInvocation();
        Map<EntityManagerFactory, EntityManager> nonTxEMs = EntityManagerWrapper.getNonTxEMsFromCurrentInvocation(currentInvocation);
        if (nonTxEMs == null) {
            nonTxEMs = new HashMap<EntityManagerFactory, EntityManager>();
            currentInvocation.setRegistryFor(INVOCATION_PAYLOAD_KEY, nonTxEMs);
        }
        if ((nonTxEM = nonTxEMs.get(this.entityManagerFactory)) == null) {
            nonTxEM = this.entityManagerFactory.createEntityManager(this.synchronizationType, this.emProperties);
            nonTxEMs.put(this.entityManagerFactory, nonTxEM);
        }
        return nonTxEM;
    }

    private static Map<EntityManagerFactory, EntityManager> getNonTxEMsFromCurrentInvocation(ComponentInvocation currentInvocation) {
        return (Map)currentInvocation.getRegistryFor(INVOCATION_PAYLOAD_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.PERSIST);
            }
            this._getDelegate().persist(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T merge(T entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.MERGE);
            }
            Object object = this._getDelegate().merge(entity);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REMOVE);
            }
            this._getDelegate().remove(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey);
            this.clearPersistenceContextPerhaps(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = this._getDelegate().find(entityClass, primaryKey, properties);
            this.clearPersistenceContextPerhaps(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = this._getDelegate().find(entityClass, primaryKey, lockMode);
            this.clearPersistenceContextPerhaps(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE_PROPERTIES);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = this._getDelegate().find(entityClass, primaryKey, lockMode, properties);
            this.clearPersistenceContextPerhaps(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_REFERENCE);
            }
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FLUSH);
            }
            this._getDelegate().flush();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString);
            if (this.getCurrentTransaction() == null) {
                returnValue = QueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String ejbqlString, Class<T> resultClass) {
        TypedQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString, resultClass);
            if (this.getCurrentTransaction() == null) {
                returnValue = TypedQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(criteriaQuery);
            if (this.getCurrentTransaction() == null) {
                returnValue = TypedQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name);
            if (this.getCurrentTransaction() == null) {
                returnValue = QueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        TypedQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name, resultClass);
            if (this.getCurrentTransaction() == null) {
                returnValue = TypedQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString);
            if (this.getCurrentTransaction() == null) {
                returnValue = QueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultClass);
            if (this.getCurrentTransaction() == null) {
                returnValue = QueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
            if (this.getCurrentTransaction() == null) {
                returnValue = QueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH);
            }
            this._getDelegate().refresh(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_PROPERTIES);
            }
            this._getDelegate().refresh(entity, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE);
            }
            this._getDelegate().refresh(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE_MAP);
            }
            this._getDelegate().refresh(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CONTAINS);
            }
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LockModeType getLockMode(Object o) {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_LOCK_MODE);
            }
            LockModeType lockModeType = this._getDelegate().getLockMode(o);
            return lockModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String propertyName, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_PROPERTY);
            }
            this._getDelegate().setProperty(propertyName, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getProperties() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_PROPERTIES);
            }
            Map map = this._getDelegate().getProperties();
            return map;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void close() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLOSE);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        throw new IllegalStateException();
    }

    public boolean isOpen() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_OPEN);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityTransaction getTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_TRANSACTION);
            }
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory getEntityManagerFactory() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_MANAGER_FACTORY);
            }
            if (this.entityManagerFactory == null) {
                this.init();
            }
            EntityManagerFactory entityManagerFactory = this.entityManagerFactory;
            return entityManagerFactory;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CriteriaBuilder getCriteriaBuilder() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_CRITERIA_BUILDER);
            }
            CriteriaBuilder criteriaBuilder = this._getDelegate().getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Metamodel getMetamodel() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_METAMODEL);
            }
            Metamodel metamodel = this._getDelegate().getMetamodel();
            return metamodel;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK);
            }
            this._getDelegate().lock(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK_LOCKMODETYPE_MAP);
            }
            this._getDelegate().lock(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLEAR);
            }
            this._getDelegate().clear();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(Object o) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.DETATCH);
            }
            this._getDelegate().detach(o);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_DELEGATE);
            }
            EntityManager entityManager = this._getDelegate();
            return entityManager;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlushMode(FlushModeType flushMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_FLUSH_MODE);
            }
            this._getDelegate().setFlushMode(flushMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void joinTransaction() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.JOIN_TRANSACTION);
            }
            this._getDelegate().joinTransaction();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T unwrap(Class<T> tClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.UNWRAP);
            }
            Object object = this._getDelegate().unwrap(tClass);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_STORED_PROCEDURE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedStoredProcedureQuery(name);
            if (this.getCurrentTransaction() == null) {
                returnValue = StoreProcedureQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName);
            if (this.getCurrentTransaction() == null) {
                returnValue = StoreProcedureQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName, resultClasses);
            if (this.getCurrentTransaction() == null) {
                returnValue = StoreProcedureQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName, resultSetMappings);
            if (this.getCurrentTransaction() == null) {
                returnValue = StoreProcedureQueryWrapper.createQueryWrapper(returnValue, delegate);
            }
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(CriteriaUpdate updateQuery) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_UPDATE);
            }
            Query query = this._getDelegate().createQuery(updateQuery);
            return query;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(CriteriaDelete deleteQuery) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_DELETE);
            }
            Query query = this._getDelegate().createQuery(deleteQuery);
            return query;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJoinedToTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_JOINED_TO_TRANSACTION);
            }
            boolean bl = this._getDelegate().isJoinedToTransaction();
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_ENTITY_GRAPH_CLASS);
            }
            EntityGraph entityGraph = this._getDelegate().createEntityGraph(rootType);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityGraph<?> createEntityGraph(String graphName) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_ENTITY_GRAPH_STRING);
            }
            EntityGraph entityGraph = this._getDelegate().createEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityGraph<?> getEntityGraph(String graphName) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_GRAPH);
            }
            EntityGraph entityGraph = this._getDelegate().getEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_GRAPHS);
            }
            List list = this._getDelegate().getEntityGraphs(entityClass);
            return list;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ServiceLocator defaultServiceLocator = Globals.getDefaultHabitat();
        this.txManager = (TransactionManager)defaultServiceLocator.getService(TransactionManager.class, new Annotation[0]);
        this.invMgr = (InvocationManager)defaultServiceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.compEnvMgr = (ComponentEnvManager)defaultServiceLocator.getService(ComponentEnvManager.class, new Annotation[0]);
        this.callFlowAgent = (CallFlowAgent)defaultServiceLocator.getService(CallFlowAgent.class, new Annotation[0]);
    }

    private void clearPersistenceContextPerhaps(EntityManager em) {
        if (this.getCurrentTransaction() == null && this.contextType != PersistenceContextType.EXTENDED) {
            em.clear();
        }
    }

    public static PhysicalEntityManagerWrapper getExtendedEntityManager(JavaEETransaction transaction, EntityManagerFactory factory) {
        return (PhysicalEntityManagerWrapper)transaction.getExtendedEntityManagerResource(factory);
    }

    public static PhysicalEntityManagerWrapper getTxEntityManager(JavaEETransaction transaction, EntityManagerFactory factory) {
        return (PhysicalEntityManagerWrapper)transaction.getTxEntityManagerResource(factory);
    }

    @Service
    public static class NonTxEMCleaner
    implements ComponentInvocationHandler {
        public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
        }

        public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
            Map nonTxEMs = EntityManagerWrapper.getNonTxEMsFromCurrentInvocation(curInv);
            if (nonTxEMs != null) {
                for (EntityManager nonTxEM : nonTxEMs.values()) {
                    nonTxEM.close();
                }
            }
        }

        public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }
    }
}

