/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import org.glassfish.web.deployment.descriptor.CookieConfigDescriptor;
import org.glassfish.web.deployment.descriptor.SessionConfigDescriptor;
import org.glassfish.web.deployment.node.CookieConfigNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SessionConfigNode
extends DeploymentDescriptorNode {
    private SessionConfigDescriptor descriptor;

    public SessionConfigNode() {
        this.registerElementHandler(new XMLElement("cookie-config"), CookieConfigNode.class, "setCookieConfig");
    }

    public SessionConfigDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new SessionConfigDescriptor();
        }
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("session-timeout".equals(element.getQName())) {
            if (this.descriptor.getSessionTimeout() != 30) {
                throw new RuntimeException("Has more than one session-config element!");
            }
            this.descriptor.setSessionTimeout(Integer.valueOf(value.trim()));
        } else if ("tracking-mode".equals(element.getQName())) {
            this.descriptor.addTrackingMode(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, SessionConfigDescriptor descriptor) {
        CookieConfigDescriptor cookieConfigDesc;
        Element myNode = SessionConfigNode.appendChild((Node)parent, (String)nodeName);
        if (descriptor.getSessionTimeout() != 30) {
            SessionConfigNode.appendTextChild((Node)myNode, (String)"session-timeout", (String)String.valueOf(descriptor.getSessionTimeout()));
        }
        if ((cookieConfigDesc = (CookieConfigDescriptor)descriptor.getCookieConfig()) != null) {
            CookieConfigNode cookieConfigNode = new CookieConfigNode();
            cookieConfigNode.writeDescriptor((Node)myNode, "cookie-config", cookieConfigDesc);
        }
        if (descriptor.getTrackingModes().size() > 0) {
            for (Enum enum_ : descriptor.getTrackingModes()) {
                SessionConfigNode.appendTextChild((Node)myNode, (String)"tracking-mode", (String)enum_.name());
            }
        }
        return myNode;
    }
}

