/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector;

import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.web.WebContainer;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.ContextsAdapterUtility;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.util.RequestUtil;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.logging.annotation.LogMessageInfo;

public class MapperListener
implements NotificationListener,
NotificationFilter {
    private String defaultHost;
    private String domain = "*";
    private transient Engine engine = null;
    public transient HttpService httpService;
    protected static final Logger logger = WebContainer.logger;
    protected static final ResourceBundle rb = logger.getResourceBundle();
    @LogMessageInfo(message="Cannot find WebContainer implementation", level="SEVERE", cause="Web container is null", action="Check if the mapper listener is initialized correctly")
    public static final String CANNOT_FIND_WEB_CONTAINER = "AS-WEB-GLUE-00084";
    @LogMessageInfo(message="Cannot find Engine implementation", level="SEVERE", cause="Engine is null", action="Check if the mapper listener is initialized correctly")
    public static final String CANNOT_FIND_ENGINE = "AS-WEB-GLUE-00085";
    @LogMessageInfo(message="Error registering contexts", level="WARNING")
    public static final String ERROR_REGISTERING_CONTEXTS = "AS-WEB-GLUE-00086";
    @LogMessageInfo(message="HTTP listener with network listener name {0} ignoring registration of host with object name {1}, because none of the host's associated HTTP listeners matches this network listener name", level="FINE")
    public static final String IGNORE_HOST_REGISTRATIONS = "AS-WEB-GLUE-00087";
    @LogMessageInfo(message="Register Context {0}", level="FINE")
    public static final String REGISTER_CONTEXT = "AS-WEB-GLUE-00088";
    @LogMessageInfo(message="Unregister Context {0}", level="FINE")
    public static final String UNREGISTER_CONTEXT = "AS-WEB-GLUE-00089";
    @LogMessageInfo(message="Register Wrapper {0} in Context {1}", level="FINE")
    public static final String REGISTER_WRAPPER = "AS-WEB-GLUE-00090";
    protected transient Mapper mapper = null;
    private String myInstance;
    private String networkListenerName;
    private ConcurrentHashMap<ObjectName, String[]> virtualServerListenerNames;
    private transient WebContainer webContainer;

    public MapperListener(Mapper mapper, WebContainer webContainer) {
        this.mapper = mapper;
        this.virtualServerListenerNames = new ConcurrentHashMap();
        this.webContainer = webContainer;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getNetworkListenerName() {
        return this.networkListenerName;
    }

    public void setNetworkListenerName(String networkListenerName) {
        this.networkListenerName = networkListenerName;
    }

    public String getDefaultHost() {
        return this.defaultHost;
    }

    public void setDefaultHost(String defaultHost) {
        this.defaultHost = defaultHost;
    }

    public void setInstanceName(String instanceName) {
        this.myInstance = instanceName;
    }

    public void init() {
        if (this.webContainer == null) {
            logger.log(Level.SEVERE, CANNOT_FIND_WEB_CONTAINER);
            return;
        }
        try {
            this.httpService = this.webContainer.getHttpService();
            this.engine = this.webContainer.getEngine();
            if (this.engine == null) {
                logger.log(Level.SEVERE, CANNOT_FIND_ENGINE);
                return;
            }
            if (this.defaultHost != null) {
                this.mapper.setDefaultHostName(this.defaultHost);
            }
            for (VirtualServer vs : this.httpService.getVirtualServer()) {
                Container host = this.engine.findChild(vs.getId());
                if (!(host instanceof StandardHost)) continue;
                this.registerHost((StandardHost)host);
                for (Container context : host.findChildren()) {
                    if (!(context instanceof StandardContext)) continue;
                    this.registerContext((StandardContext)context);
                    for (Container wrapper : context.findChildren()) {
                        if (!(wrapper instanceof StandardWrapper)) continue;
                        this.registerWrapper((StandardWrapper)wrapper);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, ERROR_REGISTERING_CONTEXTS, e);
        }
    }

    @Override
    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
            String otherDomain = objectName.getDomain();
            if (this.domain != null && !this.domain.equals(otherDomain)) {
                return false;
            }
            String otherInstance = objectName.getKeyProperty("J2EEServer");
            if (this.myInstance != null && otherInstance != null && !otherInstance.equals(this.myInstance)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (notification.getType().equals("j2ee.object.created")) {
            ContainerBase container = (ContainerBase)notification.getSource();
            if (container instanceof StandardHost) {
                try {
                    this.registerHost((StandardHost)container);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error registering Host " + container.getObjectName(), e);
                }
            } else if (container instanceof StandardContext) {
                try {
                    this.registerContext((StandardContext)container);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error registering Context " + container.getObjectName(), t);
                }
            } else if (container instanceof StandardWrapper) {
                try {
                    this.registerWrapper((StandardWrapper)container);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error registering Wrapper " + container.getObjectName(), t);
                }
            }
        } else if (notification.getType().equals("j2ee.object.deleted")) {
            ObjectName objectName;
            ContainerBase container = (ContainerBase)notification.getSource();
            if (container instanceof StandardHost) {
                try {
                    this.unregisterHost(container.getJmxName());
                }
                catch (Exception e) {
                    throw new RuntimeException("Error unregistering Host " + container.getObjectName(), e);
                }
            }
            if (container instanceof StandardContext) {
                try {
                    this.unregisterContext(container.getJmxName());
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error unregistering webapp " + container.getObjectName(), t);
                }
            }
            if (container instanceof StandardWrapper && Boolean.parseBoolean((objectName = container.getJmxName()).getKeyProperty("osgi")) && objectName.getKeyProperty("j2eeType").equals("Servlet")) {
                try {
                    this.unregisterOSGiWrapper(objectName);
                }
                catch (Throwable t) {
                    throw new RuntimeException("Error unregistering osgi wrapper " + objectName, t);
                }
            }
        }
    }

    public void registerHost(StandardHost host) throws Exception {
        if (host.getJmxName() == null) {
            return;
        }
        String name = host.getName();
        String[] nlNames = host.getNetworkListenerNames();
        boolean nameMatch = false;
        if (nlNames != null) {
            for (String nlName : nlNames) {
                if (!nlName.equals(this.networkListenerName)) continue;
                nameMatch = true;
                break;
            }
        }
        if (!nameMatch) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, IGNORE_HOST_REGISTRATIONS, new Object[]{this.networkListenerName, name});
            }
            return;
        }
        this.virtualServerListenerNames.put(host.getJmxName(), nlNames);
        String[] aliases = host.findAliases();
        this.mapper.addHost(name, aliases, (Object)host);
    }

    public void unregisterHost(ObjectName objectName) throws Exception {
        String name = objectName.getKeyProperty("host");
        if (name != null) {
            String[] nlNames = this.virtualServerListenerNames.get(objectName);
            boolean nameMatch = false;
            if (nlNames != null) {
                this.virtualServerListenerNames.remove(objectName);
                for (String nlName : nlNames) {
                    if (!nlName.equals(this.networkListenerName)) continue;
                    nameMatch = true;
                    break;
                }
            }
            if (!nameMatch) {
                return;
            }
        }
        this.mapper.removeHost(name);
    }

    private void registerContext(StandardContext context) throws Exception {
        int slash;
        ObjectName objectName = context.getJmxName();
        if (objectName == null) {
            return;
        }
        String name = objectName.getKeyProperty("name");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode((String)contextName, (String)"UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, REGISTER_CONTEXT, contextName);
        }
        DirContext resources = context.findStaticResources();
        String[] welcomeFiles = context.getWelcomeFiles();
        this.mapper.addContext(hostName, contextName, (Object)context, welcomeFiles, ContextsAdapterUtility.wrap((Context)resources), (List)context.getAlternateDocBases());
    }

    private void unregisterContext(ObjectName objectName) throws Exception {
        int slash;
        String name = objectName.getKeyProperty("name");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode((String)contextName, (String)"UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        DataChunk hostDC = DataChunk.newInstance();
        hostDC.setString(hostName);
        DataChunk contextDC = DataChunk.newInstance();
        contextDC.setString(contextName);
        MappingData mappingData = new MappingData();
        this.mapper.map(hostDC, contextDC, mappingData);
        if (mappingData.context instanceof StandardContext && ((StandardContext)mappingData.context).getPaused()) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, UNREGISTER_CONTEXT, contextName);
        }
        this.mapper.removeContext(hostName, contextName);
    }

    private void registerWrapper(StandardWrapper wrapper) throws Exception {
        int slash;
        ObjectName objectName = wrapper.getJmxName();
        if (objectName == null) {
            return;
        }
        String wrapperName = objectName.getKeyProperty("name");
        String name = objectName.getKeyProperty("WebModule");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode((String)contextName, (String)"UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        String msg = MessageFormat.format(rb.getString(REGISTER_WRAPPER), wrapperName, contextName);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(msg);
        }
        String[] mappings = wrapper.findMappings();
        for (int i = 0; i < mappings.length; ++i) {
            boolean jspWildCard = wrapperName.equals("jsp") && mappings[i].endsWith("/*");
            this.mapper.addWrapper(hostName, contextName, mappings[i], (Object)wrapper, jspWildCard, wrapperName, true);
        }
    }

    private void unregisterOSGiWrapper(ObjectName objectName) throws Exception {
        String mapping;
        int slash;
        String targetDomain = objectName.getDomain();
        if (!this.domain.equals(targetDomain)) {
            return;
        }
        String name = objectName.getKeyProperty("WebModule");
        String hostName = null;
        String contextName = null;
        if (name.startsWith("//")) {
            name = name.substring(2);
        }
        if ((slash = name.indexOf("/")) == -1) {
            return;
        }
        hostName = name.substring(0, slash);
        contextName = name.substring(slash);
        contextName = RequestUtil.urlDecode((String)contextName, (String)"UTF-8");
        if (contextName.equals("/")) {
            contextName = "";
        }
        mapping = "/".equals(mapping = objectName.getKeyProperty("name")) ? "/*" : mapping + "/*";
        this.mapper.removeWrapper(hostName, contextName, mapping);
    }
}

