/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.enablement;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.bootstrap.enablement.ModuleEnablement;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.bootstrap.spi.Metadata;
import org.jboss.weld.exceptions.DeploymentException;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.logging.LogMessageCallback;
import org.jboss.weld.logging.ValidatorLogger;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.resources.spi.ResourceLoadingException;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ListView;
import org.jboss.weld.util.collections.ViewProvider;
import org.jboss.weld.util.reflection.Reflections;

public class GlobalEnablementBuilder
extends AbstractBootstrapService {
    private final List<Item> alternatives = Collections.synchronizedList(new ArrayList());
    private final List<Item> interceptors = Collections.synchronizedList(new ArrayList());
    private final List<Item> decorators = Collections.synchronizedList(new ArrayList());
    private volatile Map<Class<?>, Integer> cachedAlternativeMap;
    private volatile boolean sorted;

    private void addItem(List<Item> list, Class<?> javaClass, int priority) {
        list.add(new Item(javaClass, priority));
    }

    public void addAlternative(Class<?> javaClass, int priority) {
        this.addItem(this.alternatives, javaClass, priority);
    }

    public void addInterceptor(Class<?> javaClass, int priority) {
        this.addItem(this.interceptors, javaClass, priority);
    }

    public void addDecorator(Class<?> javaClass, int priority) {
        this.addItem(this.decorators, javaClass, priority);
    }

    public List<Class<?>> getAlternativeList() {
        this.initialize();
        return new AbstractEnablementListView(){

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.alternatives;
            }
        };
    }

    public List<Class<?>> getInterceptorList() {
        this.initialize();
        return new AbstractEnablementListView(){

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.interceptors;
            }
        };
    }

    public List<Class<?>> getDecoratorList() {
        this.initialize();
        return new AbstractEnablementListView(){

            @Override
            protected List<Item> getDelegate() {
                return GlobalEnablementBuilder.this.decorators;
            }
        };
    }

    private Map<Class<?>, Integer> getGlobalAlternativeMap() {
        if (this.cachedAlternativeMap == null) {
            HashMap<Class, Integer> map = new HashMap<Class, Integer>();
            ListIterator<Item> iterator = this.alternatives.listIterator();
            while (iterator.hasNext()) {
                Item item = iterator.next();
                map.put(item.javaClass, iterator.previousIndex());
            }
            this.cachedAlternativeMap = ImmutableMap.copyOf(map);
        }
        return this.cachedAlternativeMap;
    }

    private void initialize() {
        if (!this.sorted) {
            Collections.sort(this.alternatives);
            Collections.sort(this.interceptors);
            Collections.sort(this.decorators);
            this.sorted = true;
        }
    }

    public ModuleEnablement createModuleEnablement(BeanDeployment deployment) {
        ClassLoader loader = new ClassLoader(deployment.getBeanManager().getServices().get(ResourceLoader.class));
        BeansXml beansXml = deployment.getBeanDeploymentArchive().getBeansXml();
        ImmutableList.Builder moduleInterceptorsBuilder = ImmutableList.builder();
        ImmutableList.Builder moduleDecoratorsBuilder = ImmutableList.builder();
        ImmutableSet alternativeClasses = null;
        Set alternativeStereotypes = null;
        moduleInterceptorsBuilder.addAll(this.getInterceptorList());
        moduleDecoratorsBuilder.addAll(this.getDecoratorList());
        if (beansXml != null) {
            List localInterceptors = Lists.transform(GlobalEnablementBuilder.checkForDuplicates(beansXml.getEnabledInterceptors(), ValidatorLogger.INTERCEPTOR_SPECIFIED_TWICE_CALLBACK), (Function)loader);
            moduleInterceptorsBuilder.addAll((Iterable)localInterceptors);
            List localDecorators = Lists.transform(GlobalEnablementBuilder.checkForDuplicates(beansXml.getEnabledDecorators(), ValidatorLogger.DECORATOR_SPECIFIED_TWICE_CALLBACK), (Function)loader);
            moduleDecoratorsBuilder.addAll((Iterable)localDecorators);
            alternativeClasses = ImmutableSet.copyOf((Collection)Lists.transform(GlobalEnablementBuilder.checkForDuplicates(beansXml.getEnabledAlternativeClasses(), ValidatorLogger.ALTERNATIVE_CLASS_SPECIFIED_MULTIPLE_TIMES_CALLBACK), (Function)loader));
            alternativeStereotypes = (Set)Reflections.cast(ImmutableSet.copyOf((Collection)Lists.transform(GlobalEnablementBuilder.checkForDuplicates(beansXml.getEnabledAlternativeStereotypes(), ValidatorLogger.ALTERNATIVE_STEREOTYPE_SPECIFIED_MULTIPLE_TIMES_CALLBACK), (Function)loader)));
        } else {
            alternativeClasses = Collections.emptySet();
            alternativeStereotypes = Collections.emptySet();
        }
        Map<Class<?>, Integer> globalAlternatives = this.getGlobalAlternativeMap();
        return new ModuleEnablement((List<Class<?>>)moduleInterceptorsBuilder.build(), (List<Class<?>>)moduleDecoratorsBuilder.build(), globalAlternatives, (Set<Class<?>>)alternativeClasses, alternativeStereotypes);
    }

    private static <T> List<Metadata<T>> checkForDuplicates(List<Metadata<T>> list, LogMessageCallback messageCallback) {
        HashMap<T, Metadata<T>> map = new HashMap<T, Metadata<T>>();
        for (Metadata<T> item : list) {
            Metadata<T> previousOccurrence = map.put(item.getValue(), item);
            if (previousOccurrence == null) continue;
            throw new DeploymentException(messageCallback.invoke(item.getValue(), item, previousOccurrence));
        }
        return list;
    }

    @Override
    public void cleanupAfterBoot() {
        this.alternatives.clear();
        this.interceptors.clear();
        this.decorators.clear();
    }

    public String toString() {
        return "GlobalEnablementBuilder [alternatives=" + this.alternatives + ", interceptors=" + this.interceptors + ", decorators=" + this.decorators + "]";
    }

    private static abstract class AbstractEnablementListView
    extends ListView<Item, Class<?>> {
        private AbstractEnablementListView() {
        }

        @Override
        protected ViewProvider<Item, Class<?>> getViewProvider() {
            return ItemViewProvider.ITEM_VIEW_PROVIDER;
        }
    }

    private static class ClassLoader
    implements Function<Metadata<String>, Class<?>> {
        private final ResourceLoader resourceLoader;

        public ClassLoader(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public Class<?> apply(Metadata<String> from) {
            try {
                return this.resourceLoader.classForName(from.getValue());
            }
            catch (ResourceLoadingException e) {
                throw BootstrapLogger.LOG.errorLoadingBeansXmlEntry(from.getValue(), from.getLocation(), e.getCause());
            }
            catch (Exception e) {
                throw BootstrapLogger.LOG.errorLoadingBeansXmlEntry(from.getValue(), from.getLocation(), e);
            }
        }
    }

    private static class Item
    implements Comparable<Item> {
        private final Class<?> javaClass;
        private final Integer priority;

        private Item(Class<?> javaClass) {
            this(javaClass, null);
        }

        private Item(Class<?> javaClass, Integer priority) {
            Preconditions.checkArgumentNotNull(javaClass, "javaClass");
            this.javaClass = javaClass;
            this.priority = priority;
        }

        @Override
        public int compareTo(Item o) {
            if (this.priority.equals(o.priority)) {
                return this.javaClass.getName().compareTo(o.javaClass.getName());
            }
            return this.priority - o.priority;
        }

        public int hashCode() {
            return this.javaClass.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Item) {
                Item that = (Item)obj;
                return Objects.equal(this.javaClass, that.javaClass);
            }
            return false;
        }

        public String toString() {
            return "[Class=" + this.javaClass + ", priority=" + this.priority + "]";
        }
    }

    private static class ItemViewProvider
    implements ViewProvider<Item, Class<?>> {
        private static ItemViewProvider ITEM_VIEW_PROVIDER = new ItemViewProvider();

        private ItemViewProvider() {
        }

        @Override
        public Class<?> toView(Item item) {
            return item.javaClass;
        }

        @Override
        public Item fromView(Class<?> javaClass) {
            return new Item((Class)javaClass);
        }
    }
}

