/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.registration;

import com.sun.enterprise.registration.glassfish.RegistrationUtil;
import com.sun.enterprise.registration.impl.RelayService;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Random;
import java.util.logging.Logger;
import org.glassfish.admingui.common.util.GuiUtil;

public class RegisterHandlers {
    public static void getSupportImages(HandlerContext handlerCtx) {
        int maxImageCount = 26;
        ArrayList<String> result = new ArrayList<String>();
        int cnt = (Integer)handlerCtx.getInputValue("count");
        Random random = new Random();
        for (int i = 0; i < cnt; ++i) {
            int num;
            String imgName;
            do {
                num = Math.abs(random.nextInt() % maxImageCount);
            } while (result.contains(imgName = "square-" + num + ".gif"));
            result.add(imgName);
        }
        handlerCtx.setOutputValue("imageList", result);
    }

    public static void getIssueQueryString(HandlerContext handlerCtx) {
        GregorianCalendar current = new GregorianCalendar();
        ((Calendar)current).add(10, -168);
        int month = Integer.parseInt("" + current.get(2)) + 1;
        String startTime = "" + current.get(1) + "-" + month + "-" + current.get(5);
        String query = "https://glassfish.dev.java.net/issues/buglist.cgi?component=glassfish&issue_status=RESOLVED&chfield=issue_status&chfieldto=Now&cmdtype=doit&chfieldfrom=" + startTime;
        handlerCtx.setOutputValue("query", (Object)query);
    }

    private static File getDefaultRegistrationPage() {
        Logger logger = GuiUtil.getLogger();
        File f = new File(RegistrationUtil.getRegistrationHome(), "registration.html");
        if (f.exists()) {
            return f;
        }
        try {
            String regPage = f.getAbsolutePath();
            if (!f.exists()) {
                RelayService rs = new RelayService(RegistrationUtil.getServiceTagRegistry());
                rs.generateRegistrationPage(regPage);
            }
        }
        catch (Exception ex) {
            logger.fine(ex.getMessage());
        }
        return f;
    }

    public static void isRegistrationEnabled(HandlerContext handlerCtx) {
        File dir = RegistrationUtil.getRegistrationHome();
        File regFile = new File(dir, "registration.html");
        if (dir.exists() && (dir.canWrite() || regFile.exists())) {
            handlerCtx.setOutputValue("isEnabled", (Object)Boolean.TRUE);
        } else {
            handlerCtx.setOutputValue("isEnabled", (Object)Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getRegistrationLandingPage(HandlerContext handlerCtx) {
        File f = RegisterHandlers.getDefaultRegistrationPage();
        if (!f.exists()) {
            return;
        }
        BufferedReader br = null;
        try {
            String s;
            FileReader fr = new FileReader(f);
            br = new BufferedReader(fr);
            StringBuilder pageContent = new StringBuilder("");
            while ((s = br.readLine()) != null) {
                pageContent.append(s);
            }
            handlerCtx.setOutputValue("registrationPage", (Object)pageContent.toString());
        }
        catch (Exception ex) {
            Logger logger = GuiUtil.getLogger();
            logger.fine(ex.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

