/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.core;

import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSNotEnabledException;
import com.sun.enterprise.ee.cms.core.GMSNotInitializedException;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.StringManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GMSFactory {
    private static Logger LOG = Logger.getLogger("ShoalLogger.api", "com.sun.enterprise.ee.cms.core.LogStrings");
    private static StringManager sm = StringManager.getInstance();
    private static Hashtable<String, GroupManagementService> groups = new Hashtable();
    private static Map<String, Boolean> gmsEnabledMap = new HashMap<String, Boolean>();
    private static String memberToken;

    private GMSFactory() {
    }

    public static Runnable startGMSModule(String serverToken, String groupName, GroupManagementService.MemberType memberType, Properties properties) {
        if (serverToken == null) {
            throw new RuntimeException(sm.get("ex.factory.start.missing.instance", new Object[0]));
        }
        if (groupName == null) {
            throw new RuntimeException(sm.get("ex.factory.start.missing.group", new Object[0]));
        }
        GroupManagementService gms = null;
        gmsEnabledMap.put(groupName, Boolean.TRUE);
        try {
            gms = GMSFactory.getGMSModule(groupName);
        }
        catch (GMSException e) {
            gms = GMSFactory.getGroupManagementServiceInstance();
            gms.initialize(serverToken, groupName, memberType, properties);
            memberToken = serverToken;
            groups.put(GMSFactory.getCompositeKey(groupName), gms);
        }
        return (Runnable)((Object)gms);
    }

    public static GroupManagementService getGMSModule(String groupName) throws GMSNotEnabledException, GMSException, GMSNotInitializedException {
        if (groupName == null) {
            throw new GMSException(sm.get("ex.factory.start.missing.group", new Object[0]));
        }
        String key = GMSFactory.getCompositeKey(groupName);
        if (groups.containsKey(key)) {
            return groups.get(key);
        }
        if (!GMSFactory.isGMSEnabled(groupName)) {
            throw new GMSNotEnabledException(sm.get("ex.factory.get.gms.is.disabled", groupName));
        }
        throw new GMSNotInitializedException(sm.get("ex.factory.get.not.init", groupName));
    }

    public static GroupManagementService getGMSModule() throws GMSException {
        Collection instances = GMSFactory.getAllGMSInstancesForMember();
        if (instances.size() == 0) {
            throw new GMSNotInitializedException(sm.get("ex.init.failure", new Object[0]));
        }
        GroupManagementService gms = (GroupManagementService)instances.toArray()[0];
        return gms;
    }

    public static Collection getAllGMSInstancesForMember() {
        return groups.values();
    }

    private static String getCompositeKey(String groupName) {
        return memberToken + "::" + groupName;
    }

    public static boolean isGMSEnabled(String groupName) {
        Boolean val = gmsEnabledMap.get(groupName);
        return val != null && !val.equals(Boolean.FALSE);
    }

    public static void setGMSEnabledState(String groupName, Boolean value) {
        gmsEnabledMap.put(groupName, value);
    }

    public static void removeGMSModule(String groupName) {
        String key;
        if (groupName != null && groups.containsKey(key = GMSFactory.getCompositeKey(groupName))) {
            groups.remove(key);
        }
    }

    private static GroupManagementService findByServiceLoader() {
        GroupManagementService groupManagementService = null;
        ServiceLoader<GroupManagementService> loader = ServiceLoader.load(GroupManagementService.class);
        Iterator<GroupManagementService> iter = loader.iterator();
        if (iter.hasNext()) {
            try {
                groupManagementService = (GroupManagementService)iter.next().getClass().newInstance();
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "factory.load.service.error");
                LOG.log(Level.WARNING, "stack trace", t);
            }
        }
        if (groupManagementService == null) {
            LOG.log(Level.SEVERE, sm.get("factory.fatal", new Object[0]));
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "factory.findservice", new Object[]{groupManagementService.getClass().getName()});
        }
        return groupManagementService;
    }

    private static GroupManagementService findByClassLoader(String classname) {
        GroupManagementService gmsImpl = null;
        try {
            Class<?> GmsImplClass = Class.forName(classname);
            gmsImpl = (GroupManagementService)GmsImplClass.newInstance();
            if (gmsImpl == null) {
                LOG.log(Level.SEVERE, "factory.load.service.error");
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "findByClassLoader() loaded service " + gmsImpl.getClass().getName());
            }
        }
        catch (Throwable x) {
            LOG.log(Level.SEVERE, "factory.classload.failed");
            LOG.log(Level.SEVERE, "stack trace", x);
        }
        return gmsImpl;
    }

    public static GroupManagementService getGroupManagementServiceInstance() {
        GroupManagementService gmsImpl = null;
        try {
            gmsImpl = GMSFactory.findByServiceLoader();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (gmsImpl == null) {
            String classname = null;
            classname = "com.sun.enterprise.ee.cms.impl.common.GroupManagementServiceImpl";
            gmsImpl = GMSFactory.findByClassLoader(classname);
        }
        return gmsImpl;
    }
}

