/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.rssowl.core.internal.Activator;

public class StreamGobbler
extends Job {
    private final InputStream fIs;

    public StreamGobbler(InputStream is) {
        super("");
        this.setSystem(true);
        this.fIs = is;
    }

    protected IStatus run(IProgressMonitor monitor) {
        BufferedReader br = null;
        try {
            try {
                String line;
                StringBuilder msg = new StringBuilder("");
                br = new BufferedReader(new InputStreamReader(this.fIs));
                while ((line = br.readLine()) != null) {
                    msg.append(line);
                }
                if (msg.toString().trim().length() > 0) {
                    Activator.getDefault().logInfo(msg.toString());
                }
            }
            catch (IOException e) {
                Activator.safeLogError(e.getMessage(), e);
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    Activator.safeLogError(e2.getMessage(), e2);
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                Activator.safeLogError(e.getMessage(), e);
            }
        }
        return Status.OK_STATUS;
    }
}

