/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.rssowl.core.internal.Activator;

public class ExtensionUtils {
    public static final String RSSOWL_NAMESPACE = "org.rssowl";
    public static final String RSSOWL_TESTS_NAMESPACE = "org.rssowl.core.tests";
    private static final String EXECUTABLE_ATTRIBUTE = "class";

    public static Object loadSingletonExecutableExtension(String extensionPoint) {
        return ExtensionUtils.loadSingletonExecutableExtension(extensionPoint, null);
    }

    public static Object loadSingletonExecutableExtension(String extensionPoint, Object defaultExecutable) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor(extensionPoint);
        if (elements.length > 1) {
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                if (!element.getNamespaceIdentifier().contains(RSSOWL_NAMESPACE)) {
                    try {
                        return element.createExecutableExtension(EXECUTABLE_ATTRIBUTE);
                    }
                    catch (CoreException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
                ++n2;
            }
        } else if (elements.length == 1) {
            try {
                return elements[0].createExecutableExtension(EXECUTABLE_ATTRIBUTE);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        if (defaultExecutable != null) {
            return defaultExecutable;
        }
        throw new IllegalStateException("Unable to load contributions for " + extensionPoint);
    }
}

