/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.connection;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.DefaultProtocolSocketFactory;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.url.URLStreamHandlerService;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.AuthenticationRequiredException;
import org.rssowl.core.connection.ConnectionException;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.HttpConnectionInputStream;
import org.rssowl.core.connection.IAbortable;
import org.rssowl.core.connection.IConditionalGetCompatible;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.connection.IProtocolHandler;
import org.rssowl.core.connection.IProxyCredentials;
import org.rssowl.core.connection.MonitorCanceledException;
import org.rssowl.core.connection.NotModifiedException;
import org.rssowl.core.connection.ProxyAuthenticationRequiredException;
import org.rssowl.core.connection.SyncConnectionException;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.connection.Messages;
import org.rssowl.core.interpreter.EncodingException;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.core.util.Triple;
import org.rssowl.core.util.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProtocolHandler
implements IProtocolHandler {
    private static final int HTTP_ERRORS = 400;
    private static final int HTTP_STATUS_NOT_MODIFIED = 304;
    private static final int HTTP_ERROR_AUTH_REQUIRED = 401;
    private static final int HTTP_ERROR_FORBIDDEN = 403;
    private static final int HTTP_ERROR_PROXY_AUTH_REQUIRED = 407;
    private static final String HEADER_REQUEST_COOKIE = "Cookie";
    private static final String HEADER_REQUEST_ACCEPT_LANGUAGE = "Accept-Language";
    private static final String HEADER_REQUEST_USER_AGENT = "User-Agent";
    private static final String HEADER_REQUEST_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_RESPONSE_IF_NONE_MATCH = "If-None-Match";
    private static final String HEADER_RESPONSE_IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String HEADER_RESPONSE_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_RESPONSE_ERROR = "Error";
    private static final String HEADER_RESPONSE_URL = "Url";
    private static final String ERROR_BAD_AUTH = "BadAuthentication";
    private static final String ERROR_NOT_VERIFIED = "NotVerified";
    private static final String ERROR_NO_TERMS = "TermsNotAgreed";
    private static final String ERROR_CAPTCHA_REQUIRED = "CaptchaRequired";
    private static final String ERROR_UNKNOWN = "Unknown";
    private static final String ERROR_ACCOUNT_DELETED = "AccountDeleted";
    private static final String ERROR_ACCOUNT_DISABLED = "AccountDisabled";
    private static final String ERROR_SERVICE_DISABLED = "ServiceDisabled";
    private static final String ERROR_SERVICE_UNAVAILABLE = "ServiceUnavailable";
    public static final String USE_PLATFORM_ENCODING = "org.rssowl.core.internal.connection.DefaultProtocolHandler.UsePlatformEncoding";
    private static final int DEFAULT_CON_TIMEOUT = 30000;
    private static final int FEED_LABEL_CON_TIMEOUT = 10000;
    private static final int FAVICON_CON_TIMEOUT = 5000;
    private static final int MAX_DETECTED_TITLE_LENGTH = 1024;
    private static final String USER_AGENT = CoreUtils.getUserAgent();
    private static boolean fgSSLInitialized;
    private static boolean fgFeedProtocolInitialized;

    @Override
    public Triple<IFeed, IConditionalGet, URI> reload(URI link, IProgressMonitor monitor, Map<Object, Object> properties) throws CoreException {
        IModelFactory typesFactory = Owl.getModelFactory();
        IFeed feed = typesFactory.createFeed(null, link);
        if (properties == null) {
            properties = new HashMap<Object, Object>();
        }
        properties.put("PROGRESS_MONITOR", monitor);
        InputStream inS = this.openStream(link, properties);
        IConditionalGet conditionalGet = this.getConditionalGet(link, inS);
        if (monitor.isCanceled()) {
            this.closeStream(inS, true);
            return null;
        }
        try {
            Owl.getInterpreter().interpret(inS, feed, null);
        }
        catch (EncodingException encodingException) {
            if (monitor.isCanceled()) {
                this.closeStream(inS, true);
                return null;
            }
            inS = this.openStream(link, properties);
            conditionalGet = this.getConditionalGet(link, inS);
            if (monitor.isCanceled()) {
                this.closeStream(inS, true);
                return null;
            }
            Owl.getInterpreter().interpret(inS, feed, Collections.singletonMap(USE_PLATFORM_ENCODING, Boolean.TRUE));
        }
        if (inS instanceof HttpConnectionInputStream) {
            return Triple.create(feed, conditionalGet, ((HttpConnectionInputStream)inS).getLink());
        }
        return Triple.create(feed, conditionalGet, link);
    }

    protected IConditionalGet getConditionalGet(URI link, InputStream inS) {
        IModelFactory typesFactory = Owl.getModelFactory();
        if (inS instanceof IConditionalGetCompatible) {
            String ifModifiedSince = ((IConditionalGetCompatible)((Object)inS)).getIfModifiedSince();
            String ifNoneMatch = ((IConditionalGetCompatible)((Object)inS)).getIfNoneMatch();
            if (ifModifiedSince != null || ifNoneMatch != null) {
                return typesFactory.createConditionalGet(ifModifiedSince, link, ifNoneMatch);
            }
        }
        return null;
    }

    protected void closeStream(InputStream inS, boolean abort) {
        try {
            if (abort && inS instanceof IAbortable) {
                ((IAbortable)((Object)inS)).abort();
            } else if (inS != null) {
                inS.close();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public byte[] getFeedIcon(URI link, IProgressMonitor monitor) {
        byte[] favicon = this.loadFavicon(link, false, false, monitor);
        if (favicon == null || favicon.length == 0) {
            try {
                URI faviconUri;
                URI topLevelUri = URIUtils.toTopLevel(link);
                if (topLevelUri != null && (faviconUri = this.getFavicon(topLevelUri, monitor)) != null && faviconUri.isAbsolute()) {
                    return this.loadFavicon(faviconUri, true, false, monitor);
                }
            }
            catch (ConnectionException connectionException) {
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (Throwable t) {
                Activator.getDefault().logError(t.getMessage(), t);
            }
        }
        return favicon;
    }

    /*
     * Exception decompiling
     */
    byte[] loadFavicon(URI link, boolean isFavicon, boolean rewriteHost, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI getFavicon(URI link, IProgressMonitor monitor) throws ConnectionException {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put("PROGRESS_MONITOR", monitor);
        properties.put("CON_TIMEOUT", 5000);
        InputStream inS = this.openStream(link, properties);
        BufferedInputStream bufIns = new BufferedInputStream(inS);
        BufferedReader reader = new BufferedReader(new InputStreamReader(bufIns));
        try {
            if (inS instanceof HttpConnectionInputStream) {
                URI uRI = CoreUtils.findFavicon(reader, ((HttpConnectionInputStream)inS).getLink(), monitor);
                return uRI;
            }
            URI uRI = CoreUtils.findFavicon(reader, link, monitor);
            return uRI;
        }
        finally {
            this.closeStream(inS, true);
        }
    }

    @Override
    public URLStreamHandlerService getURLStreamHandler() {
        return null;
    }

    @Override
    public InputStream openStream(URI link, IProgressMonitor monitor, Map<Object, Object> properties) throws ConnectionException {
        if (monitor != null) {
            if (properties == null) {
                properties = new HashMap<Object, Object>();
            }
            properties.put("PROGRESS_MONITOR", monitor);
        }
        return this.openStream(link, properties);
    }

    protected InputStream openStream(URI link, Map<Object, Object> properties) throws ConnectionException {
        try {
            return this.internalOpenStream(link, link, null, properties);
        }
        catch (AuthenticationRequiredException e) {
            if (e.getRealm() == null) {
                throw e;
            }
            URI normalizedUri = URIUtils.normalizeUri(link, true);
            ICredentials authCredentials = Owl.getConnectionService().getAuthCredentials(normalizedUri, e.getRealm());
            if (authCredentials != null) {
                ICredentialsProvider credProvider = Owl.getConnectionService().getCredentialsProvider(link);
                if (credProvider.getPersistedAuthCredentials(normalizedUri, e.getRealm()) != null) {
                    credProvider.setAuthCredentials(authCredentials, link, null);
                } else {
                    credProvider.setInMemoryAuthCredentials(authCredentials, link, null);
                }
                try {
                    return this.internalOpenStream(link, normalizedUri, e.getRealm(), properties);
                }
                catch (AuthenticationRequiredException ex) {
                    Owl.getConnectionService().getCredentialsProvider(normalizedUri).deleteAuthCredentials(normalizedUri, e.getRealm());
                    throw ex;
                }
            }
            throw e;
        }
    }

    private InputStream internalOpenStream(URI link, URI authLink, String authRealm, Map<Object, Object> properties) throws ConnectionException {
        if ("file".equals(link.getScheme())) {
            return this.loadFileProtocol(link);
        }
        if ("https".equals(link.getScheme())) {
            this.initSSLProtocol();
        }
        if ("feed".equals(link.getScheme())) {
            this.initFeedProtocol();
        }
        HttpClient client = this.initClient(properties);
        HttpMethodBase method = null;
        InputStream inS = null;
        try {
            method = this.initConnection(link, properties);
            this.setupProxy(link, client);
            this.setupAuthentication(authLink, authRealm, client, method);
            inS = this.openConnection(client, method);
            if (inS != null) {
                inS = this.pipeStream(inS, method);
            }
        }
        catch (IOException e) {
            this.abortAndRelease(method);
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
        int statusCode = method.getStatusCode();
        if (statusCode == 401) {
            AuthState hostAuthState = method.getHostAuthState();
            String realm = hostAuthState != null ? hostAuthState.getRealm() : null;
            this.abortAndRelease(method);
            throw new AuthenticationRequiredException(realm, Activator.getDefault().createErrorStatus(Messages.DefaultProtocolHandler_ERROR_AUTHENTICATION_REQUIRED, null));
        }
        if (this.isSyncAuthenticationIssue(method, authLink)) {
            this.abortAndRelease(method);
            throw new AuthenticationRequiredException(null, Activator.getDefault().createErrorStatus(Messages.DefaultProtocolHandler_GR_ERROR_BAD_AUTH, null));
        }
        if (statusCode == 403 && method.getResponseHeader(HEADER_RESPONSE_ERROR) != null) {
            this.handleForbidden(method);
        } else {
            if (statusCode == 407) {
                this.abortAndRelease(method);
                throw new ProxyAuthenticationRequiredException(Activator.getDefault().createErrorStatus(Messages.DefaultProtocolHandler_ERROR_PROXY_AUTHENTICATION_REQUIRED, null));
            }
            if (statusCode >= 400) {
                String error = this.getError(statusCode);
                this.abortAndRelease(method);
                if (error != null) {
                    throw new ConnectionException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.DefaultProtocolHandler_ERROR_HTTP_STATUS_MSG, (Object)String.valueOf(statusCode), (Object)error), null));
                }
                throw new ConnectionException(Activator.getDefault().createErrorStatus(NLS.bind((String)Messages.DefaultProtocolHandler_ERROR_HTTP_STATUS, (Object)String.valueOf(statusCode)), null));
            }
            if (statusCode == 304) {
                this.abortAndRelease(method);
                throw new NotModifiedException(Activator.getDefault().createInfoStatus(Messages.DefaultProtocolHandler_INFO_NOT_MODIFIED_SINCE, null));
            }
        }
        if (inS == null) {
            this.abortAndRelease(method);
            throw new ConnectionException(Activator.getDefault().createErrorStatus(Messages.DefaultProtocolHandler_ERROR_STREAM_UNAVAILABLE, null));
        }
        IProgressMonitor monitor = null;
        if (properties != null && properties.containsKey("PROGRESS_MONITOR")) {
            monitor = (IProgressMonitor)properties.get("PROGRESS_MONITOR");
        }
        return new HttpConnectionInputStream(link, method, monitor, inS);
    }

    private void abortAndRelease(HttpMethodBase method) {
        if (method != null) {
            method.abort();
            method.releaseConnection();
        }
    }

    private boolean isSyncAuthenticationIssue(HttpMethodBase method, URI link) {
        Header errorHeader;
        return method.getStatusCode() == 403 && SyncUtils.fromGoogle(link.toString()) && ((errorHeader = method.getResponseHeader(HEADER_RESPONSE_ERROR)) == null || ERROR_BAD_AUTH.equals(errorHeader.getValue()));
    }

    protected void handleForbidden(HttpMethodBase method) throws ConnectionException {
        String errorMsg = null;
        String errorUrl = null;
        Header errorHeader = method.getResponseHeader(HEADER_RESPONSE_ERROR);
        if (errorHeader != null && StringUtils.isSet(errorHeader.getValue())) {
            Header urlHeader;
            String errorCode = errorHeader.getValue();
            if (ERROR_BAD_AUTH.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_BAD_AUTH;
            } else if (ERROR_NOT_VERIFIED.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_NOT_VERIFIED;
            } else if (ERROR_NO_TERMS.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_NO_TERMS;
            } else if (ERROR_UNKNOWN.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_UNKNOWN;
            } else if (ERROR_ACCOUNT_DELETED.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_ACCOUNT_DELETED;
            } else if (ERROR_ACCOUNT_DISABLED.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_ACCOUNT_DISABLED;
            } else if (ERROR_SERVICE_DISABLED.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_SERVICE_DISABLED;
            } else if (ERROR_SERVICE_UNAVAILABLE.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_SERVICE_UNAVAILABLE;
            } else if (ERROR_CAPTCHA_REQUIRED.equals(errorCode)) {
                errorMsg = Messages.DefaultProtocolHandler_GR_ERROR_CAPTCHA_REQUIRED;
                errorUrl = "https://www.google.com/accounts/DisplayUnlockCaptcha";
            }
            if (errorUrl == null && (urlHeader = method.getResponseHeader(HEADER_RESPONSE_URL)) != null && StringUtils.isSet(urlHeader.getValue())) {
                errorUrl = urlHeader.getValue();
            }
        }
        if (errorMsg == null) {
            errorMsg = Messages.DefaultProtocolHandler_ERROR_FORBIDDEN;
        }
        this.abortAndRelease(method);
        if (errorUrl != null) {
            throw new SyncConnectionException(errorUrl, Activator.getDefault().createErrorStatus(errorMsg, null));
        }
        throw new ConnectionException(Activator.getDefault().createErrorStatus(errorMsg, null));
    }

    private String getError(int errorCode) {
        switch (errorCode) {
            case 400: {
                return "Bad Request";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 408: {
                return "Request Timeout";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
        }
        return null;
    }

    private InputStream loadFileProtocol(URI link) throws ConnectionException {
        try {
            File file = new File(link);
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new ConnectionException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }

    private void setupAuthentication(URI link, String realm, HttpClient client, HttpMethodBase method) throws URIException, CredentialsException {
        ICredentials authCredentials = Owl.getConnectionService().getAuthCredentials(link, realm);
        if (authCredentials != null) {
            client.getParams().setAuthenticationPreemptive(true);
            String host = method.getURI().getHost();
            NTCredentials userPwCreds = new NTCredentials(authCredentials.getUsername(), authCredentials.getPassword(), host, authCredentials.getDomain() != null ? authCredentials.getDomain() : "");
            client.getState().setCredentials(AuthScope.ANY, (Credentials)userPwCreds);
            method.setDoAuthentication(true);
        }
    }

    private void setupProxy(URI link, HttpClient client) throws CredentialsException {
        IProxyCredentials creds = Owl.getConnectionService().getProxyCredentials(link);
        if (creds != null) {
            client.getParams().setAuthenticationPreemptive(true);
            client.getHostConfiguration().setProxy(creds.getHost(), creds.getPort());
            if (creds.getUsername() != null || creds.getPassword() != null) {
                String user = StringUtils.isSet(creds.getUsername()) ? creds.getUsername() : "";
                String pw = StringUtils.isSet(creds.getPassword()) ? creds.getPassword() : "";
                AuthScope proxyAuthScope = new AuthScope(creds.getHost(), creds.getPort());
                if (creds.getDomain() != null) {
                    client.getState().setProxyCredentials(proxyAuthScope, (Credentials)new NTCredentials(user, pw, creds.getHost(), creds.getDomain()));
                } else {
                    client.getState().setProxyCredentials(proxyAuthScope, (Credentials)new UsernamePasswordCredentials(user, pw));
                }
            }
        }
    }

    private synchronized void initSSLProtocol() {
        if (fgSSLInitialized) {
            return;
        }
        Protocol easyHttpsProtocol = new Protocol("https", (ProtocolSocketFactory)Owl.getConnectionService().getSecureProtocolSocketFactory(), 443);
        Protocol.registerProtocol((String)"https", (Protocol)easyHttpsProtocol);
        fgSSLInitialized = true;
    }

    private synchronized void initFeedProtocol() {
        if (fgFeedProtocolInitialized) {
            return;
        }
        Protocol feed = new Protocol("feed", (ProtocolSocketFactory)new DefaultProtocolSocketFactory(), 80);
        Protocol.registerProtocol((String)"feed", (Protocol)feed);
        fgFeedProtocolInitialized = true;
    }

    private void setHeaders(Map<Object, Object> properties, HttpMethodBase method) {
        method.setRequestHeader(HEADER_REQUEST_ACCEPT_ENCODING, "gzip");
        method.setRequestHeader(HEADER_REQUEST_USER_AGENT, USER_AGENT);
        if (properties != null) {
            String ifModifiedSince = (String)properties.get("IF_MODIFIED_SINCE");
            String ifNoneMatch = (String)properties.get("IF_NONE_MATCH");
            if (ifModifiedSince != null) {
                method.setRequestHeader(HEADER_RESPONSE_IF_MODIFIED_SINCE, ifModifiedSince);
            }
            if (ifNoneMatch != null) {
                method.setRequestHeader(HEADER_RESPONSE_IF_NONE_MATCH, ifNoneMatch);
            }
        }
        if (properties != null && properties.containsKey("ACCEPT_LANGUAGE")) {
            method.setRequestHeader(HEADER_REQUEST_ACCEPT_LANGUAGE, (String)properties.get("ACCEPT_LANGUAGE"));
        }
        if (properties != null && properties.containsKey("COOKIE")) {
            method.setRequestHeader(HEADER_REQUEST_COOKIE, (String)properties.get("COOKIE"));
        }
        if (properties != null && properties.containsKey("HEADERS")) {
            Map headers = (Map)properties.get("HEADERS");
            Set entries = headers.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                method.setRequestHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private HttpClient initClient(Map<Object, Object> properties) {
        int conTimeout = 30000;
        if (properties != null && properties.containsKey("CON_TIMEOUT")) {
            conTimeout = (Integer)properties.get("CON_TIMEOUT");
        }
        HttpClient client = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager(true));
        client.getHttpConnectionManager().getParams().setSoTimeout(conTimeout);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(conTimeout);
        return client;
    }

    private HttpMethodBase initConnection(URI link, Map<Object, Object> properties) throws IOException {
        Object method = null;
        try {
            method = properties != null && properties.containsKey("POST") ? new PostMethod(link.toString()) : new GetMethod(link.toString());
        }
        catch (RuntimeException e) {
            throw new IOException(e.getMessage());
        }
        if (method instanceof GetMethod) {
            method.getParams().setCookiePolicy("ignoreCookies");
        }
        this.setHeaders(properties, (HttpMethodBase)method);
        if (method instanceof PostMethod && properties != null && properties.containsKey("PARAMETERS")) {
            Map parameters = (Map)properties.get("PARAMETERS");
            Set entries = parameters.entrySet();
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                String[] parameterValues;
                Map.Entry obj;
                Map.Entry entry = obj = iterator.next();
                String key = (String)entry.getKey();
                if (entry.getValue() instanceof String) {
                    ((PostMethod)method).addParameter(key, (String)entry.getValue());
                    continue;
                }
                if (!(entry.getValue() instanceof String[])) continue;
                String[] stringArray = parameterValues = (String[])entry.getValue();
                int n = parameterValues.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    ((PostMethod)method).addParameter(key, value);
                    ++n2;
                }
            }
        }
        if (method instanceof GetMethod) {
            method.setFollowRedirects(true);
        }
        return method;
    }

    private InputStream openConnection(HttpClient client, HttpMethodBase method) throws HttpException, IOException {
        client.executeMethod((HttpMethod)method);
        return method.getResponseBodyAsStream();
    }

    private InputStream pipeStream(InputStream inputStream, HttpMethodBase method) throws IOException {
        Assert.isNotNull((Object)inputStream);
        String contentEncoding = method.getResponseHeader(HEADER_RESPONSE_CONTENT_ENCODING) != null ? method.getResponseHeader(HEADER_RESPONSE_CONTENT_ENCODING).getValue() : null;
        boolean isGzipStream = false;
        if (!(contentEncoding != null && contentEncoding.equals("gzip") || inputStream.markSupported())) {
            return inputStream;
        }
        if (contentEncoding != null && contentEncoding.equals("gzip")) {
            isGzipStream = true;
        } else if (inputStream.markSupported()) {
            inputStream.mark(2);
            int id1 = inputStream.read();
            int id2 = inputStream.read();
            inputStream.reset();
            if (id1 == 31 && id2 == 139) {
                isGzipStream = true;
            }
        }
        if (isGzipStream) {
            try {
                return new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                return inputStream;
            }
        }
        return inputStream;
    }

    @Override
    public String getLabel(URI link, IProgressMonitor monitor) throws ConnectionException {
        InputStream inS;
        String title;
        block8: {
            title = "";
            HashMap<Object, Object> properties = new HashMap<Object, Object>();
            properties.put("PROGRESS_MONITOR", monitor);
            properties.put("CON_TIMEOUT", 10000);
            inS = this.openStream(link, properties);
            if (!monitor.isCanceled()) break block8;
            this.closeStream(inS, true);
            return null;
        }
        try {
            try {
                BufferedInputStream bufIns = new BufferedInputStream(inS);
                bufIns.mark(8192);
                String encoding = this.getEncodingFromXML(new InputStreamReader(bufIns), monitor);
                if ("utf-8".equalsIgnoreCase(encoding)) {
                    encoding = "UTF-8";
                }
                bufIns.reset();
                title = StringUtils.isSet(encoding) && Charset.isSupported(encoding) ? this.getTitleFromFeed(new BufferedReader(new InputStreamReader((InputStream)bufIns, encoding)), monitor) : this.getTitleFromFeed(new BufferedReader(new InputStreamReader(bufIns)), monitor);
                title = title.replaceAll("<title[^>]*>", "");
                title = title.replaceAll("</title>", "");
                title = title.replaceAll(Pattern.quote("<![CDATA["), "");
                title = title.replaceAll(Pattern.quote("]]>"), "");
            }
            catch (IOException e) {
                if (!(e instanceof MonitorCanceledException)) {
                    Activator.safeLogError(e.getMessage(), e);
                }
                this.closeStream(inS, true);
            }
        }
        catch (Throwable throwable) {
            this.closeStream(inS, true);
            throw throwable;
        }
        this.closeStream(inS, true);
        String result = StringUtils.stripTags(title.trim(), true);
        if (result.length() > 1024) {
            result = result.substring(0, 1024);
        }
        return result;
    }

    private String getEncodingFromXML(InputStreamReader inputReader, IProgressMonitor monitor) throws IOException {
        String regEx;
        Pattern pattern;
        Matcher match;
        String firstLine;
        int c;
        String encoding = null;
        StringBuilder strBuf = new StringBuilder();
        while (!monitor.isCanceled() && (c = inputReader.read()) != -1) {
            char character = (char)c;
            if (character != '>' && character != '\n' && character != '\r') {
                strBuf.append(character);
                continue;
            }
            if (character != '>') break;
            strBuf.append(character);
            break;
        }
        if ((firstLine = strBuf.toString()).indexOf("encoding") >= 0 && (match = (pattern = Pattern.compile(regEx = "<\\?.*encoding=[\"']([^\\s]*)[\"'].*\\?>")).matcher(firstLine)).find()) {
            return match.group(1);
        }
        return encoding;
    }

    private String getTitleFromFeed(BufferedReader inputReader, IProgressMonitor monitor) throws IOException {
        boolean titleFound;
        String title;
        block4: {
            String firstLine;
            title = "";
            titleFound = false;
            do {
                if (monitor.isCanceled()) {
                    return null;
                }
                firstLine = inputReader.readLine();
                if (firstLine == null) break block4;
            } while (firstLine.indexOf("<title") < 0 || firstLine.indexOf("</title>") < 0);
            title = firstLine.trim();
            titleFound = true;
        }
        if (!titleFound) {
            return title;
        }
        String regEx = "<title[^>]*>[^<]*</title>";
        Pattern pattern = Pattern.compile(regEx);
        Matcher match = pattern.matcher(title);
        if (match.find()) {
            title = match.group();
        }
        return title;
    }

    @Override
    public URI getFeed(URI website, IProgressMonitor monitor) throws ConnectionException {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        properties.put("PROGRESS_MONITOR", monitor);
        properties.put("CON_TIMEOUT", 10000);
        InputStream inS = this.openStream(website, properties);
        BufferedInputStream bufIns = new BufferedInputStream(inS);
        BufferedReader reader = new BufferedReader(new InputStreamReader(bufIns));
        try {
            if (inS instanceof HttpConnectionInputStream) {
                String contentType = ((HttpConnectionInputStream)inS).getContentType();
                if (contentType != null) {
                    String[] stringArray = CoreUtils.FEED_MIME_TYPES;
                    int n = CoreUtils.FEED_MIME_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String feedContentType = stringArray[n2];
                        if (contentType.toLowerCase().contains(feedContentType)) {
                            URI uRI = website;
                            return uRI;
                        }
                        ++n2;
                    }
                }
                URI uRI = CoreUtils.findFeed(reader, ((HttpConnectionInputStream)inS).getLink(), monitor);
                return uRI;
            }
            URI uRI = CoreUtils.findFeed(reader, website, monitor);
            return uRI;
        }
        finally {
            this.closeStream(inS, true);
        }
    }
}

