/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.self;

import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectConstructor;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.ReflectMethod;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.self.ClassInfo;
import com.db4o.reflect.self.FieldInfo;
import com.db4o.reflect.self.SelfConstructor;
import com.db4o.reflect.self.SelfField;
import com.db4o.reflect.self.SelfReflectionRegistry;

public class SelfClass
implements ReflectClass {
    private static final SelfField[] EMPTY_FIELDS = new SelfField[0];
    private boolean _isAbstract;
    private SelfField[] _fields;
    private Reflector _parentReflector;
    private SelfReflectionRegistry _registry;
    private Class _class;
    private Class _superClass;

    public SelfClass(Reflector reflector, SelfReflectionRegistry selfReflectionRegistry, Class clazz) {
        this._parentReflector = reflector;
        this._registry = selfReflectionRegistry;
        this._class = clazz;
    }

    public Class getJavaClass() {
        return this._class;
    }

    public Reflector reflector() {
        return this._parentReflector;
    }

    public ReflectClass getComponentType() {
        if (!this.isArray()) {
            return null;
        }
        return this._parentReflector.forClass(this._registry.componentType(this._class));
    }

    public ReflectConstructor[] getDeclaredConstructors() {
        if (this.isInterface()) {
            return new SelfConstructor[0];
        }
        return new SelfConstructor[]{new SelfConstructor(this._class)};
    }

    public ReflectField[] getDeclaredFields() {
        this.ensureClassInfoLoaded();
        return this._fields;
    }

    private void ensureClassInfoLoaded() {
        if (this._fields == null) {
            ClassInfo classInfo = this._registry.infoFor(this._class);
            if (classInfo == null) {
                this._fields = EMPTY_FIELDS;
                return;
            }
            this._superClass = classInfo.superClass();
            this._isAbstract = classInfo.isAbstract();
            FieldInfo[] fieldInfoArray = classInfo.fieldInfo();
            if (fieldInfoArray == null) {
                this._fields = EMPTY_FIELDS;
                return;
            }
            this._fields = new SelfField[fieldInfoArray.length];
            for (int i = 0; i < fieldInfoArray.length; ++i) {
                this._fields[i] = this.selfFieldFor(fieldInfoArray[i]);
            }
        }
    }

    public ReflectField getDeclaredField(String string) {
        this.ensureClassInfoLoaded();
        for (int i = 0; i < this._fields.length; ++i) {
            if (!this._fields[i].getName().equals(string)) continue;
            return this._fields[i];
        }
        return null;
    }

    private SelfField selfFieldFor(FieldInfo fieldInfo) {
        return new SelfField(fieldInfo.name(), this._parentReflector.forClass(fieldInfo.type()), this, this._registry);
    }

    public ReflectClass getDelegate() {
        return this;
    }

    public ReflectMethod getMethod(String string, ReflectClass[] reflectClassArray) {
        return null;
    }

    public String getName() {
        return this._class.getName();
    }

    public ReflectClass getSuperclass() {
        this.ensureClassInfoLoaded();
        if (this._superClass == null) {
            return null;
        }
        return this._parentReflector.forClass(this._superClass);
    }

    public boolean isAbstract() {
        this.ensureClassInfoLoaded();
        return this._isAbstract || this.isInterface();
    }

    public boolean isArray() {
        return this._class.isArray();
    }

    public boolean isAssignableFrom(ReflectClass reflectClass) {
        if (!(reflectClass instanceof SelfClass)) {
            return false;
        }
        return this._class.isAssignableFrom(((SelfClass)reflectClass).getJavaClass());
    }

    public boolean isCollection() {
        return this._parentReflector.isCollection(this);
    }

    public boolean isInstance(Object object) {
        return this._class.isInstance(object);
    }

    public boolean isInterface() {
        return this._class.isInterface();
    }

    public boolean isPrimitive() {
        return this._registry.isPrimitive(this._class);
    }

    public boolean isSecondClass() {
        return this.isPrimitive();
    }

    public Object newInstance() {
        try {
            return this._class.newInstance();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public boolean skipConstructor(boolean bl) {
        return false;
    }

    public void useConstructor(ReflectConstructor reflectConstructor, Object[] objectArray) {
    }

    public Object[] toArray(Object object) {
        return null;
    }
}

