/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.ix;

import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.freespace.FreespaceVisitor;
import com.db4o.internal.ix.Indexable4;
import com.db4o.internal.ix.IxPath;
import com.db4o.internal.ix.IxTree;

public class IxTraverser {
    private IxPath i_appendHead;
    private IxPath i_appendTail;
    private IxPath i_greatHead;
    private IxPath i_greatTail;
    Indexable4 i_handler;
    private IxPath i_smallHead;
    private IxPath i_smallTail;
    boolean[] i_take;

    private void add(Visitor4 visitor4, IxPath ixPath, IxPath ixPath2, IxPath ixPath3) {
        this.addPathTree(visitor4, ixPath);
        if (ixPath2 != null && ixPath3 != null && ixPath2.carriesTheSame(ixPath3)) {
            this.add(visitor4, ixPath2, ixPath2.i_next, ixPath3.i_next);
            return;
        }
        this.addGreater(visitor4, ixPath3);
        this.addSmaller(visitor4, ixPath2);
    }

    private void addAll(Visitor4 visitor4, Tree tree) {
        if (tree != null) {
            ((IxTree)tree).visit(visitor4, null);
            this.addAll(visitor4, tree._preceding);
            this.addAll(visitor4, tree._subsequent);
        }
    }

    private void addGreater(Visitor4 visitor4, IxPath ixPath) {
        if (ixPath != null) {
            if (ixPath.i_next == null) {
                this.addSubsequent(visitor4, ixPath);
            } else {
                if (ixPath.i_next.i_tree == ixPath.i_tree._preceding) {
                    this.addSubsequent(visitor4, ixPath);
                } else {
                    this.addPathTree(visitor4, ixPath);
                }
                this.addGreater(visitor4, ixPath.i_next);
            }
        }
    }

    private void addPathTree(Visitor4 visitor4, IxPath ixPath) {
        if (ixPath != null) {
            ixPath.add(visitor4);
        }
    }

    private void addPreceding(Visitor4 visitor4, IxPath ixPath) {
        this.addPathTree(visitor4, ixPath);
        this.addAll(visitor4, ixPath.i_tree._preceding);
    }

    private void addSmaller(Visitor4 visitor4, IxPath ixPath) {
        if (ixPath != null) {
            if (ixPath.i_next == null) {
                this.addPreceding(visitor4, ixPath);
            } else {
                if (ixPath.i_next.i_tree == ixPath.i_tree._subsequent) {
                    this.addPreceding(visitor4, ixPath);
                } else {
                    this.addPathTree(visitor4, ixPath);
                }
                this.addSmaller(visitor4, ixPath.i_next);
            }
        }
    }

    private void addSubsequent(Visitor4 visitor4, IxPath ixPath) {
        this.addPathTree(visitor4, ixPath);
        this.addAll(visitor4, ixPath.i_tree._subsequent);
    }

    private int countGreater(IxPath ixPath, int n) {
        if (ixPath.i_next == null) {
            return n + this.countSubsequent(ixPath);
        }
        n = ixPath.i_next.i_tree == ixPath.i_tree._preceding ? (n += this.countSubsequent(ixPath)) : (n += ixPath.countMatching());
        return this.countGreater(ixPath.i_next, n);
    }

    private int countPreceding(IxPath ixPath) {
        return Tree.size(ixPath.i_tree._preceding) + ixPath.countMatching();
    }

    private int countSmaller(IxPath ixPath, int n) {
        if (ixPath.i_next == null) {
            return n + this.countPreceding(ixPath);
        }
        n = ixPath.i_next.i_tree == ixPath.i_tree._subsequent ? (n += this.countPreceding(ixPath)) : (n += ixPath.countMatching());
        return this.countSmaller(ixPath.i_next, n);
    }

    private int countSpan(IxPath ixPath, IxPath ixPath2, IxPath ixPath3) {
        if (ixPath2 == null) {
            if (ixPath3 == null) {
                return ixPath.countMatching();
            }
            return this.countGreater(ixPath3, ixPath.countMatching());
        }
        if (ixPath3 == null) {
            return this.countSmaller(ixPath2, ixPath.countMatching());
        }
        if (ixPath2.carriesTheSame(ixPath3)) {
            return this.countSpan(ixPath2, ixPath2.i_next, ixPath3.i_next);
        }
        return ixPath.countMatching() + this.countGreater(ixPath3, 0) + this.countSmaller(ixPath2, 0);
    }

    private int countSubsequent(IxPath ixPath) {
        return Tree.size(ixPath.i_tree._subsequent) + ixPath.countMatching();
    }

    private void delayedAppend(IxTree ixTree, int n, int[] nArray) {
        this.i_appendTail = this.i_appendHead == null ? (this.i_appendHead = new IxPath(this, null, ixTree, n, nArray)) : this.i_appendTail.append(ixTree, n, nArray);
    }

    private void findBoth() {
        if (this.i_greatTail.i_comparisonResult == 0) {
            this.findSmallestEqualFromEqual((IxTree)this.i_greatTail.i_tree._preceding);
            this.resetDelayedAppend();
            this.findGreatestEqualFromEqual((IxTree)this.i_greatTail.i_tree._subsequent);
        } else if (this.i_greatTail.i_comparisonResult < 0) {
            this.findBoth1((IxTree)this.i_greatTail.i_tree._subsequent);
        } else {
            this.findBoth1((IxTree)this.i_greatTail.i_tree._preceding);
        }
    }

    private void findBoth1(IxTree ixTree) {
        if (ixTree != null) {
            int n = ixTree.compare(null);
            int[] nArray = ixTree.lowerAndUpperMatch();
            this.i_greatTail = this.i_greatTail.append(ixTree, n, nArray);
            this.i_smallTail = this.i_smallTail.append(ixTree, n, nArray);
            this.findBoth();
        }
    }

    private void findNullPath1(IxPath[] ixPathArray) {
        if (ixPathArray[1].i_comparisonResult == 0) {
            this.findGreatestNullFromNull(ixPathArray, (IxTree)ixPathArray[1].i_tree._subsequent);
        } else if (ixPathArray[1].i_comparisonResult < 0) {
            this.findNullPath2(ixPathArray, (IxTree)ixPathArray[1].i_tree._subsequent);
        } else {
            this.findNullPath2(ixPathArray, (IxTree)ixPathArray[1].i_tree._preceding);
        }
    }

    private void findNullPath2(IxPath[] ixPathArray, IxTree ixTree) {
        if (ixTree != null) {
            int n = ixTree.compare(null);
            ixPathArray[1] = ixPathArray[1].append(ixTree, n, ixTree.lowerAndUpperMatch());
            this.findNullPath1(ixPathArray);
        }
    }

    private void findGreatestNullFromNull(IxPath[] ixPathArray, IxTree ixTree) {
        if (ixTree != null) {
            int n = ixTree.compare(null);
            this.delayedAppend(ixTree, n, ixTree.lowerAndUpperMatch());
            if (n == 0) {
                ixPathArray[1] = ixPathArray[1].append(this.i_appendHead, this.i_appendTail);
                this.resetDelayedAppend();
            }
            if (n > 0) {
                this.findGreatestNullFromNull(ixPathArray, (IxTree)ixTree._preceding);
            } else {
                this.findGreatestNullFromNull(ixPathArray, (IxTree)ixTree._subsequent);
            }
        }
    }

    public int findBounds(Object object, IxTree ixTree) {
        if (ixTree != null) {
            IxPath ixPath;
            this.i_handler = ixTree.handler();
            this.i_handler.prepareComparison(object);
            int n = ixTree.compare(null);
            this.i_greatTail = this.i_greatHead = new IxPath(this, null, ixTree, n, ixTree.lowerAndUpperMatch());
            this.i_smallTail = this.i_smallHead = (IxPath)this.i_greatHead.shallowClone();
            this.findBoth();
            int n2 = 0;
            if (this.i_take[2]) {
                n2 += this.countSpan(this.i_greatHead, this.i_greatHead.i_next, this.i_smallHead.i_next);
            }
            if (this.i_take[1]) {
                ixPath = this.i_smallHead;
                while (ixPath != null) {
                    n2 += ixPath.countPreceding(this.i_take[0]);
                    ixPath = ixPath.i_next;
                }
            }
            if (this.i_take[3]) {
                ixPath = this.i_greatHead;
                while (ixPath != null) {
                    n2 += ixPath.countSubsequent();
                    ixPath = ixPath.i_next;
                }
            }
            return n2;
        }
        return 0;
    }

    public int findBoundsExactMatch(Object object, IxTree ixTree) {
        this.i_take = new boolean[]{false, false, false, false};
        this.i_take[2] = true;
        return this.findBounds(object, ixTree);
    }

    private void findGreatestEqualFromEqual(IxTree ixTree) {
        if (ixTree != null) {
            int n = ixTree.compare(null);
            this.delayedAppend(ixTree, n, ixTree.lowerAndUpperMatch());
            if (n == 0) {
                this.i_greatTail = this.i_greatTail.append(this.i_appendHead, this.i_appendTail);
                this.resetDelayedAppend();
            }
            if (n > 0) {
                this.findGreatestEqualFromEqual((IxTree)ixTree._preceding);
            } else {
                this.findGreatestEqualFromEqual((IxTree)ixTree._subsequent);
            }
        }
    }

    private void findSmallestEqualFromEqual(IxTree ixTree) {
        if (ixTree != null) {
            int n = ixTree.compare(null);
            this.delayedAppend(ixTree, n, ixTree.lowerAndUpperMatch());
            if (n == 0) {
                this.i_smallTail = this.i_smallTail.append(this.i_appendHead, this.i_appendTail);
                this.resetDelayedAppend();
            }
            if (n < 0) {
                this.findSmallestEqualFromEqual((IxTree)ixTree._subsequent);
            } else {
                this.findSmallestEqualFromEqual((IxTree)ixTree._preceding);
            }
        }
    }

    private void resetDelayedAppend() {
        this.i_appendHead = null;
        this.i_appendTail = null;
    }

    public void visitAll(Visitor4 visitor4) {
        IxPath ixPath;
        if (this.i_take[2] && this.i_greatHead != null) {
            this.add(visitor4, this.i_greatHead, this.i_greatHead.i_next, this.i_smallHead.i_next);
        }
        if (this.i_take[1]) {
            ixPath = this.i_smallHead;
            while (ixPath != null) {
                ixPath.addPrecedingToCandidatesTree(visitor4);
                ixPath = ixPath.i_next;
            }
        }
        if (this.i_take[3]) {
            ixPath = this.i_greatHead;
            while (ixPath != null) {
                ixPath.addSubsequentToCandidatesTree(visitor4);
                ixPath = ixPath.i_next;
            }
        }
    }

    public void visitPreceding(FreespaceVisitor freespaceVisitor) {
        if (this.i_smallHead != null) {
            this.i_smallHead.visitPreceding(freespaceVisitor);
        }
    }

    public void visitSubsequent(FreespaceVisitor freespaceVisitor) {
        if (this.i_greatHead != null) {
            this.i_greatHead.visitSubsequent(freespaceVisitor);
        }
    }

    public void visitMatch(FreespaceVisitor freespaceVisitor) {
        if (this.i_smallHead != null) {
            this.i_smallHead.visitMatch(freespaceVisitor);
        }
    }
}

