/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.No4;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreeCancelledRemoval;
import com.db4o.internal.btree.BTreePatch;

public abstract class BTreeUpdate
extends BTreePatch {
    protected BTreeUpdate _next;

    public BTreeUpdate(Transaction transaction, Object object) {
        super(transaction, object);
    }

    protected boolean hasNext() {
        return this._next != null;
    }

    public BTreePatch forTransaction(Transaction transaction) {
        if (this._transaction == transaction) {
            return this;
        }
        if (this._next == null) {
            return null;
        }
        return this._next.forTransaction(transaction);
    }

    public BTreeUpdate removeFor(Transaction transaction) {
        if (this._transaction == transaction) {
            return this._next;
        }
        if (this._next == null) {
            return this;
        }
        return this._next.removeFor(transaction);
    }

    public void append(BTreeUpdate bTreeUpdate) {
        if (this._transaction == bTreeUpdate._transaction) {
            throw new IllegalArgumentException();
        }
        if (!this.hasNext()) {
            this._next = bTreeUpdate;
        } else {
            this._next.append(bTreeUpdate);
        }
    }

    protected void applyKeyChange(Object object) {
        this._object = object;
        if (this.hasNext()) {
            this._next.applyKeyChange(object);
        }
    }

    protected abstract void committed(BTree var1);

    public Object commit(Transaction transaction, BTree bTree) {
        BTreeUpdate bTreeUpdate = (BTreeUpdate)this.forTransaction(transaction);
        if (bTreeUpdate instanceof BTreeCancelledRemoval) {
            Object object = bTreeUpdate.getCommittedObject();
            this.applyKeyChange(object);
        }
        return this.internalCommit(transaction, bTree);
    }

    protected Object internalCommit(Transaction transaction, BTree bTree) {
        if (this._transaction == transaction) {
            this.committed(bTree);
            if (this.hasNext()) {
                return this._next;
            }
            return this.getCommittedObject();
        }
        if (this.hasNext()) {
            this.setNextIfPatch(this._next.internalCommit(transaction, bTree));
        }
        return this;
    }

    private void setNextIfPatch(Object object) {
        this._next = object instanceof BTreeUpdate ? (BTreeUpdate)object : null;
    }

    protected abstract Object getCommittedObject();

    public Object rollback(Transaction transaction, BTree bTree) {
        if (this._transaction == transaction) {
            if (this.hasNext()) {
                return this._next;
            }
            return this.getObject();
        }
        if (this.hasNext()) {
            this.setNextIfPatch(this._next.rollback(transaction, bTree));
        }
        return this;
    }

    public Object key(Transaction transaction) {
        BTreePatch bTreePatch = this.forTransaction(transaction);
        if (bTreePatch == null) {
            return this.getObject();
        }
        if (bTreePatch.isRemove()) {
            return No4.INSTANCE;
        }
        return bTreePatch.getObject();
    }

    public BTreeUpdate replacePatch(BTreePatch bTreePatch, BTreeUpdate bTreeUpdate) {
        if (bTreePatch == this) {
            bTreeUpdate._next = this._next;
            return bTreeUpdate;
        }
        if (this._next == null) {
            throw new IllegalStateException();
        }
        this._next = this._next.replacePatch(bTreePatch, bTreeUpdate);
        return this;
    }
}

