/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.util.SyncItem;
import org.rssowl.ui.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncItemsManager {
    private static final String UNCOMMITTED_SYNCITEMS_FILE = "syncitems";
    private Map<String, SyncItem> fItems = new HashMap<String, SyncItem>();
    private final Object fLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() throws IOException, ClassNotFoundException {
        Object object = this.fLock;
        synchronized (object) {
            this.fItems = this.deserializeSyncItems();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        Object object = this.fLock;
        synchronized (object) {
            this.serializeSyncItems(this.fItems);
            this.fItems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUncommitted(Collection<SyncItem> items) {
        Object object = this.fLock;
        synchronized (object) {
            for (SyncItem item : items) {
                SyncItem existingItem = this.fItems.get(item.getId());
                if (existingItem != null) {
                    existingItem.merge(item);
                    continue;
                }
                this.fItems.put(item.getId(), item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, SyncItem> getUncommittedItems() {
        Object object = this.fLock;
        synchronized (object) {
            if (this.fItems.isEmpty()) {
                return Collections.emptyMap();
            }
            return new HashMap<String, SyncItem>(this.fItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUncommittedItems() {
        Object object = this.fLock;
        synchronized (object) {
            return !this.fItems.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUncommittedItems() {
        Object object = this.fLock;
        synchronized (object) {
            this.fItems.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUncommitted(Collection<SyncItem> items) {
        Object object = this.fLock;
        synchronized (object) {
            for (SyncItem item : items) {
                this.fItems.remove(item.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUncommitted(SyncItem item) {
        Object object = this.fLock;
        synchronized (object) {
            this.fItems.remove(item.getId());
        }
    }

    private void serializeSyncItems(Map<String, SyncItem> items) throws IOException {
        File store = this.getUncommittedSyncItemsFile();
        if (store == null) {
            return;
        }
        if (store.exists() && !store.delete()) {
            throw new IOException(NLS.bind((String)"Synchronization: Unable to delete file ''{0}''", (Object)store.toString()));
        }
        if (this.fItems.isEmpty()) {
            return;
        }
        ObjectOutputStream outS = null;
        try {
            outS = new ObjectOutputStream(new FileOutputStream(store));
            outS.writeObject(items);
        }
        finally {
            if (outS != null) {
                outS.close();
            }
        }
    }

    private Map<String, SyncItem> deserializeSyncItems() throws IOException, ClassNotFoundException {
        HashMap<String, SyncItem> items = new HashMap<String, SyncItem>();
        File store = this.getUncommittedSyncItemsFile();
        if (store == null || !store.exists()) {
            return items;
        }
        ObjectInputStream inS = null;
        try {
            inS = new ObjectInputStream(new FileInputStream(store));
            Object obj = inS.readObject();
            if (obj instanceof Map) {
                items.putAll((Map)obj);
            }
        }
        finally {
            if (inS != null) {
                inS.close();
            }
        }
        return items;
    }

    private File getUncommittedSyncItemsFile() throws IOException {
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        Path path = new Path(activator.getStateLocation().toOSString());
        File bundleRoot = new File(path.toOSString());
        if (!bundleRoot.exists() && !bundleRoot.mkdir()) {
            throw new IOException(NLS.bind((String)"Synchronization: Unable to create folder ''{0}''", (Object)bundleRoot.toString()));
        }
        path = path.append(UNCOMMITTED_SYNCITEMS_FILE);
        return new File(path.toOSString());
    }
}

