/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.event.BookMarkAdapter;
import org.rssowl.core.persist.event.BookMarkEvent;
import org.rssowl.core.persist.event.EntityListener;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.util.EditorUtils;
import org.rssowl.ui.internal.util.JobRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeedReloadService {
    private static final int DELAY_THRESHOLD = 300000;
    private static final int DELAY_VALUE = 30000;
    private BookMarkAdapter fBookMarkListener;
    private final Map<IBookMark, Long> fMapBookMarkToInterval = new ConcurrentHashMap<IBookMark, Long>();

    public FeedReloadService() {
        this.registerListeners();
        JobRunner.runInBackgroundThread(new Runnable(){

            public void run() {
                FeedReloadService.this.init();
            }
        });
    }

    public void stopService() {
        this.unregisterListeners();
        Job.getJobManager().cancel((Object)this);
    }

    private void init() {
        IPreferenceScope entityPreferences;
        Collection bookmarks = DynamicDAO.loadAll(IBookMark.class);
        Collection newsbins = DynamicDAO.loadAll(INewsBin.class);
        final HashSet<IBookMark> bookmarksToReloadOnStartup = new HashSet<IBookMark>();
        final ArrayList<Object> newsmarksToOpenOnStartup = new ArrayList<Object>();
        for (IBookMark bookMark : bookmarks) {
            entityPreferences = Owl.getPreferenceService().getEntityScope((IEntity)bookMark);
            if (entityPreferences.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE)) {
                long updateInterval = entityPreferences.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
                this.fMapBookMarkToInterval.put(bookMark, updateInterval);
                if (entityPreferences.getBoolean(DefaultPreferences.BM_RELOAD_ON_STARTUP)) {
                    bookmarksToReloadOnStartup.add(bookMark);
                }
            }
            if (!entityPreferences.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP)) continue;
            newsmarksToOpenOnStartup.add(bookMark);
        }
        for (INewsBin bin : newsbins) {
            entityPreferences = Owl.getPreferenceService().getEntityScope((IEntity)bin);
            if (!entityPreferences.getBoolean(DefaultPreferences.BM_OPEN_ON_STARTUP)) continue;
            newsmarksToOpenOnStartup.add(bin);
        }
        if (!bookmarksToReloadOnStartup.isEmpty()) {
            JobRunner.runInUIThread(null, new Runnable(){

                public void run() {
                    Controller.getDefault().reloadQueued(bookmarksToReloadOnStartup, null, null);
                }
            });
        }
        Set<Map.Entry<IBookMark, Long>> entries = this.fMapBookMarkToInterval.entrySet();
        for (Map.Entry<IBookMark, Long> entry : entries) {
            IBookMark bookMark = entry.getKey();
            this.scheduleUpdate(bookMark, entry.getValue());
        }
        if (!newsmarksToOpenOnStartup.isEmpty()) {
            JobRunner.runInUIThread(null, new Runnable(){

                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage iWorkbenchPage = page = window != null ? window.getActivePage() : null;
                    if (page != null) {
                        int maxOpenEditors = EditorUtils.getOpenEditorLimit();
                        int openFeedViewCount = OwlUI.getOpenFeedViewCount();
                        if (openFeedViewCount >= maxOpenEditors) {
                            return;
                        }
                        OwlUI.openInFeedView(page, (IStructuredSelection)new StructuredSelection(newsmarksToOpenOnStartup), EnumSet.of(OwlUI.FeedViewOpenMode.IGNORE_ALREADY_OPENED, OwlUI.FeedViewOpenMode.IGNORE_REUSE));
                    }
                }
            });
        }
    }

    private void scheduleUpdate(IBookMark bookMark, Long intervalInSeconds) {
        ReloadJob updateJob = new ReloadJob(bookMark, "");
        updateJob.setSystem(true);
        updateJob.schedule(intervalInSeconds * 1000L);
    }

    private void registerListeners() {
        this.fBookMarkListener = new BookMarkAdapter(){

            public void entitiesAdded(Set<BookMarkEvent> events) {
                if (!Controller.getDefault().isShuttingDown()) {
                    FeedReloadService.this.onBookMarksAdded(events);
                }
            }

            public void entitiesUpdated(Set<BookMarkEvent> events) {
                if (!Controller.getDefault().isShuttingDown()) {
                    FeedReloadService.this.onBookMarksUpdated(events);
                }
            }

            public void entitiesDeleted(Set<BookMarkEvent> events) {
                if (!Controller.getDefault().isShuttingDown()) {
                    FeedReloadService.this.onBookMarksDeleted(events);
                }
            }
        };
        DynamicDAO.addEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
    }

    private void unregisterListeners() {
        DynamicDAO.removeEntityListener(IBookMark.class, (EntityListener)this.fBookMarkListener);
    }

    private void onBookMarksAdded(Set<BookMarkEvent> events) {
        for (BookMarkEvent event : events) {
            IBookMark addedBookMark = event.getEntity();
            IPreferenceScope entityPreferences = Owl.getPreferenceService().getEntityScope((IEntity)addedBookMark);
            Long interval = entityPreferences.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
            boolean autoUpdateState = entityPreferences.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE);
            if (!autoUpdateState) continue;
            this.addUpdate(event.getEntity(), interval);
        }
    }

    private void onBookMarksUpdated(Set<BookMarkEvent> events) {
        for (BookMarkEvent event : events) {
            IBookMark updatedBookMark = event.getEntity();
            this.sync(updatedBookMark);
        }
    }

    private void onBookMarksDeleted(Set<BookMarkEvent> events) {
        for (BookMarkEvent event : events) {
            this.removeUpdate(event.getEntity());
        }
    }

    public void sync(IBookMark updatedBookmark) {
        IPreferenceScope entityPreferences = Owl.getPreferenceService().getEntityScope((IEntity)updatedBookmark);
        Long oldInterval = this.fMapBookMarkToInterval.get(updatedBookmark);
        Long newInterval = entityPreferences.getLong(DefaultPreferences.BM_UPDATE_INTERVAL);
        boolean autoUpdateState = entityPreferences.getBoolean(DefaultPreferences.BM_UPDATE_INTERVAL_STATE);
        if (oldInterval != null) {
            if (!autoUpdateState) {
                this.removeUpdate(updatedBookmark);
            } else if (!newInterval.equals(oldInterval)) {
                Job.getJobManager().cancel((Object)updatedBookmark);
                this.fMapBookMarkToInterval.put(updatedBookmark, newInterval);
                this.scheduleUpdate(updatedBookmark, newInterval);
            }
        } else if (autoUpdateState) {
            this.addUpdate(updatedBookmark, newInterval);
        }
    }

    private void removeUpdate(IBookMark bookmark) {
        this.fMapBookMarkToInterval.remove(bookmark);
        Job.getJobManager().cancel((Object)bookmark);
    }

    private void addUpdate(IBookMark bookmark, Long intervalInSeconds) {
        this.fMapBookMarkToInterval.put(bookmark, intervalInSeconds);
        this.scheduleUpdate(bookmark, intervalInSeconds);
    }

    private class ReloadJob
    extends Job {
        private final IBookMark fBookMark;
        private long fLastRunInMillis;

        ReloadJob(IBookMark bookMark, String name) {
            super(name);
            this.fBookMark = bookMark;
            this.fLastRunInMillis = System.currentTimeMillis();
        }

        protected IStatus run(IProgressMonitor monitor) {
            Long updateIntervalInSeconds = (Long)FeedReloadService.this.fMapBookMarkToInterval.get(this.fBookMark);
            if (this.delay(updateIntervalInSeconds) && !monitor.isCanceled()) {
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.fLastRunInMillis = System.currentTimeMillis();
            if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                Controller.getDefault().reloadQueued(this.fBookMark, null, null);
            }
            if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown() && updateIntervalInSeconds != null) {
                this.schedule(updateIntervalInSeconds * 1000L);
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family.equals(this.fBookMark) || family.equals(FeedReloadService.this);
        }

        private boolean delay(Long updateIntervalInSeconds) {
            if (this.fLastRunInMillis == 0L || updateIntervalInSeconds == null) {
                return false;
            }
            long dif = System.currentTimeMillis() - this.fLastRunInMillis;
            return dif > updateIntervalInSeconds * 1000L + 300000L;
        }
    }
}

