/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.fatal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.fatal.Messages;
import org.rssowl.ui.internal.util.LayoutUtils;

public class CleanProfilePage
extends WizardPage {
    private final boolean fHasOPMLBackup;
    private Button fConfirmWarningCheck;
    private Button fDoRecoverCheck;
    private final IStatus fErrorStatus;

    CleanProfilePage(String pageName, IStatus errorStatus, boolean hasOPMLBackup) {
        super(pageName, pageName, null);
        this.fErrorStatus = errorStatus;
        this.fHasOPMLBackup = hasOPMLBackup;
    }

    public void createControl(Composite parent) {
        this.setImageDescriptor(OwlUI.getImageDescriptor("icons/wizban/welcome_wiz.gif"));
        if (!this.fErrorStatus.isOK()) {
            this.setMessage(Messages.CleanProfilePage_RSSOWL_CRASH, 2);
        } else {
            this.setMessage(this.fHasOPMLBackup ? Messages.CleanProfilePage_CLEAN_TEXT_OPML_OK : Messages.CleanProfilePage_CLEAN_TEXT_OK, 1);
        }
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)LayoutUtils.createGridLayout(1, 5, 5));
        ((GridLayout)container.getLayout()).marginBottom = 10;
        Label recoverInfoLabel = new Label(container, 0);
        recoverInfoLabel.setText(this.fHasOPMLBackup ? Messages.CleanProfilePage_RESTORING_SUBSCRIPTIONS_SETTINGS : Messages.CleanProfilePage_STARTING_OVER);
        recoverInfoLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        recoverInfoLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        Label recoverInfoTextLabel = new Label(container, 64);
        if (this.fHasOPMLBackup) {
            recoverInfoTextLabel.setText(Messages.CleanProfilePage_OPML_BACKUP_INFO);
        } else {
            recoverInfoTextLabel.setText(Messages.CleanProfilePage_NO_BACKUPS);
        }
        recoverInfoTextLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)recoverInfoTextLabel.getLayoutData()).widthHint = 200;
        this.fDoRecoverCheck = new Button(container, 32);
        this.fDoRecoverCheck.setText(this.fHasOPMLBackup ? Messages.CleanProfilePage_RESTORE_SUBSCRIPTIONS_SETTINGS : Messages.CleanProfilePage_START_OVER);
        this.fDoRecoverCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fDoRecoverCheck.getLayoutData()).verticalIndent = 5;
        ((GridData)this.fDoRecoverCheck.getLayoutData()).horizontalIndent = 5;
        this.fDoRecoverCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanProfilePage.this.getContainer().updateButtons();
                CleanProfilePage.this.fConfirmWarningCheck.setEnabled(CleanProfilePage.this.fDoRecoverCheck.getSelection());
            }
        });
        Label adviseLabel = new Label(container, 0);
        adviseLabel.setText(Messages.CleanProfilePage_CAUTION);
        adviseLabel.setFont(OwlUI.getBold("org.eclipse.jface.dialogfont"));
        adviseLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        ((GridData)adviseLabel.getLayoutData()).verticalIndent = 10;
        Label adviseTextLabel = new Label(container, 64);
        if (this.fHasOPMLBackup) {
            adviseTextLabel.setText(Messages.CleanProfilePage_CAUTION_TEXT_RESTORE);
        } else {
            adviseTextLabel.setText(Messages.CleanProfilePage_CAUTION_TEXT_START_OVER);
        }
        adviseTextLabel.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)adviseTextLabel.getLayoutData()).widthHint = 200;
        this.fConfirmWarningCheck = new Button(container, 32);
        this.fConfirmWarningCheck.setText(Messages.CleanProfilePage_CONFIRM_TEXT);
        this.fConfirmWarningCheck.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fConfirmWarningCheck.getLayoutData()).verticalIndent = 5;
        ((GridData)this.fConfirmWarningCheck.getLayoutData()).horizontalIndent = 5;
        this.fConfirmWarningCheck.setEnabled(false);
        this.fConfirmWarningCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CleanProfilePage.this.getContainer().updateButtons();
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public boolean isPageComplete() {
        return !this.fDoRecoverCheck.getSelection() || this.fConfirmWarningCheck.getSelection();
    }

    boolean doCleanProfile() {
        return this.fDoRecoverCheck.getSelection();
    }
}

