/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IActionFilter;
import org.rssowl.core.persist.IEntity;
import org.rssowl.ui.internal.EntityGroupItem;
import org.rssowl.ui.internal.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityGroup
implements IActionFilter {
    private final long fId;
    private final String fCategoryId;
    private final String fName;
    private ImageDescriptor fImage;
    List<EntityGroupItem> fItems;
    private final Integer fSortKey;
    private final RGB fColorHint;
    private int fSizeHint;

    public EntityGroup(long id, String groupId) {
        this(id, groupId, null);
    }

    public EntityGroup(long id, String groupId, String name) {
        this(id, groupId, name, null, null);
    }

    public EntityGroup(long id, String groupId, String name, Integer sortKey, RGB colorHint) {
        Assert.isNotNull((Object)groupId);
        this.fId = id;
        this.fCategoryId = groupId;
        this.fName = name;
        this.fItems = new ArrayList<EntityGroupItem>();
        this.fSortKey = sortKey;
        this.fColorHint = colorHint;
    }

    void add(EntityGroupItem item) {
        this.fItems.add(item);
    }

    public String getName() {
        return this.fName != null ? this.fName : NLS.bind((String)Messages.EntityGroup_GROUP, (Object)this.fId);
    }

    public long getId() {
        return this.fId;
    }

    public String getCategory() {
        return this.fCategoryId;
    }

    public List<EntityGroupItem> getItems() {
        return this.fItems;
    }

    public List<IEntity> getEntities() {
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        for (EntityGroupItem groupItem : this.fItems) {
            entities.add(groupItem.getEntity());
        }
        return entities;
    }

    public void setImage(ImageDescriptor image) {
        this.fImage = image;
    }

    public ImageDescriptor getImage() {
        return this.fImage;
    }

    public int size() {
        return this.fItems.size();
    }

    public Integer getSortKey() {
        return this.fSortKey;
    }

    public RGB getColorHint() {
        return this.fColorHint;
    }

    public void setSizeHint(int sizeHint) {
        this.fSizeHint = sizeHint;
    }

    public int getSizeHint() {
        return this.fSizeHint;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EntityGroup group = (EntityGroup)obj;
        return this.fId == group.fId;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.fId ^ this.fId >>> 32);
        return result;
    }

    public String toString() {
        return this.getName();
    }

    public boolean testAttribute(Object target, String name, String value) {
        return this == target && this.fCategoryId.equals(value);
    }
}

