/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.rssowl.core.Owl;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.LongOperationMonitor;
import org.rssowl.ui.internal.ApplicationServer;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.Messages;
import org.rssowl.ui.internal.dialogs.StartupProgressDialog;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.rssowl.ui";
    private static final String URL_REGEX = "(www([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?)|(http|ftp|https|feed):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?";
    private static final Pattern URL_REGEX_PATTERN = Pattern.compile("(www([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?)|(http|ftp|https|feed):\\/\\/[\\w]+(.[\\w]+)([\\wv\\-\\.,@?^=%&:/~\\+#]*[\\w\\-\\@?^=%&/~\\+#])?");
    private static Activator fgPlugin;
    private Thread fShutdownHook;
    private IStatus fStartupStatus = Status.OK_STATUS;
    private String fVersion;
    private String fNl;

    public Activator() {
        fgPlugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fVersion = (String)fgPlugin.getBundle().getHeaders().get("Bundle-Version");
        this.fNl = System.getProperty("line.separator");
        if (this.fNl == null) {
            this.fNl = "\n";
        }
        try {
            Activator.safeLogInfo("RSSOwl Starting Up (" + this.getUserAgent() + ")");
        }
        catch (Exception exception) {}
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                Activator.this.startServer();
            }

            public void handleException(Throwable e) {
                if (e instanceof CoreException) {
                    Activator.getDefault().getLog().log(((CoreException)e).getStatus());
                }
            }
        });
        this.fShutdownHook = new Thread(){

            public void run() {
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        if (Owl.isStarted() || Controller.isInitialized()) {
                            Controller.getDefault().shutdown(true);
                        }
                    }
                });
                SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                    public void run() throws Exception {
                        Owl.shutdown((boolean)true);
                    }
                });
                String logMessages = CoreUtils.getAndFlushLogMessages();
                if (logMessages != null && logMessages.length() > 0) {
                    Activator.safeLogError(logMessages, null);
                }
                Activator.safeLogInfo("RSSOwl Shutting Down (emergency)" + Activator.this.fNl);
            }
        };
        this.fShutdownHook.setPriority(10);
        Runtime.getRuntime().addShutdownHook(this.fShutdownHook);
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                Activator.this.startCore();
            }
        });
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                if (Owl.isStarted()) {
                    Controller.getDefault().startup();
                }
            }
        });
    }

    private void startCore() {
        Display.setAppName((String)"RSSOwl");
        Display.getDefault();
        final StartupProgressDialog dialog = new StartupProgressDialog();
        dialog.setOpenOnRun(false);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                LongOperationMonitor callbackMonitor = new LongOperationMonitor(monitor){
                    private boolean updateUi;
                    {
                        super($anonymous0);
                        this.updateUi = true;
                    }

                    public void beginLongOperation(boolean isCancelable) {
                        if (!this.isLongOperationRunning()) {
                            super.beginLongOperation(isCancelable);
                            dialog.open();
                        }
                    }

                    public void worked(int work) {
                        super.worked(work);
                        if (this.updateUi) {
                            this.updateUi();
                        }
                    }

                    public void subTask(String name) {
                        super.subTask(name);
                        if (this.updateUi) {
                            this.updateUi();
                        }
                    }

                    private void updateUi() {
                        Display display = Display.getDefault();
                        try {
                            if (!(this.isCanceled() || display.isDisposed() || dialog.getShell() == null || dialog.getShell().isDisposed())) {
                                display.readAndDispatch();
                                display.update();
                            }
                        }
                        catch (Exception e) {
                            this.updateUi = false;
                            Activator.this.logError(e.getMessage(), e);
                        }
                    }
                };
                try {
                    Owl.startup((LongOperationMonitor)callbackMonitor);
                }
                catch (Throwable e) {
                    Activator.this.fStartupStatus = Activator.this.createErrorStatus(e.getMessage(), e);
                    Activator.getDefault().getLog().log(Activator.this.fStartupStatus);
                }
            }
        };
        try {
            dialog.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            this.logError(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            this.logError(e.getMessage(), e);
        }
    }

    IStatus getStartupStatus() {
        return this.fStartupStatus;
    }

    private void startServer() {
        ApplicationServer server = ApplicationServer.getDefault();
        try {
            server.startup();
        }
        catch (BindException bindException) {
            String link = this.parseLink(Platform.getCommandLineArgs());
            this.doHandshake(link);
        }
        catch (IOException e) {
            this.logError(e.getMessage(), e);
        }
    }

    private String parseLink(String[] commandLineArgs) {
        String[] stringArray = commandLineArgs;
        int n = commandLineArgs.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            if (this.looksLikeLink(arg)) {
                return arg;
            }
            ++n2;
        }
        return null;
    }

    private boolean looksLikeLink(String str) {
        if (!this.isSet(str)) {
            return false;
        }
        if (str.indexOf(32) >= 0) {
            return false;
        }
        if (URL_REGEX_PATTERN.matcher(str).matches()) {
            return true;
        }
        try {
            new URL(str);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    private boolean isSet(String str) {
        return str != null && str.length() > 0;
    }

    private void doHandshake(String message) {
        try {
            Socket socket = new Socket(InetAddress.getByName(ApplicationServer.LOCALHOST), 8795);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            writer.println(this.isSet(message) ? message : "org.rssowl.ui.internal.StartupHandshake");
            writer.flush();
            try {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    System.exit(0);
                    Activator.safeLogInfo("RSSOwl Shutting Down (already running)" + this.fNl);
                    System.exit(0);
                }
            }
            finally {
                Activator.safeLogInfo("RSSOwl Shutting Down (already running)" + this.fNl);
                System.exit(0);
            }
        }
        catch (UnknownHostException e) {
            this.logError(Messages.Activator_ERROR_STARTUP, e);
        }
        catch (IOException e) {
            this.logError(Messages.Activator_ERROR_STARTUP, e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        Runtime.getRuntime().removeShutdownHook(this.fShutdownHook);
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                if (Owl.isStarted() || Controller.isInitialized()) {
                    Controller.getDefault().shutdown(false);
                }
            }
        });
        super.stop(context);
        fgPlugin = null;
    }

    public static Activator getDefault() {
        return fgPlugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.getImageDescriptor(PLUGIN_ID, path);
    }

    public static ImageDescriptor getImageDescriptor(String pluginId, String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path);
    }

    public static void safeLogInfo(String msg) {
        Activator activator = fgPlugin;
        if (activator != null) {
            activator.getLog().log((IStatus)new Status(1, activator.getBundle().getSymbolicName(), 0, msg, null));
        }
    }

    public static void safeLogError(String msg, Throwable e) {
        if (fgPlugin != null) {
            fgPlugin.logError(msg, e);
        }
    }

    public void logError(String msg, Throwable e) {
        if (msg == null) {
            msg = "";
        }
        this.getLog().log((IStatus)new Status(4, this.getBundle().getSymbolicName(), 4, msg, e));
    }

    public void logWarning(String msg, Exception e) {
        if (msg == null) {
            msg = "";
        }
        this.getLog().log((IStatus)new Status(2, this.getBundle().getSymbolicName(), 2, msg, (Throwable)e));
    }

    public IStatus createErrorStatus(String msg, Throwable e) {
        return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 4, msg, e);
    }

    public IStatus createErrorStatus(String msg) {
        return new Status(4, Activator.getDefault().getBundle().getSymbolicName(), msg);
    }

    public IStatus createInfoStatus(String msg, Exception e) {
        return new Status(1, Activator.getDefault().getBundle().getSymbolicName(), 1, msg, (Throwable)e);
    }

    private String getUserAgent() {
        String os = Platform.getOS();
        if ("win32".equals(os)) {
            return "RSSOwl/" + this.fVersion + " (Windows; U; en)";
        }
        if ("linux".equals(os)) {
            return "RSSOwl/" + this.fVersion + " (X11; U; en)";
        }
        if ("macosx".equals(os)) {
            return "RSSOwl/" + this.fVersion + " (Macintosh; U; en)";
        }
        return "RSSOwl/" + this.fVersion;
    }
}

