/*
 * Decompiled with CFR 0.152.
 */
package msearch.filmeSuchen.sender;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import msearch.daten.DatenFilm;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSGetUrl;
import msearch.filmeSuchen.sender.MediathekReader;
import msearch.tool.MSConfig;
import msearch.tool.MSLog;
import msearch.tool.MSStringBuilder;
import org.apache.commons.lang3.StringEscapeUtils;

public class MediathekOrf
extends MediathekReader
implements Runnable {
    public static final String SENDERNAME = "ORF";
    private static final String THEMA_TAG = "-1";
    private static final String THEMA_SENDUNGEN = "-2";

    public MediathekOrf(MSFilmeSuchen ssearch, int startPrio) {
        super(ssearch, SENDERNAME, 2, 500, startPrio);
    }

    @Override
    void addToList() {
        MSStringBuilder seite = new MSStringBuilder(65536);
        this.listeThemen.clear();
        this.meldungStart();
        if (MSConfig.loadLongMax()) {
            this.bearbeiteAdresseSendung(seite);
        }
        this.bearbeiteAdresseThemen(seite);
        MediathekOrf.listeSort(this.listeThemen, 1);
        int maxTage = MSConfig.loadLongMax() ? 9 : 2;
        for (int i = 0; i < maxTage; ++i) {
            String vorTagen = MediathekOrf.getGestern(i).toLowerCase();
            this.bearbeiteAdresseTag("http://tvthek.orf.at/schedule/" + vorTagen, seite);
        }
        if (MSConfig.getStop()) {
            this.meldungThreadUndFertig();
        } else if (this.listeThemen.size() == 0) {
            this.meldungThreadUndFertig();
        } else {
            this.meldungAddMax(this.listeThemen.size());
            for (int t = 0; t < this.maxThreadLaufen; ++t) {
                Thread th = new Thread(new ThemaLaden());
                th.setName(SENDERNAME + t);
                th.start();
            }
        }
    }

    private void bearbeiteAdresseTag(String adresse, MSStringBuilder seite) {
        seite = this.getUrlIo.getUri(SENDERNAME, adresse, "UTF-8", 2, seite, "");
        ArrayList<String> al = new ArrayList<String>();
        seite.extractList("<a href=\"http://tvthek.orf.at/program/", "\"", 0, "http://tvthek.orf.at/program/", al);
        for (String s : al) {
            String[] add = new String[]{s, THEMA_TAG};
            if (this.istInListe(this.listeThemen, add[0], 0)) continue;
            this.listeThemen.add(add);
        }
    }

    private void bearbeiteAdresseThemen(MSStringBuilder seite) {
        String URL2 = "http://tvthek.orf.at/programs/genre/";
        seite = this.getUrlIo.getUri(SENDERNAME, "http://tvthek.orf.at/programs", "UTF-8", 3, seite, "");
        ArrayList<String> al = new ArrayList<String>();
        try {
            seite.extractList("http://tvthek.orf.at/programs/genre/", "#", 0, "", al);
            for (String s : al) {
                String[] add;
                String thema = "";
                if (s.contains("/") && (thema = s.substring(0, s.indexOf("/"))).isEmpty()) {
                    thema = SENDERNAME;
                }
                if (this.istInListe(this.listeThemen, (add = new String[]{"http://tvthek.orf.at/programs/genre/" + s, thema})[0], 0)) continue;
                this.listeThemen.add(add);
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(826341789, ex);
        }
    }

    private void bearbeiteAdresseSendung(MSStringBuilder seite) {
        String URL2 = "http://tvthek.orf.at/programs/letter/";
        seite = this.getUrlIo.getUri(SENDERNAME, "http://tvthek.orf.at/programs", "UTF-8", 3, seite, "");
        ArrayList<String> al = new ArrayList<String>();
        try {
            seite.extractList("http://tvthek.orf.at/programs/letter/", "\"", 0, "", al);
            for (String s : al) {
                String thema = THEMA_SENDUNGEN;
                String[] add = new String[]{"http://tvthek.orf.at/programs/letter/" + s, thema};
                if (this.istInListe(this.listeThemen, add[0], 0)) continue;
                this.listeThemen.add(add);
            }
        }
        catch (Exception ex) {
            MSLog.fehlerMeldung(826341789, ex);
        }
    }

    public static String getGestern(int tage) {
        try {
            SimpleDateFormat sdfOut = new SimpleDateFormat("dd.MM.yyyy");
            return sdfOut.format(new Date(new Date().getTime() - (long)(tage * 86400000)));
        }
        catch (Exception ex) {
            return "";
        }
    }

    private class ThemaLaden
    implements Runnable {
        MSGetUrl getUrl;
        private MSStringBuilder seite1;
        private MSStringBuilder seite2;
        private final ArrayList<String> alSendung;
        private final ArrayList<String> alThemen;

        private ThemaLaden() {
            this.getUrl = new MSGetUrl(MediathekOrf.this.wartenSeiteLaden);
            this.seite1 = new MSStringBuilder(65536);
            this.seite2 = new MSStringBuilder(65536);
            this.alSendung = new ArrayList();
            this.alThemen = new ArrayList();
        }

        @Override
        public synchronized void run() {
            try {
                String[] link;
                MediathekOrf.this.meldungAddThread();
                block12: while (!MSConfig.getStop() && (link = MediathekOrf.this.listeThemen.getListeThemen()) != null) {
                    try {
                        MediathekOrf.this.meldungProgress(link[0]);
                        switch (link[1]) {
                            case "-1": {
                                this.feedEinerSeiteSuchen(link[0], "", false, true);
                                continue block12;
                            }
                            case "-2": {
                                this.sendungen(link[0]);
                                continue block12;
                            }
                        }
                        this.themen(link[0]);
                    }
                    catch (Exception ex) {
                        MSLog.fehlerMeldung(795633581, ex);
                    }
                }
            }
            catch (Exception ex) {
                MSLog.fehlerMeldung(554012398, ex);
            }
            MediathekOrf.this.meldungThreadUndFertig();
        }

        private void sendungen(String url) {
            String URL2 = "http://tvthek.orf.at/program/";
            this.seite1 = MediathekOrf.this.getUrlIo.getUri(MediathekOrf.SENDERNAME, url, "UTF-8", 2, this.seite1, "");
            this.alSendung.clear();
            this.seite1.extractList("http://tvthek.orf.at/program/", "\"", 0, "", this.alSendung);
            for (String s : this.alSendung) {
                String thema = "";
                if (s.contains("/") && (thema = s.substring(0, s.indexOf("/"))).isEmpty()) {
                    thema = MediathekOrf.SENDERNAME;
                }
                this.feedEinerSeiteSuchen("http://tvthek.orf.at/program/" + s, thema, false, false);
            }
        }

        private void themen(String url) {
            String URL2 = "http://tvthek.orf.at/program/";
            this.seite1 = MediathekOrf.this.getUrlIo.getUri(MediathekOrf.SENDERNAME, url, "UTF-8", 2, this.seite1, "");
            this.alSendung.clear();
            String themaAlt = "";
            int count = 0;
            int max = 3;
            this.seite1.extractList("http://tvthek.orf.at/program/", "\"", 0, "", this.alSendung);
            for (String s : this.alSendung) {
                if (!MSConfig.loadLongMax() && count > max) continue;
                String thema = "";
                if (s.contains("/")) {
                    thema = s.substring(0, s.indexOf("/"));
                    if (thema.equals(themaAlt)) {
                        ++count;
                    } else {
                        themaAlt = thema;
                        count = 0;
                    }
                    if (thema.isEmpty()) {
                        thema = MediathekOrf.SENDERNAME;
                    }
                }
                this.feedEinerSeiteSuchen("http://tvthek.orf.at/program/" + s, thema, false, false);
            }
        }

        private void feedEinerSeiteSuchen(String strUrlFeed, String thema, boolean themaBehalten, boolean nurUrlPruefen) {
            int posStart;
            this.seite2 = this.getUrl.getUri_Utf(MediathekOrf.SENDERNAME, strUrlFeed, this.seite2, "");
            long duration = 0L;
            String urlRtmpKlein = "";
            String urlRtmp = "";
            String url = "";
            String urlKlein = "";
            String urlHD = "";
            int pos = 0;
            MediathekOrf.this.meldung(strUrlFeed);
            String titel = this.seite2.extract("<title>", "vom");
            String datum = this.seite2.extract("<span class=\"meta meta_date\">", "<");
            if (datum.contains(",")) {
                datum = datum.substring(datum.indexOf(",") + 1).trim();
            }
            String zeit = this.seite2.extract("<span class=\"meta meta_time\">", "<");
            if ((zeit = zeit.replace("Uhr", "").trim()).length() == 5) {
                zeit = zeit.replace(".", ":") + ":00";
            }
            if ((posStart = this.seite2.indexOf("\"is_one_segment_episode\":false")) == -1 && (posStart = this.seite2.indexOf("\"is_one_segment_episode\":true")) == -1) {
                MSLog.fehlerMeldung(989532147, "keine Url: " + strUrlFeed);
                return;
            }
            int posStopAlles = this.seite2.indexOf("</script>", posStart);
            if (posStopAlles != -1) {
                if (!themaBehalten) {
                    thema = titel;
                }
                String MUSTER_SUCHEN = "\"clickcounter_corrected\":\"";
                while ((pos = this.seite2.indexOf("\"clickcounter_corrected\":\"", pos)) != -1) {
                    int tmpPos2;
                    int posStopEpisode = this.seite2.indexOf("\"is_episode_one_segment_episode\":false", pos);
                    if (posStopEpisode == -1) {
                        posStopEpisode = this.seite2.indexOf("\"is_episode_one_segment_episode\":true", pos);
                    }
                    if (posStopEpisode == -1 || posStopEpisode > posStopAlles || pos > posStopAlles) break;
                    String tmp = this.seite2.extract("\"duration\":\"", "\"", pos += "\"clickcounter_corrected\":\"".length(), posStopEpisode);
                    try {
                        duration = Long.parseLong(tmp) / 1000L;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    titel = this.seite2.extract("\"header\":\"", "\",", pos, posStopEpisode);
                    if (!titel.equals(StringEscapeUtils.unescapeJava(titel))) {
                        titel = StringEscapeUtils.unescapeJava(titel).trim();
                    }
                    String subtitle = this.seite2.extract("\"srt_file_url\":\"", "\"", pos, posStopEpisode);
                    String description = this.seite2.extract("\"description\":\"", "\"", pos, posStopEpisode);
                    if (!description.equals(StringEscapeUtils.unescapeJava(description))) {
                        description = StringEscapeUtils.unescapeJava(description).trim();
                    }
                    url = "";
                    urlHD = "";
                    urlKlein = "";
                    int tmpPos1 = pos;
                    String MUSTER_URL = "quality\":\"Q6A\",\"quality_string\":\"hoch\",\"src\":\"http";
                    while (!((tmpPos1 = this.seite2.indexOf("quality\":\"Q6A\",\"quality_string\":\"hoch\",\"src\":\"http", tmpPos1)) == -1 || (tmpPos1 += "quality\":\"Q6A\",\"quality_string\":\"hoch\",\"src\":\"http".length()) > posStopEpisode || (tmpPos2 = this.seite2.indexOf("\"", tmpPos1)) != -1 && (url = this.seite2.substring(tmpPos1, tmpPos2)).endsWith(".mp4"))) {
                    }
                    if (!url.isEmpty()) {
                        url = url.replace("\\/", "/");
                        url = "http" + url;
                    } else {
                        int mpos;
                        url = this.seite2.extract("quality\":\"Q6A\",\"quality_string\":\"hoch\",\"src\":\"rtmp", "\"", posStopEpisode);
                        if (!(url = url.replace("\\/", "/")).isEmpty() && (mpos = (url = "rtmp" + url).indexOf("mp4:")) != -1) {
                            urlRtmp = "-r " + url + " -y " + url.substring(mpos) + " --flashVer WIN11,4,402,265 --swfUrl http://tvthek.orf.at/flash/player/TVThekPlayer_9_ver18_1.swf";
                        }
                    }
                    tmpPos1 = pos;
                    String MUSTER_URL_HD = "quality\":\"Q8C\",\"quality_string\":\"sehr hoch (HD)\",\"src\":\"http";
                    while (!((tmpPos1 = this.seite2.indexOf("quality\":\"Q8C\",\"quality_string\":\"sehr hoch (HD)\",\"src\":\"http", tmpPos1)) == -1 || (tmpPos1 += "quality\":\"Q8C\",\"quality_string\":\"sehr hoch (HD)\",\"src\":\"http".length()) > posStopEpisode || (tmpPos2 = this.seite2.indexOf("\"", tmpPos1)) != -1 && (urlHD = this.seite2.substring(tmpPos1, tmpPos2)).endsWith(".mp4"))) {
                    }
                    if (!urlHD.isEmpty()) {
                        urlHD = urlHD.replace("\\/", "/");
                        urlHD = "http" + urlHD;
                    }
                    tmpPos1 = pos;
                    String MUSTER_URL_KLEIN = "quality\":\"Q4A\",\"quality_string\":\"mittel\",\"src\":\"http";
                    while (!((tmpPos1 = this.seite2.indexOf("quality\":\"Q4A\",\"quality_string\":\"mittel\",\"src\":\"http", tmpPos1)) == -1 || (tmpPos1 += "quality\":\"Q4A\",\"quality_string\":\"mittel\",\"src\":\"http".length()) > posStopEpisode || (tmpPos2 = this.seite2.indexOf("\"", tmpPos1)) != -1 && (urlKlein = this.seite2.substring(tmpPos1, tmpPos2)).endsWith(".mp4"))) {
                    }
                    if (!urlKlein.isEmpty()) {
                        urlKlein = urlKlein.replace("\\/", "/");
                        urlKlein = "http" + urlKlein;
                    } else {
                        int mpos;
                        urlKlein = this.seite2.extract("quality\":\"Q4A\",\"quality_string\":\"mittel\",\"src\":\"rtmp", "\"", pos, posStopEpisode);
                        if (!(urlKlein = urlKlein.replace("\\/", "/")).isEmpty() && (mpos = (urlKlein = "rtmp" + urlKlein).indexOf("mp4:")) != -1) {
                            urlRtmpKlein = "-r " + urlKlein + " -y " + urlKlein.substring(mpos) + " --flashVer WIN11,4,402,265 --swfUrl http://tvthek.orf.at/flash/player/TVThekPlayer_9_ver18_1.swf";
                        }
                    }
                    if (!url.isEmpty()) {
                        if (thema.isEmpty()) {
                            thema = MediathekOrf.SENDERNAME;
                        }
                        if (titel.isEmpty()) {
                            titel = MediathekOrf.SENDERNAME;
                        }
                        DatenFilm film = new DatenFilm(MediathekOrf.SENDERNAME, thema, strUrlFeed, titel, url, urlRtmp, datum, zeit, duration, description);
                        if (!urlKlein.isEmpty()) {
                            film.addUrlKlein(urlKlein, urlRtmpKlein);
                        }
                        if (!urlHD.isEmpty()) {
                            // empty if block
                        }
                        if (!subtitle.isEmpty()) {
                            subtitle = subtitle.replace("\\/", "/");
                            subtitle = subtitle.replace("%2F", "/");
                            film.addUrlSubtitle(subtitle);
                        }
                        MediathekOrf.this.addFilm(film, nurUrlPruefen);
                        continue;
                    }
                    MSLog.fehlerMeldung(989532147, "keine Url: " + strUrlFeed);
                }
            }
        }
    }
}

