/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mac;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.PreferencesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import com.jidesoft.utils.SystemInfo;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import mediathek.MediathekGui;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.mac.OsxIndicatorThread;
import mediathek.tool.ListenerMediathekView;

public class MediathekGuiMac
extends MediathekGui {
    private Thread osxProgressIndicatorThread = null;
    private ButtonGroup group = null;

    public MediathekGuiMac(String[] ar) {
        super(ar);
    }

    @Override
    protected void initMenue() {
        super.initMenue();
        if (SystemInfo.isMacOSX()) {
            this.setupUserInterfaceForOsx();
            this.setupAcceleratorsForOsx();
        }
    }

    private void setupAcceleratorsForOsx() {
        this.jMenuItemFilmAbspielen.setAccelerator(KeyStroke.getKeyStroke(117, 4));
        this.jMenuItemFilmAufzeichnen.setAccelerator(KeyStroke.getKeyStroke(118, 4));
        this.jMenuItemFilterLoeschen.setAccelerator(KeyStroke.getKeyStroke(119, 4));
        this.jMenuItemBlacklist.setAccelerator(KeyStroke.getKeyStroke(120, 4));
        this.jCheckBoxMenuItemBeschreibung.setAccelerator(KeyStroke.getKeyStroke(121, 4));
        this.jCheckBoxMenuItemVideoplayer.setAccelerator(KeyStroke.getKeyStroke(122, 4));
    }

    private void setupOsxDockIconBadge() {
        ListenerMediathekView.addListener(new ListenerMediathekView(new int[]{14, 9}, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                int activeDownloads = Daten.downloadInfos.downloadStarts[4];
                Application application = Application.getApplication();
                if (activeDownloads > 0) {
                    application.setDockIconBadge(String.valueOf(activeDownloads));
                    if (MediathekGuiMac.this.osxProgressIndicatorThread == null) {
                        MediathekGuiMac.this.osxProgressIndicatorThread = new OsxIndicatorThread();
                        MediathekGuiMac.this.osxProgressIndicatorThread.start();
                    }
                } else {
                    application.setDockIconBadge("");
                    if (MediathekGuiMac.this.osxProgressIndicatorThread != null) {
                        MediathekGuiMac.this.osxProgressIndicatorThread.interrupt();
                        MediathekGuiMac.this.osxProgressIndicatorThread = null;
                    }
                }
            }
        });
    }

    private void setupUserInterfaceForOsx() {
        Application application = Application.getApplication();
        application.disableSuddenTermination();
        application.setAboutHandler(new AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent aboutEvent) {
                MediathekGuiMac.this.showAboutDialog();
            }
        });
        application.setPreferencesHandler(new PreferencesHandler(){

            public void handlePreferences(AppEvent.PreferencesEvent preferencesEvent) {
                MediathekGuiMac.this.dialogEinstellungen.setVisible(true);
            }
        });
        application.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
                if (!MediathekGuiMac.this.beenden(false, false)) {
                    quitResponse.cancelQuit();
                } else {
                    quitResponse.performQuit();
                }
            }
        });
        try {
            URL url = this.getClass().getResource("/mediathek/res/MediathekView.png");
            BufferedImage appImage = ImageIO.read(url);
            application.setDockIconImage((Image)appImage);
        }
        catch (IOException ex) {
            Log.fehlerMeldung(165623698, "OS X Application image could not be loaded");
        }
        if (SystemInfo.isMacOSX()) {
            this.jMenuDatei.remove(this.jSeparator2);
            this.jMenuDatei.remove(this.jMenuItemBeenden);
            this.jMenuDatei.remove(this.jMenuItemEinstellungen);
            this.jMenuHilfe.remove(this.jSeparator4);
            this.jMenuHilfe.remove(this.jMenuItemAbout);
        }
        this.setupOsxDockIconBadge();
    }

    @Override
    protected void shutdownComputer() {
        try {
            ProcessBuilder builder = new ProcessBuilder("/usr/bin/osascript", "-e");
            builder.command().add("tell application \"OSX_Shutdown\" to activate");
            builder.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getNumberOfDownloads() {
        int numDownloads;
        if (Daten.mVConfig.get("maxDownload").equals("")) {
            Daten.mVConfig.add("maxDownload", "1");
            numDownloads = 1;
        } else {
            numDownloads = Integer.parseInt(Daten.mVConfig.get("maxDownload"));
        }
        return numDownloads;
    }

    @Override
    protected void setupMaximumNumberOfDownloadsMenuItem() {
        this.jMenuDownload.addSeparator();
        JMenu numDownloadsMenu = new JMenu("Anzahl gleichzeitiger Downloads");
        this.group = new ButtonGroup();
        for (int i = 1; i <= 10; ++i) {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(Integer.toString(i));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AbstractButton btn = (AbstractButton)e.getSource();
                    if (btn != null) {
                        Daten.mVConfig.add("maxDownload", btn.getText());
                        ListenerMediathekView.notify(6, MediathekGui.class.getSimpleName());
                    }
                }
            });
            this.group.add(menuItem);
            numDownloadsMenu.add(menuItem);
        }
        this.jMenuDownload.add(numDownloadsMenu);
        ListenerMediathekView.addListener(new ListenerMediathekView(6, MediathekGui.class.getSimpleName()){

            @Override
            public void ping() {
                MediathekGuiMac.this.setupMaxDownloadButtonSelection(MediathekGuiMac.this.getNumberOfDownloads());
            }
        });
        this.setupMaxDownloadButtonSelection(this.getNumberOfDownloads());
    }

    private void setupMaxDownloadButtonSelection(int numDownloads) {
        if (this.group == null) {
            return;
        }
        Enumeration<AbstractButton> elem = this.group.getElements();
        while (elem.hasMoreElements()) {
            AbstractButton btn = elem.nextElement();
            if (!btn.getText().equals(Integer.toString(numDownloads))) continue;
            btn.doClick();
            btn.setSelected(true);
            break;
        }
    }

    @Override
    protected void setupBandwidthMenuItem() {
    }

    @Override
    protected void initSpinner() {
    }
}

