/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import javax.swing.JFrame;
import mediathek.daten.Daten;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogOk;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.TModel;

public class ListePset
extends LinkedList<DatenPset> {
    public static final String MUSTER_PFAD_ZIEL = "ZIELPFAD";
    public static final String MUSTER_PFAD_VLC = "PFAD_VLC";
    public static final String MUSTER_PFAD_FLV = "PFAD_FLVSTREAMER";
    public static final String MUSTER_PFAD_FFMPEG = "PFAD_FFMPEG";
    public static final String MUSTER_PFAD_SCRIPT = "PFAD_SCRIPT";
    public String version = "";

    public DatenPset getPsetAbspielen() {
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[7])) continue;
            return datenPset;
        }
        return null;
    }

    public DatenPset getPsetAbo(String name) {
        DatenPset ret = null;
        if (this.size() == 0) {
            ret = null;
        } else if (this.size() == 1) {
            ret = (DatenPset)this.getFirst();
        } else {
            ListePset ps;
            ListIterator it = this.listIterator(0);
            while (it.hasNext()) {
                DatenPset gruppe = (DatenPset)it.next();
                if (!gruppe.istAbo() || !gruppe.arr[0].equals(name)) continue;
                ret = gruppe;
            }
            if (ret == null && (ps = this.getListeAbo()).size() > 0 && (ret = (DatenPset)this.getListeAbo().getFirst()) == null) {
                ret = (DatenPset)this.getFirst();
            }
        }
        return ret;
    }

    public ListePset getListeSpeichern() {
        ListePset liste = new ListePset();
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[8])) continue;
            liste.add(datenPset);
        }
        return liste;
    }

    public ListePset getListeButton() {
        ListePset liste = new ListePset();
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[9])) continue;
            liste.add(datenPset);
        }
        return liste;
    }

    public ListePset getListeAbo() {
        ListePset liste = new ListePset();
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[10])) continue;
            liste.add(datenPset);
        }
        return liste;
    }

    public String[] getObjectDataCombo() {
        int i = 0;
        ListIterator it = this.listIterator(0);
        String[] object = new String[this.size()];
        while (it.hasNext()) {
            object[i] = ((DatenPset)it.next()).arr[0];
            ++i;
        }
        return object;
    }

    public int auf(int idx, boolean auf) {
        DatenPset prog = (DatenPset)this.remove(idx);
        int neu = idx;
        if (auf) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, prog);
        ListenerMediathekView.notify(3, ListePset.class.getSimpleName());
        return neu;
    }

    public boolean addPset(DatenPset datenPset) {
        boolean abspielen = false;
        for (DatenPset datenPset1 : this) {
            if (!Boolean.parseBoolean(datenPset1.arr[7])) continue;
            abspielen = true;
            break;
        }
        if (abspielen) {
            datenPset.arr[7] = Boolean.FALSE.toString();
        }
        boolean ret = this.add(datenPset);
        ListenerMediathekView.notify(3, ListePset.class.getSimpleName());
        return ret;
    }

    public boolean addPset(ListePset liste) {
        boolean ret = true;
        for (DatenPset entry : liste) {
            if (this.addPset(entry)) continue;
            ret = false;
        }
        ListenerMediathekView.notify(3, ListePset.class.getSimpleName());
        return ret;
    }

    public static boolean progMusterErsetzen(JFrame parent, ListePset liste) {
        boolean ret = true;
        for (DatenPset pSet : liste) {
            if (ListePset.progMusterErsetzen(parent, pSet)) continue;
            ret = false;
        }
        ListenerMediathekView.notify(3, ListePset.class.getSimpleName());
        return ret;
    }

    private static boolean progMusterErsetzen(JFrame parent, DatenPset pSet) {
        DatenProg prog;
        int p;
        pSet.arr[4] = pSet.arr[4].replace(MUSTER_PFAD_ZIEL, GuiFunktionen.getStandardDownloadPath());
        String vlc = "";
        String flvstreamer = "";
        String ffmpeg = "";
        String skript = GuiFunktionenProgramme.getPfadScript();
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_VLC) && !prog.arr[3].contains(MUSTER_PFAD_VLC)) continue;
            vlc = ListePset.getPfadVlc(parent);
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_FLV) && !prog.arr[3].contains(MUSTER_PFAD_FLV)) continue;
            flvstreamer = ListePset.getPfadFlv(parent);
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_FFMPEG) && !prog.arr[3].contains(MUSTER_PFAD_FFMPEG)) continue;
            ffmpeg = ListePset.getPfadFFmpeg(parent);
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_VLC, Matcher.quoteReplacement(vlc));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_VLC, Matcher.quoteReplacement(vlc));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_FLV, Matcher.quoteReplacement(flvstreamer));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_FLV, Matcher.quoteReplacement(flvstreamer));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_FFMPEG, Matcher.quoteReplacement(ffmpeg));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_FFMPEG, Matcher.quoteReplacement(ffmpeg));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_SCRIPT, Matcher.quoteReplacement(skript));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_SCRIPT, Matcher.quoteReplacement(skript));
        }
        return true;
    }

    private static String getPfadVlc(JFrame parent) {
        if (Daten.mVConfig.get("pfad-vlc").equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(parent, true, false, false), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.mVConfig.get("pfad-vlc");
    }

    private static String getPfadFlv(JFrame parent) {
        if (Daten.mVConfig.get("pfad-flvstreamer").equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(parent, false, true, false), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.mVConfig.get("pfad-flvstreamer");
    }

    private static String getPfadFFmpeg(JFrame parent) {
        if (Daten.mVConfig.get("pfad-ffmpeg").equals("")) {
            new DialogOk(null, true, new PanelProgrammPfade(parent, false, false, true), "Pfade Standardprogramme").setVisible(true);
        }
        return Daten.mVConfig.get("pfad-ffmpeg");
    }

    public TModel getModel() {
        TModel model;
        int i = 0;
        if (this.size() > 0) {
            ListIterator iterator = this.listIterator(0);
            Object[][] object = new Object[this.size()][22];
            while (iterator.hasNext()) {
                DatenPset datenPset = (DatenPset)iterator.next();
                object[i] = datenPset.arr;
                ++i;
            }
            model = new TModel(object, DatenPset.COLUMN_NAMES);
        } else {
            model = new TModel(new Object[0][22], DatenPset.COLUMN_NAMES);
        }
        return model;
    }
}

