/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.awt.Frame;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.gui.dialog.DialogLeer;
import mediathek.gui.dialogEinstellungen.PanelFilmlisteLaden;
import mediathek.tool.Duration;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVListeFilme;
import mediathek.tool.MVMessageDialog;
import msearch.daten.DatenFilm;
import msearch.daten.ListeFilme;
import msearch.filmeSuchen.MSFilmeSuchen;
import msearch.filmeSuchen.MSListenerFilmeLaden;
import msearch.filmeSuchen.MSListenerFilmeLadenEvent;
import msearch.filmlisten.ListeFilmlistenUrls;
import msearch.filmlisten.MSFilmlisteLesen;
import msearch.filmlisten.MSImportFilmliste;
import msearch.tool.MSConfig;

public class FilmeLaden {
    private Duration duration = new Duration(FilmeLaden.class.getSimpleName());
    private final HashSet<String> hashSet = new HashSet();
    private final ListeFilme diffListe = new ListeFilme();
    private final MSImportFilmliste msImportFilmliste;
    private final EventListenerList listeners = new EventListenerList();
    private boolean istAmLaufen = false;

    public FilmeLaden() {
        this.msImportFilmliste = new MSImportFilmliste();
        this.msImportFilmliste.addAdListener(new MSListenerFilmeLaden(){

            public synchronized void start(MSListenerFilmeLadenEvent event) {
                FilmeLaden.this.notifyStart(event);
            }

            public synchronized void progress(MSListenerFilmeLadenEvent event) {
                FilmeLaden.this.notifyProgress(event);
            }

            public synchronized void fertig(MSListenerFilmeLadenEvent event) {
                FilmeLaden.this.duration.stop("Filme laden, ende");
                FilmeLaden.this.undEnde(event);
            }
        });
    }

    public void filmeLaden(Daten daten, boolean manuell) {
        if (manuell || GuiFunktionen.getImportArtFilme() == 0) {
            DialogLeer dialog = new DialogLeer((Frame)daten.mediathekGui, true);
            dialog.init("Einstellungen zum Laden der Filme", new PanelFilmlisteLaden(daten, daten.mediathekGui));
            dialog.setVisible(true);
        } else {
            this.importFilmliste("");
        }
    }

    public void importFilmliste(String dateiUrl) {
        this.importFilmliste(dateiUrl, false);
    }

    public void importFilmliste(String dateiUrl, boolean immerNeuLaden) {
        this.duration.start("Filme laden, start");
        Log.systemMeldung("");
        Log.systemMeldung("Alte Liste erstellt am: " + Daten.listeFilme.genDate());
        Log.systemMeldung("  Anzahl Filme: " + Daten.listeFilme.size());
        Log.systemMeldung("  Anzahl Neue: " + Daten.listeFilme.countFilmNew());
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.hashSet.clear();
            this.fillHash(Daten.listeFilme);
            if (immerNeuLaden) {
                Daten.listeFilme.clear();
            }
            Daten.listeFilmeNachBlackList.clear();
            System.gc();
            if (dateiUrl.equals("")) {
                Log.systemMeldung("Filmliste laden (auto)");
                this.msImportFilmliste.filmeImportierenAuto(Daten.listeFilme, this.diffListe, Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
            } else {
                Log.systemMeldung("Filmliste laden von: " + dateiUrl);
                Daten.listeFilme.clear();
                this.msImportFilmliste.filmeImportierenDatei(dateiUrl, Daten.listeFilme, Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
            }
        }
    }

    public void updateFilmliste(String dateiUrl) {
        this.duration.start("Filme laden (Update), start");
        Log.systemMeldung("");
        Log.systemMeldung("Alte Liste erstellt am: " + Daten.listeFilme.genDate());
        Log.systemMeldung("  Anzahl Filme: " + Daten.listeFilme.size());
        Log.systemMeldung("  Anzahl Neue: " + Daten.listeFilme.countFilmNew());
        if (!this.istAmLaufen) {
            this.istAmLaufen = true;
            this.hashSet.clear();
            this.fillHash(Daten.listeFilme);
            Daten.listeFilmeNachBlackList.clear();
            System.gc();
            Log.systemMeldung("Filmliste laden von: " + dateiUrl);
            this.msImportFilmliste.filmeImportierenDatei(dateiUrl, this.diffListe, Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
        }
    }

    public void addAdListener(MSListenerFilmeLaden listener) {
        this.listeners.add(MSListenerFilmeLaden.class, listener);
    }

    public synchronized void setStop(boolean set) {
        MSConfig.setStop((boolean)set);
    }

    public String[] getSenderNamen() {
        return MSFilmeSuchen.getNamenSender();
    }

    public void updateDownloadUrlsFilmlisten(boolean akt) {
        this.msImportFilmliste.updateDownloadUrlsFilmlisten(akt);
    }

    public ListeFilmlistenUrls getDownloadUrlsFilmlisten_akt() {
        return this.msImportFilmliste.msFilmlistenSuchen.listeFilmlistenUrls_akt;
    }

    public ListeFilmlistenUrls getDownloadUrlsFilmlisten_diff() {
        return this.msImportFilmliste.msFilmlistenSuchen.listeFilmlistenUrls_diff;
    }

    public String getDownloadUrl_akt() {
        return this.msImportFilmliste.msFilmlistenSuchen.suchenAkt(new ArrayList());
    }

    private void undEnde(MSListenerFilmeLadenEvent event) {
        Log.systemMeldung("");
        if (!this.diffListe.isEmpty()) {
            Log.systemMeldung("Liste Diff gelesen am: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(new Date()));
            Log.systemMeldung("  Liste Diff erstellt am: " + this.diffListe.genDate());
            Log.systemMeldung("  Anzahl Filme: " + this.diffListe.size());
            Daten.listeFilme.updateListe(this.diffListe, true, true);
            Daten.listeFilme.metaDaten = this.diffListe.metaDaten;
            Daten.listeFilme.sort();
            this.diffListe.clear();
        } else {
            Log.systemMeldung("Liste Kompl. gelesen am: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(new Date()));
            Log.systemMeldung("  Liste Kompl erstellt am: " + Daten.listeFilme.genDate());
            Log.systemMeldung("  Anzahl Filme: " + Daten.listeFilme.size());
        }
        this.searchHash(Daten.listeFilme);
        Daten.listeFilme.themenLaden();
        Daten.listeAbo.setAboFuerFilm(Daten.listeFilme, false);
        this.istAmLaufen = false;
        if (event.fehler) {
            Log.systemMeldung("");
            Log.systemMeldung("Filmliste laden war fehlerhaft, alte Liste wird wieder geladen");
            MVMessageDialog.showMessageDialog(null, "Das Laden der Filmliste hat nicht geklappt!", "Fehler", 0);
            Daten.listeFilme.clear();
            MSConfig.setStop((boolean)false);
            new MSFilmlisteLesen().readFilmListe(Daten.getDateiFilmliste(), Daten.listeFilme, Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
            Daten.listeFilme.setFilmNew();
            Log.systemMeldung("");
        } else {
            Daten.filmlisteSpeichern();
        }
        Log.systemMeldung("");
        Log.systemMeldung("Jetzige Liste erstellt am: " + Daten.listeFilme.genDate());
        Log.systemMeldung("  Anzahl Filme: " + Daten.listeFilme.size());
        Log.systemMeldung("  Anzahl Neue:  " + Daten.listeFilme.countFilmNew());
        Log.systemMeldung("");
        MVListeFilme.checkBlacklist();
        this.notifyFertig(event);
        System.gc();
    }

    private void fillHash(ListeFilme listeFilme) {
        for (DatenFilm film : listeFilme) {
            this.hashSet.add(film.getUrlHistory());
        }
    }

    private void searchHash(ListeFilme listeFilme) {
        listeFilme.neueFilme = false;
        for (DatenFilm film : listeFilme) {
            if (!this.hashSet.contains(film.getUrlHistory())) {
                film.neuerFilm = true;
                film.arr[23] = Boolean.TRUE.toString();
                listeFilme.neueFilme = true;
                continue;
            }
            film.neuerFilm = false;
            film.arr[23] = Boolean.FALSE.toString();
        }
        this.hashSet.clear();
    }

    private void notifyStart(MSListenerFilmeLadenEvent event) {
        final MSListenerFilmeLadenEvent e = event;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                    l.start(event);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])FilmeLaden.this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                            l.start(e);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(765213654, ex);
        }
    }

    private void notifyProgress(MSListenerFilmeLadenEvent event) {
        final MSListenerFilmeLadenEvent e = event;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                    l.progress(e);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])FilmeLaden.this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                            l.progress(e);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(201020369, ex);
        }
    }

    private void notifyFertig(MSListenerFilmeLadenEvent event) {
        final MSListenerFilmeLadenEvent e = event;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                    l.fertig(e);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (MSListenerFilmeLaden l : (MSListenerFilmeLaden[])FilmeLaden.this.listeners.getListeners(MSListenerFilmeLaden.class)) {
                            l.fertig(e);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(945120303, ex);
        }
    }

    private static enum ListenerMelden {
        START,
        PROGRESS,
        FINISHED;

    }
}

