/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class NullableCheckBox
extends JComponent {
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    private JCheckBox checkBox;
    private Boolean value = Boolean.FALSE;
    private boolean nullable;
    private ItemListener checkBoxListener;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);

    public NullableCheckBox(String string) {
        final Dimension dimension = new JCheckBox().getPreferredSize();
        this.checkBox = new JCheckBox(string){

            protected void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (NullableCheckBox.this.value == null) {
                    graphics.drawRect(dimension.width / 2 - 3, dimension.height / 2, 6, 1);
                }
            }
        };
        this.checkBoxListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (NullableCheckBox.this.nullable) {
                    if (NullableCheckBox.this.getValue() == Boolean.FALSE) {
                        NullableCheckBox.this.setValue(null);
                    } else if (NullableCheckBox.this.getValue() == null) {
                        NullableCheckBox.this.setValue(Boolean.TRUE);
                    } else {
                        NullableCheckBox.this.setValue(Boolean.FALSE);
                    }
                } else {
                    NullableCheckBox.this.setValue(NullableCheckBox.this.checkBox.isSelected());
                }
            }
        };
        this.checkBox.addItemListener(this.checkBoxListener);
        this.setLayout(new GridLayout());
        this.add(this.checkBox);
    }

    public Boolean getValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Boolean bl) {
        this.value = bl;
        this.checkBox.removeItemListener(this.checkBoxListener);
        try {
            if (bl != null) {
                this.checkBox.setSelected(bl);
            } else if (this.isNullable()) {
                this.checkBox.setSelected(false);
                this.checkBox.repaint();
            } else {
                throw new IllegalArgumentException("Check box isn't nullable");
            }
            this.fireStateChanged();
        }
        finally {
            this.checkBox.addItemListener(this.checkBoxListener);
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean bl) {
        this.nullable = bl;
        if (!bl && this.getValue() == null) {
            this.setValue(Boolean.FALSE);
        }
    }

    public void setMnemonic(int n) {
        int n2 = this.checkBox.getMnemonic();
        if (n2 != n) {
            this.checkBox.setMnemonic(n);
            this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, n2, n);
        }
    }

    public int getMnemonic() {
        return this.checkBox.getMnemonic();
    }

    public void setText(String string) {
        String string2 = this.checkBox.getText();
        if (string2 != string) {
            this.checkBox.setText(string);
            this.firePropertyChange(TEXT_CHANGED_PROPERTY, string2, string);
        }
    }

    public String getText() {
        return this.checkBox.getText();
    }

    public void setToolTipText(String string) {
        this.checkBox.setToolTipText(string);
    }

    public void setEnabled(boolean bl) {
        if (this.checkBox.isEnabled() != bl) {
            this.checkBox.setEnabled(bl);
            this.firePropertyChange("enabled", !bl, bl);
        }
    }

    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private void fireStateChanged() {
        if (!this.changeListeners.isEmpty()) {
            ChangeListener[] changeListenerArray;
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (ChangeListener changeListener : changeListenerArray = this.changeListeners.toArray(new ChangeListener[this.changeListeners.size()])) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }
}

