/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.IconManager;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.viewcontroller.FurnitureController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureTable
extends JTable
implements View,
Printable {
    private ListSelectionListener tableSelectionListener;
    private boolean selectionByUser;

    public FurnitureTable(Home home, UserPreferences userPreferences) {
        this(home, userPreferences, null);
    }

    public FurnitureTable(Home home, UserPreferences userPreferences, FurnitureController furnitureController) {
        this.setModel(new FurnitureTreeTableModel(home));
        this.setColumnModel(new FurnitureTableColumnModel(home, userPreferences));
        this.updateTableColumnsWidth();
        this.updateTableSelectedFurniture(home);
        if (furnitureController != null) {
            this.addSelectionListeners(home, furnitureController);
            this.addTableHeaderListener(furnitureController);
            this.addTableColumnModelListener(furnitureController);
            this.addMouseListener(home, furnitureController);
        }
        this.addHomeListener(home);
        this.addUserPreferencesListener(userPreferences);
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
            try {
                Class<?> clazz = Class.forName("javax.swing.DropMode");
                Object object = clazz.getMethod("valueOf", String.class).invoke(null, "INSERT_ROWS");
                this.getClass().getMethod("setDropMode", clazz).invoke((Object)this, object);
                UIManager.getDefaults().remove("Table.dropLineColor");
                UIManager.getDefaults().remove("Table.dropLineShortColor");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void addSelectionListeners(final Home home, final FurnitureController furnitureController) {
        SelectionListener selectionListener = new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                FurnitureTable.this.updateTableSelectedFurniture(home);
            }
        };
        this.tableSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FurnitureTable.this.selectionByUser = true;
                int[] nArray = FurnitureTable.this.getSelectedRows();
                HashSet<HomePieceOfFurniture> hashSet = new HashSet<HomePieceOfFurniture>(nArray.length);
                List<HomePieceOfFurniture> list = home.getFurniture();
                TableModel tableModel = FurnitureTable.this.getModel();
                for (int n : nArray) {
                    hashSet.add(FurnitureTable.this.getParent(list, (HomePieceOfFurniture)tableModel.getValueAt(n, 0)));
                }
                furnitureController.setSelectedFurniture(new ArrayList<HomePieceOfFurniture>(hashSet));
                FurnitureTable.this.selectionByUser = false;
            }
        };
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
        home.addSelectionListener(selectionListener);
    }

    private void updateTableSelectedFurniture(Home home) {
        List<HomePieceOfFurniture> list = home.getFurniture();
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        listSelectionModel.removeListSelectionListener(this.tableSelectionListener);
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        Object object = new int[furnitureTreeTableModel.getRowCount()];
        int n3 = 0;
        for (Selectable selectable : home.getSelectedItems()) {
            int n4;
            if (!(selectable instanceof HomePieceOfFurniture) || (n4 = furnitureTreeTableModel.getPieceOfFurnitureIndex((HomePieceOfFurniture)selectable)) == -1) continue;
            object[n3++] = n4;
            n = Math.min(n, n4);
            n2 = Math.max(n2, n4);
            if (!(selectable instanceof HomeFurnitureGroup) || !furnitureTreeTableModel.isRowExpanded(n4)) continue;
            ++n4;
            while (n4 < furnitureTreeTableModel.getRowCount() && this.getParent(list, (HomePieceOfFurniture)furnitureTreeTableModel.getValueAt(n4, 0)) == selectable) {
                object[n3++] = n4;
                n = Math.min(n, n4);
                n2 = Math.max(n2, n4);
                ++n4;
            }
        }
        if (n3 < ((int[])object).length) {
            Object object2 = new int[n3];
            System.arraycopy(object, 0, object2, 0, n3);
            object = object2;
        }
        Arrays.sort(object);
        if (this.getSelectedRowCount() != n3 || !Arrays.equals(this.getSelectedRows(), object)) {
            this.clearSelection();
            int n5 = 0;
            while (n5 < ((int[])object).length) {
                int n6 = n5;
                while (n6 + 1 < ((int[])object).length && object[n6] + 1 == object[n6 + 1]) {
                    ++n6;
                }
                this.addRowSelectionInterval(object[n5], object[n6]);
                n5 = n6 + 1;
            }
        }
        if (!this.selectionByUser && n != Integer.MIN_VALUE) {
            this.makeRowsVisible(n, n2);
        }
        this.getSelectionModel().addListSelectionListener(this.tableSelectionListener);
    }

    private void updateTableColumnsWidth() {
        int n = this.getIntercellSpacing().width;
        TableColumnModel tableColumnModel = this.getColumnModel();
        TableModel tableModel = this.getModel();
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = this.convertColumnIndexToModel(i);
            int n4 = tableColumn.getHeaderRenderer().getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width;
            int n5 = tableModel.getRowCount();
            if (n5 > 0) {
                for (int j = 0; j < n5; ++j) {
                    n4 = Math.max(n4, tableColumn.getCellRenderer().getTableCellRendererComponent((JTable)this, (Object)tableModel.getValueAt((int)j, (int)n3), (boolean)false, (boolean)false, (int)-1, (int)i).getPreferredSize().width);
                }
            } else {
                n4 = Math.max(n4, tableColumn.getPreferredWidth());
            }
            tableColumn.setPreferredWidth(n4 + n);
            tableColumn.setWidth(n4 + n);
        }
    }

    private void addMouseListener(final Home home, final FurnitureController furnitureController) {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = FurnitureTable.this.columnAtPoint(mouseEvent.getPoint());
                int n2 = FurnitureTable.this.rowAtPoint(mouseEvent.getPoint());
                boolean bl = false;
                boolean bl2 = false;
                if (n >= 0 && n2 >= 0) {
                    Serializable serializable;
                    Object object = FurnitureTable.this.getColumnModel().getColumn(n).getIdentifier();
                    if (object == HomePieceOfFurniture.SortableProperty.VISIBLE) {
                        serializable = FurnitureTable.this.getCellRenderer(n2, n).getTableCellRendererComponent(FurnitureTable.this, FurnitureTable.this.getValueAt(n2, n), false, false, n2, n);
                        Rectangle rectangle = FurnitureTable.this.getCellRect(n2, n, false);
                        ((Component)serializable).setSize(((Component)serializable).getPreferredSize());
                        ((Component)serializable).setLocation(rectangle.x + (rectangle.width - ((Component)serializable).getWidth()) / 2, rectangle.y + (rectangle.height - ((Component)serializable).getHeight()) / 2);
                        bl = ((Component)serializable).getBounds().contains(mouseEvent.getPoint());
                    } else if (object == HomePieceOfFurniture.SortableProperty.NAME && FurnitureTable.this.getValueAt(n2, n) instanceof HomeFurnitureGroup) {
                        serializable = ((TreeTableNameCellRenderer)FurnitureTable.this.getCellRenderer(n2, n)).getExpandedStateBounds(FurnitureTable.this, n2, n);
                        bl2 = ((Rectangle)serializable).contains(mouseEvent.getPoint());
                    }
                    if (bl) {
                        furnitureController.toggleSelectedFurnitureVisibility();
                    } else if (bl2) {
                        serializable = (FurnitureTreeTableModel)FurnitureTable.this.getModel();
                        ((FurnitureTreeTableModel)serializable).toggleRowExpandedState(n2);
                        furnitureController.setSelectedFurniture(Arrays.asList(FurnitureTable.this.getParent(home.getFurniture(), (HomePieceOfFurniture)((FurnitureTreeTableModel)serializable).getValueAt(n2, 0))));
                    } else if (mouseEvent.getClickCount() == 2) {
                        furnitureController.modifySelectedFurniture();
                    }
                }
            }
        });
    }

    private HomePieceOfFurniture getParent(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            if (homePieceOfFurniture2 != homePieceOfFurniture && (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || this.getParent(((HomeFurnitureGroup)homePieceOfFurniture2).getFurniture(), homePieceOfFurniture) == null)) continue;
            return homePieceOfFurniture2;
        }
        return null;
    }

    private void addUserPreferencesListener(UserPreferences userPreferences) {
        userPreferences.addPropertyChangeListener(UserPreferences.Property.UNIT, new UserPreferencesChangeListener(this));
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new UserPreferencesChangeListener(this));
    }

    private void addHomeListener(final Home home) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((FurnitureTreeTableModel)FurnitureTable.this.getModel()).filterAndSortFurniture();
                FurnitureTable.this.updateTableSelectedFurniture(home);
                FurnitureTable.this.getTableHeader().repaint();
            }
        };
        home.addPropertyChangeListener(Home.Property.FURNITURE_SORTED_PROPERTY, propertyChangeListener);
        home.addPropertyChangeListener(Home.Property.FURNITURE_DESCENDING_SORTED, propertyChangeListener);
        final PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ((FurnitureTreeTableModel)FurnitureTable.this.getModel()).filterAndSortFurniture();
                FurnitureTable.this.updateTableSelectedFurniture(home);
            }
        };
        for (HomePieceOfFurniture cloneable : home.getFurniture()) {
            cloneable.addPropertyChangeListener(propertyChangeListener2);
        }
        home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                } else {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                }
            }
        });
        for (Level level : home.getLevels()) {
            level.addPropertyChangeListener(propertyChangeListener2);
        }
        home.addLevelsListener(new CollectionListener<Level>(){

            @Override
            public void collectionChanged(CollectionEvent<Level> collectionEvent) {
                if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                    collectionEvent.getItem().addPropertyChangeListener(propertyChangeListener2);
                } else {
                    collectionEvent.getItem().removePropertyChangeListener(propertyChangeListener2);
                }
            }
        });
    }

    private void makeRowsVisible(int n, int n2) {
        Rectangle rectangle = this.getCellRect(n, 0, true);
        if (n != n2) {
            rectangle = rectangle.union(this.getCellRect(n2, 0, true));
        }
        if (this.getAutoResizeMode() == 0) {
            int n3 = this.getColumnCount() - 1;
            rectangle = rectangle.union(this.getCellRect(n, n3, true));
            if (n != n2) {
                rectangle = rectangle.union(this.getCellRect(n2, n3, true));
            }
        }
        this.scrollRectToVisible(rectangle);
    }

    private void addTableHeaderListener(final FurnitureController furnitureController) {
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = FurnitureTable.this.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                Object object = FurnitureTable.this.getColumnModel().getColumn(n).getIdentifier();
                if (object instanceof HomePieceOfFurniture.SortableProperty) {
                    furnitureController.sortFurniture((HomePieceOfFurniture.SortableProperty)((Object)object));
                }
            }
        });
    }

    private void addTableColumnModelListener(final FurnitureController furnitureController) {
        this.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                FurnitureTable.this.getColumnModel().removeColumnModelListener(this);
                ArrayList<HomePieceOfFurniture.SortableProperty> arrayList = new ArrayList<HomePieceOfFurniture.SortableProperty>();
                Enumeration<TableColumn> enumeration = FurnitureTable.this.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    Object object = enumeration.nextElement().getIdentifier();
                    if (!(object instanceof HomePieceOfFurniture.SortableProperty)) continue;
                    arrayList.add((HomePieceOfFurniture.SortableProperty)((Object)object));
                }
                furnitureController.setFurnitureVisibleProperties(arrayList);
                FurnitureTable.this.getColumnModel().addColumnModelListener(this);
            }

            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
            }
        });
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        DefaultTableColumnModel defaultTableColumnModel = new DefaultTableColumnModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(0);
        TableCellRenderer tableCellRenderer = new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JLabel jLabel = (JLabel)defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                jLabel.setIcon(null);
                jLabel.setBackground(Color.LIGHT_GRAY);
                jLabel.setForeground(Color.BLACK);
                jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), jLabel.getBorder()));
                return jLabel;
            }
        };
        int n2 = tableColumnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            final TableColumn tableColumn = tableColumnModel.getColumn(i);
            TableColumn tableColumn2 = new TableColumn();
            tableColumn2.setIdentifier(tableColumn.getIdentifier());
            tableColumn2.setHeaderValue(tableColumn.getHeaderValue());
            TableCellRenderer tableCellRenderer2 = new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
                    Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (component instanceof JCheckBox) {
                        component = defaultTableCellRenderer.getTableCellRendererComponent(jTable, ((JCheckBox)component).isSelected() ? "x" : "", false, false, n, n2);
                    }
                    component.setBackground(Color.WHITE);
                    component.setForeground(Color.BLACK);
                    return component;
                }
            };
            tableColumn2.setCellRenderer(tableCellRenderer2);
            tableColumn2.setHeaderRenderer(tableCellRenderer);
            defaultTableColumnModel.addColumn(tableColumn2);
        }
        return this.print(graphics, pageFormat, n, defaultTableColumnModel, Color.BLACK);
    }

    private int print(final Graphics graphics, final PageFormat pageFormat, final int n, final TableColumnModel tableColumnModel, final Color color) throws PrinterException {
        if (EventQueue.isDispatchThread()) {
            TableColumnModel tableColumnModel2 = this.getColumnModel();
            Color color2 = this.getGridColor();
            this.setColumnModel(tableColumnModel);
            this.updateTableColumnsWidth();
            this.setGridColor(color);
            Printable printable = this.getPrintable(JTable.PrintMode.FIT_WIDTH, null, null);
            int n2 = printable.print(graphics, pageFormat, n);
            this.setColumnModel(tableColumnModel2);
            this.setGridColor(color2);
            return n2;
        }
        class RunnableContext {
            int pageExists;
            PrinterException exception;

            RunnableContext() {
            }
        }
        final RunnableContext runnableContext = new RunnableContext();
        try {
            EventQueue.invokeAndWait(new Runnable(){
                {
                }

                public void run() {
                    try {
                        runnableContext.pageExists = FurnitureTable.this.print(graphics, pageFormat, n, tableColumnModel, color);
                    }
                    catch (PrinterException printerException) {
                        runnableContext.exception = printerException;
                    }
                }
            });
            if (runnableContext.exception != null) {
                throw runnableContext.exception;
            }
            return runnableContext.pageExists;
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedPrinterException("Print interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getCause();
            }
            throw (Error)invocationTargetException.getCause();
        }
    }

    public void exportToCSV(Writer writer, char c) throws IOException {
        this.exportHeaderToCSV(writer, c);
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            this.exportRowToCSV(writer, c, i);
        }
    }

    private void exportHeaderToCSV(Writer writer, char c) throws IOException {
        int n = this.columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                writer.write(c);
            }
            writer.write(String.valueOf(this.columnModel.getColumn(i).getHeaderValue()));
        }
        writer.write(System.getProperty("line.separator"));
    }

    private void exportRowToCSV(Writer writer, char c, int n) throws IOException {
        TableModel tableModel = this.getModel();
        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)tableModel.getValueAt(n, 0);
        int n2 = this.columnModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            TableColumn tableColumn;
            Object object2;
            if (i > 0) {
                writer.write(c);
            }
            if ((object2 = (tableColumn = this.columnModel.getColumn(i)).getIdentifier()) instanceof HomePieceOfFurniture.SortableProperty) {
                switch ((HomePieceOfFurniture.SortableProperty)((Object)object2)) {
                    case CATALOG_ID: {
                        object = homePieceOfFurniture.getCatalogId();
                        writer.write((String)(object != null ? object : ""));
                        break;
                    }
                    case NAME: {
                        writer.write(homePieceOfFurniture.getName());
                        break;
                    }
                    case LEVEL: {
                        writer.write(homePieceOfFurniture.getLevel() != null ? homePieceOfFurniture.getLevel().getName() : "");
                        break;
                    }
                    case COLOR: {
                        if (homePieceOfFurniture.getColor() == null) break;
                        writer.write("#" + Integer.toHexString(homePieceOfFurniture.getColor()).substring(2));
                        break;
                    }
                    case TEXTURE: {
                        if (homePieceOfFurniture.getTexture() != null) {
                            writer.write(homePieceOfFurniture.getTexture().getName());
                        }
                    }
                    case WIDTH: 
                    case DEPTH: 
                    case HEIGHT: 
                    case X: 
                    case Y: 
                    case ELEVATION: 
                    case ANGLE: 
                    case PRICE: 
                    case VALUE_ADDED_TAX_PERCENTAGE: 
                    case VALUE_ADDED_TAX: 
                    case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                        writer.write(((JLabel)tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n, i)).getText());
                        break;
                    }
                    case MOVABLE: {
                        writer.write(String.valueOf(homePieceOfFurniture.isMovable()));
                        break;
                    }
                    case DOOR_OR_WINDOW: {
                        writer.write(String.valueOf(homePieceOfFurniture.isDoorOrWindow()));
                        break;
                    }
                    case VISIBLE: {
                        writer.write(String.valueOf(homePieceOfFurniture.isVisible()));
                    }
                }
                continue;
            }
            object = tableColumn.getCellRenderer().getTableCellRendererComponent(this, homePieceOfFurniture, false, false, n, i);
            if (object instanceof JLabel) {
                writer.write(((JLabel)object).getText());
                continue;
            }
            writer.write(String.valueOf(tableModel.getValueAt(n, i)));
        }
        writer.write(System.getProperty("line.separator"));
    }

    public String getClipboardCSV() {
        StringWriter stringWriter = new StringWriter();
        try {
            this.exportHeaderToCSV(stringWriter, '\t');
            for (int n : this.getSelectedRows()) {
                this.exportRowToCSV(stringWriter, '\t', n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void setFurnitureFilter(FurnitureFilter furnitureFilter) {
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        furnitureTreeTableModel.setFurnitureFilter(furnitureFilter);
    }

    public FurnitureFilter getFurnitureFilter() {
        FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)this.getModel();
        return furnitureTreeTableModel.getFurnitureFilter();
    }

    public static interface FurnitureFilter {
        public boolean include(Home var1, HomePieceOfFurniture var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureTreeTableModel
    extends AbstractTableModel
    implements TreeModel {
        private Home home;
        private List<HomePieceOfFurniture> filteredAndSortedFurniture;
        private FurnitureFilter furnitureFilter;
        private Set<HomeFurnitureGroup> expandedGroups;
        private List<TreeModelListener> treeModelListeners;
        private Map<Object, List<HomePieceOfFurniture>> childFurnitureCache;

        public FurnitureTreeTableModel(Home home) {
            this.home = home;
            this.expandedGroups = new HashSet<HomeFurnitureGroup>();
            this.treeModelListeners = new ArrayList<TreeModelListener>();
            this.childFurnitureCache = new HashMap<Object, List<HomePieceOfFurniture>>();
            this.addHomeListener(home);
            this.filterAndSortFurniture();
        }

        private void addHomeListener(final Home home) {
            home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

                @Override
                public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                    HomePieceOfFurniture homePieceOfFurniture = collectionEvent.getItem();
                    int n = collectionEvent.getIndex();
                    switch (collectionEvent.getType()) {
                        case ADD: {
                            if (FurnitureTreeTableModel.this.expandedGroups.isEmpty()) {
                                int n2 = this.getPieceOfFurnitureInsertionIndex(homePieceOfFurniture, home, n);
                                if (n2 == -1) break;
                                FurnitureTreeTableModel.this.filteredAndSortedFurniture.add(n2, homePieceOfFurniture);
                                FurnitureTreeTableModel.this.fireTableRowsInserted(n2, n2);
                                FurnitureTreeTableModel.this.fireTreeModelChanged();
                                break;
                            }
                            FurnitureTreeTableModel.this.filterAndSortFurniture();
                            break;
                        }
                        case DELETE: {
                            int n3 = this.getPieceOfFurnitureDeletionIndex(homePieceOfFurniture, home, n);
                            if (n3 == -1) break;
                            if (FurnitureTreeTableModel.this.expandedGroups.contains(homePieceOfFurniture)) {
                                FurnitureTreeTableModel.this.filterAndSortFurniture();
                                break;
                            }
                            FurnitureTreeTableModel.this.filteredAndSortedFurniture.remove(n3);
                            FurnitureTreeTableModel.this.fireTableRowsDeleted(n3, n3);
                            FurnitureTreeTableModel.this.fireTreeModelChanged();
                        }
                    }
                }

                private int getPieceOfFurnitureInsertionIndex(HomePieceOfFurniture homePieceOfFurniture, Home home2, int n) {
                    int n2;
                    if (FurnitureTreeTableModel.this.furnitureFilter == null) {
                        if (home2.getFurnitureSortedProperty() == null) {
                            return n;
                        }
                    } else {
                        if (!FurnitureTreeTableModel.this.furnitureFilter.include(home2, homePieceOfFurniture)) {
                            return -1;
                        }
                        if (home2.getFurnitureSortedProperty() == null) {
                            int n3;
                            List<HomePieceOfFurniture> list = home2.getFurniture();
                            for (n3 = n - 1; n3 > 0 && !FurnitureTreeTableModel.this.furnitureFilter.include(home2, list.get(n3)); --n3) {
                            }
                            if (FurnitureTreeTableModel.this.filteredAndSortedFurniture.size() == 0) {
                                return 0;
                            }
                            return FurnitureTreeTableModel.this.getPieceOfFurnitureIndex(list.get(n3)) + 1;
                        }
                    }
                    if ((n2 = Collections.binarySearch(FurnitureTreeTableModel.this.filteredAndSortedFurniture, homePieceOfFurniture, FurnitureTreeTableModel.this.getFurnitureComparator(home2))) >= 0) {
                        return n2;
                    }
                    return -(n2 + 1);
                }

                private int getPieceOfFurnitureDeletionIndex(HomePieceOfFurniture homePieceOfFurniture, Home home2, int n) {
                    if (FurnitureTreeTableModel.this.furnitureFilter == null && home2.getFurnitureSortedProperty() == null) {
                        return n;
                    }
                    return FurnitureTreeTableModel.this.getPieceOfFurnitureIndex(homePieceOfFurniture);
                }
            });
            home.addPropertyChangeListener(Home.Property.FURNITURE_VISIBLE_PROPERTIES, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (!home.getFurnitureVisibleProperties().contains((Object)HomePieceOfFurniture.SortableProperty.NAME)) {
                        FurnitureTreeTableModel.this.expandedGroups.clear();
                        FurnitureTreeTableModel.this.filterAndSortFurniture();
                    }
                }
            });
        }

        @Override
        public String getColumnName(int n) {
            return null;
        }

        @Override
        public int getColumnCount() {
            return 0;
        }

        @Override
        public int getRowCount() {
            return this.filteredAndSortedFurniture.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.filteredAndSortedFurniture.get(n);
        }

        public int getPieceOfFurnitureIndex(HomePieceOfFurniture homePieceOfFurniture) {
            return this.filteredAndSortedFurniture.indexOf(homePieceOfFurniture);
        }

        public void filterAndSortFurniture() {
            int n = this.filteredAndSortedFurniture != null ? this.filteredAndSortedFurniture.size() : 0;
            this.filteredAndSortedFurniture = this.getFilteredAndSortedFurniture(this.home.getFurniture(), true);
            if (n != this.filteredAndSortedFurniture.size()) {
                this.fireTableDataChanged();
            } else {
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
            this.fireTreeModelChanged();
        }

        private List<HomePieceOfFurniture> getFilteredAndSortedFurniture(List<HomePieceOfFurniture> list, boolean bl) {
            ArrayList<HomePieceOfFurniture> arrayList;
            if (this.furnitureFilter == null) {
                arrayList = new ArrayList<HomePieceOfFurniture>(list);
            } else {
                arrayList = new ArrayList(list.size());
                for (HomePieceOfFurniture homePieceOfFurniture : list) {
                    if (!this.furnitureFilter.include(this.home, homePieceOfFurniture)) continue;
                    arrayList.add(homePieceOfFurniture);
                }
            }
            if (this.home.getFurnitureSortedProperty() != null) {
                Comparator<HomePieceOfFurniture> comparator = this.getFurnitureComparator(this.home);
                Collections.sort(arrayList, comparator);
            }
            if (bl) {
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    HomePieceOfFurniture homePieceOfFurniture;
                    homePieceOfFurniture = (HomePieceOfFurniture)arrayList.get(i);
                    if (!(homePieceOfFurniture instanceof HomeFurnitureGroup) || !this.expandedGroups.contains(homePieceOfFurniture)) continue;
                    arrayList.addAll(i + 1, this.getFilteredAndSortedFurniture(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture(), true));
                }
            }
            return arrayList;
        }

        private Comparator<HomePieceOfFurniture> getFurnitureComparator(Home home) {
            Comparator<HomePieceOfFurniture> comparator = HomePieceOfFurniture.getFurnitureComparator(home.getFurnitureSortedProperty());
            if (home.isFurnitureDescendingSorted()) {
                comparator = Collections.reverseOrder(comparator);
            }
            return comparator;
        }

        public void setFurnitureFilter(FurnitureFilter furnitureFilter) {
            this.furnitureFilter = furnitureFilter;
            this.filterAndSortFurniture();
        }

        public FurnitureFilter getFurnitureFilter() {
            return this.furnitureFilter;
        }

        @Override
        public Object getRoot() {
            return this.home;
        }

        @Override
        public Object getChild(Object object, int n) {
            return this.getChildFurniture(object).get(n);
        }

        @Override
        public int getChildCount(Object object) {
            return this.getChildFurniture(object).size();
        }

        @Override
        public int getIndexOfChild(Object object, Object object2) {
            return this.getChildFurniture(object).indexOf(object2);
        }

        private List<HomePieceOfFurniture> getChildFurniture(Object object) {
            List<HomePieceOfFurniture> list = this.childFurnitureCache.get(object);
            if (list == null) {
                list = object instanceof HomeFurnitureGroup ? ((HomeFurnitureGroup)object).getFurniture() : this.home.getFurniture();
                list = this.getFilteredAndSortedFurniture(list, false);
                this.childFurnitureCache.put(object, list);
            }
            return list;
        }

        @Override
        public boolean isLeaf(Object object) {
            return object instanceof HomePieceOfFurniture && !(object instanceof HomeFurnitureGroup);
        }

        @Override
        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        @Override
        public void addTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.add(treeModelListener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            this.treeModelListeners.remove(treeModelListener);
        }

        private void fireTreeModelChanged() {
            this.childFurnitureCache.clear();
            for (TreeModelListener treeModelListener : this.treeModelListeners) {
                treeModelListener.treeStructureChanged(new TreeModelEvent((Object)this, new TreePath(this.home)));
            }
        }

        public boolean isRowExpanded(int n) {
            return this.expandedGroups.contains(this.filteredAndSortedFurniture.get(n));
        }

        public void toggleRowExpandedState(int n) {
            HomePieceOfFurniture homePieceOfFurniture = this.filteredAndSortedFurniture.get(n);
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                if (this.expandedGroups.contains(homePieceOfFurniture)) {
                    this.expandedGroups.remove((HomeFurnitureGroup)homePieceOfFurniture);
                } else {
                    this.expandedGroups.add((HomeFurnitureGroup)homePieceOfFurniture);
                }
                this.filterAndSortFurniture();
            }
        }
    }

    private static class TreeTableNameCellRenderer
    implements TableCellRenderer {
        private static final ResourceURLContent GROUP_ICON_CONTENT = new ResourceURLContent(FurnitureTable.class, "resources/groupIcon.png");
        private DefaultTableCellRenderer defaultRenderer;
        private JTree tree;
        private int renderedRow;

        private TreeTableNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3 = false;
            for (int i = 0; i < jTable.getRowCount(); ++i) {
                if (!(jTable.getValueAt(i, 0) instanceof HomeFurnitureGroup)) continue;
                bl3 = true;
                break;
            }
            if (bl3) {
                this.prepareTree(jTable);
                if (bl) {
                    this.tree.setBackground(jTable.getSelectionBackground());
                    this.tree.setSelectionRow(n);
                } else {
                    this.tree.setBackground(jTable.getBackground());
                    this.tree.clearSelection();
                }
                this.renderedRow = n;
                return this.tree;
            }
            if (this.defaultRenderer == null) {
                this.defaultRenderer = new DefaultTableCellRenderer();
            }
            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
            JLabel jLabel = (JLabel)this.defaultRenderer.getTableCellRendererComponent(jTable, homePieceOfFurniture.getName(), bl, bl2, n, n2);
            Content content = homePieceOfFurniture instanceof HomeFurnitureGroup ? GROUP_ICON_CONTENT : homePieceOfFurniture.getIcon();
            jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - jTable.getRowMargin(), jTable));
            return jLabel;
        }

        private void prepareTree(final JTable jTable) {
            if (this.tree == null) {
                UIManager.put("Tree.rendererFillBackground", Boolean.TRUE);
                final DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer(){

                    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                        if (object instanceof HomePieceOfFurniture) {
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            super.getTreeCellRendererComponent(jTree, homePieceOfFurniture.getName(), bl, bl2, bl3, n, false);
                            Content content = homePieceOfFurniture instanceof HomeFurnitureGroup ? GROUP_ICON_CONTENT : homePieceOfFurniture.getIcon();
                            this.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - jTable.getRowMargin(), jTable));
                            this.setBackgroundSelectionColor(jTable.getSelectionBackground());
                            this.setBackgroundNonSelectionColor(jTable.getBackground());
                            this.setTextSelectionColor(jTable.getSelectionForeground());
                            this.setTextNonSelectionColor(jTable.getForeground());
                        }
                        return this;
                    }

                    public void setBounds(int n, int n2, int n3, int n4) {
                        super.setBounds(n, n2, TreeTableNameCellRenderer.this.tree.getWidth() - n, n4);
                    }
                };
                final FurnitureTreeTableModel furnitureTreeTableModel = (FurnitureTreeTableModel)jTable.getModel();
                this.tree = new JTree(furnitureTreeTableModel){
                    boolean drawing;
                    {
                        super(treeModel);
                        this.drawing = false;
                    }

                    public void setBounds(int n, int n2, int n3, int n4) {
                        super.setBounds(n, 0, n3, jTable.getHeight());
                    }

                    public void paint(Graphics graphics) {
                        if (jTable.getRowMargin() > 0) {
                            Rectangle rectangle = graphics.getClipBounds();
                            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, this.getRowHeight() - jTable.getRowMargin());
                        }
                        graphics.translate(0, -TreeTableNameCellRenderer.this.renderedRow * this.getRowHeight());
                        this.drawing = true;
                        super.paint(graphics);
                        this.drawing = false;
                    }

                    public TreeCellRenderer getCellRenderer() {
                        return defaultTreeCellRenderer;
                    }

                    public boolean hasFocus() {
                        if (this.drawing && UIManager.getLookAndFeel() instanceof SynthLookAndFeel) {
                            return true;
                        }
                        return super.hasFocus();
                    }
                };
                this.tree.setRowHeight(jTable.getRowHeight());
                this.tree.setRootVisible(false);
                this.tree.setShowsRootHandles(true);
                furnitureTreeTableModel.addTreeModelListener(new TreeModelListener(){

                    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                        for (int i = 0; i < furnitureTreeTableModel.getRowCount(); ++i) {
                            TreePath treePath;
                            if (!(furnitureTreeTableModel.getValueAt(i, 0) instanceof HomeFurnitureGroup)) continue;
                            if (furnitureTreeTableModel.isRowExpanded(i)) {
                                treePath = TreeTableNameCellRenderer.this.tree.getPathForRow(i);
                                if (!TreeTableNameCellRenderer.this.tree.isCollapsed(treePath)) continue;
                                TreeTableNameCellRenderer.this.tree.expandPath(treePath);
                                continue;
                            }
                            treePath = TreeTableNameCellRenderer.this.tree.getPathForRow(i);
                            if (!TreeTableNameCellRenderer.this.tree.isExpanded(treePath)) continue;
                            TreeTableNameCellRenderer.this.tree.collapsePath(treePath);
                        }
                    }

                    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                    }

                    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                    }

                    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                    }
                });
            }
        }

        public Rectangle getExpandedStateBounds(JTable jTable, int n, int n2) {
            this.prepareTree(jTable);
            Rectangle rectangle = jTable.getCellRect(n, n2, true);
            Rectangle rectangle2 = this.tree.getPathBounds(this.tree.getPathForRow(n));
            rectangle.width = rectangle2.x;
            return rectangle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureTableColumnModel
    extends DefaultTableColumnModel {
        private Map<HomePieceOfFurniture.SortableProperty, TableColumn> availableColumns;

        public FurnitureTableColumnModel(Home home, UserPreferences userPreferences) {
            this.createAvailableColumns(home, userPreferences);
            this.addHomeListener(home);
            this.addLanguageListener(userPreferences);
            this.updateModelColumns(home.getFurnitureVisibleProperties());
        }

        private void createAvailableColumns(Home home, UserPreferences userPreferences) {
            this.availableColumns = new HashMap<HomePieceOfFurniture.SortableProperty, TableColumn>();
            TableCellRenderer tableCellRenderer = this.getHeaderRenderer(home);
            for (HomePieceOfFurniture.SortableProperty sortableProperty : HomePieceOfFurniture.SortableProperty.values()) {
                TableColumn tableColumn = new TableColumn();
                tableColumn.setIdentifier((Object)sortableProperty);
                tableColumn.setHeaderValue(this.getColumnName(sortableProperty, userPreferences));
                tableColumn.setCellRenderer(this.getColumnRenderer(sortableProperty, userPreferences));
                tableColumn.setPreferredWidth(this.getColumnPreferredWidth(sortableProperty));
                tableColumn.setHeaderRenderer(tableCellRenderer);
                this.availableColumns.put(sortableProperty, tableColumn);
            }
        }

        private void addHomeListener(final Home home) {
            home.addPropertyChangeListener(Home.Property.FURNITURE_VISIBLE_PROPERTIES, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FurnitureTableColumnModel.this.updateModelColumns(home.getFurnitureVisibleProperties());
                }
            });
        }

        private void addLanguageListener(UserPreferences userPreferences) {
            userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
        }

        private void updateModelColumns(List<HomePieceOfFurniture.SortableProperty> list) {
            Object object;
            for (int i = this.tableColumns.size() - 1; i >= 0; --i) {
                TableColumn object2 = (TableColumn)this.tableColumns.get(i);
                object = object2.getIdentifier();
                if (!(object instanceof HomePieceOfFurniture.SortableProperty) || list.contains(object)) continue;
                this.removeColumn(object2);
            }
            for (HomePieceOfFurniture.SortableProperty sortableProperty : list) {
                object = this.availableColumns.get((Object)sortableProperty);
                if (this.tableColumns.contains(object)) continue;
                this.addColumn((TableColumn)object);
            }
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                object = this.availableColumns.get((Object)list.get(i));
                int n2 = this.tableColumns.indexOf(object);
                if (n2 == i) continue;
                this.moveColumn(n2, i);
            }
        }

        private String getColumnName(HomePieceOfFurniture.SortableProperty sortableProperty, UserPreferences userPreferences) {
            switch (sortableProperty) {
                case CATALOG_ID: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "catalogIdColumn", new Object[0]);
                }
                case NAME: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "nameColumn", new Object[0]);
                }
                case WIDTH: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "widthColumn", new Object[0]);
                }
                case DEPTH: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "depthColumn", new Object[0]);
                }
                case HEIGHT: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "heightColumn", new Object[0]);
                }
                case X: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "xColumn", new Object[0]);
                }
                case Y: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "yColumn", new Object[0]);
                }
                case ELEVATION: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "elevationColumn", new Object[0]);
                }
                case ANGLE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "angleColumn", new Object[0]);
                }
                case LEVEL: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "levelColumn", new Object[0]);
                }
                case COLOR: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "colorColumn", new Object[0]);
                }
                case TEXTURE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "textureColumn", new Object[0]);
                }
                case MOVABLE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "movableColumn", new Object[0]);
                }
                case DOOR_OR_WINDOW: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "doorOrWindowColumn", new Object[0]);
                }
                case VISIBLE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "visibleColumn", new Object[0]);
                }
                case PRICE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "priceColumn", new Object[0]);
                }
                case VALUE_ADDED_TAX_PERCENTAGE: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "valueAddedTaxPercentageColumn", new Object[0]);
                }
                case VALUE_ADDED_TAX: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "valueAddedTaxColumn", new Object[0]);
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return userPreferences.getLocalizedString(FurnitureTable.class, "priceValueAddedTaxIncludedColumn", new Object[0]);
                }
            }
            throw new IllegalArgumentException("Unknown column name " + (Object)((Object)sortableProperty));
        }

        private int getColumnPreferredWidth(HomePieceOfFurniture.SortableProperty sortableProperty) {
            switch (sortableProperty) {
                case CATALOG_ID: 
                case NAME: {
                    return 120;
                }
                case WIDTH: 
                case DEPTH: 
                case HEIGHT: 
                case X: 
                case Y: 
                case ELEVATION: {
                    return 50;
                }
                case ANGLE: {
                    return 35;
                }
                case LEVEL: {
                    return 70;
                }
                case COLOR: 
                case TEXTURE: {
                    return 30;
                }
                case MOVABLE: 
                case DOOR_OR_WINDOW: 
                case VISIBLE: {
                    return 20;
                }
                case PRICE: 
                case VALUE_ADDED_TAX_PERCENTAGE: 
                case VALUE_ADDED_TAX: 
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return 70;
                }
            }
            throw new IllegalArgumentException("Unknown column name " + (Object)((Object)sortableProperty));
        }

        private TableCellRenderer getColumnRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, UserPreferences userPreferences) {
            switch (sortableProperty) {
                case CATALOG_ID: {
                    return this.getCatalogIdRenderer();
                }
                case NAME: {
                    return this.getNameWithIconRenderer();
                }
                case WIDTH: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.WIDTH, userPreferences);
                }
                case DEPTH: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.DEPTH, userPreferences);
                }
                case HEIGHT: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.HEIGHT, userPreferences);
                }
                case X: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.X, userPreferences);
                }
                case Y: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.Y, userPreferences);
                }
                case ELEVATION: {
                    return this.getSizeRenderer(HomePieceOfFurniture.SortableProperty.ELEVATION, userPreferences);
                }
                case ANGLE: {
                    return this.getAngleRenderer();
                }
                case LEVEL: {
                    return this.getLevelRenderer();
                }
                case COLOR: {
                    return this.getColorRenderer();
                }
                case TEXTURE: {
                    return this.getTextureRenderer();
                }
                case MOVABLE: {
                    return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.MOVABLE);
                }
                case DOOR_OR_WINDOW: {
                    return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW);
                }
                case VISIBLE: {
                    return this.getBooleanRenderer(HomePieceOfFurniture.SortableProperty.VISIBLE);
                }
                case PRICE: {
                    return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.PRICE, userPreferences);
                }
                case VALUE_ADDED_TAX_PERCENTAGE: {
                    return this.getValueAddedTaxPercentageRenderer();
                }
                case VALUE_ADDED_TAX: {
                    return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, userPreferences);
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return this.getPriceRenderer(HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED, userPreferences);
                }
            }
            throw new IllegalArgumentException("Unknown column name " + (Object)((Object)sortableProperty));
        }

        private TableCellRenderer getCatalogIdRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    return super.getTableCellRendererComponent(jTable, homePieceOfFurniture.getCatalogId(), bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getLevelRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    Level level = homePieceOfFurniture.getLevel();
                    return super.getTableCellRendererComponent(jTable, level != null ? level.getName() : "", bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getNameWithIconRenderer() {
            return new TreeTableNameCellRenderer();
        }

        private TableCellRenderer getSizeRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, final UserPreferences userPreferences) {
            switch (sortableProperty) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class SizeRenderer
                extends DefaultTableCellRenderer {
                    final /* synthetic */ UserPreferences val$preferences;

                    SizeRenderer() {
                        this.val$preferences = userPreferences;
                    }

                    @Override
                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        object = this.val$preferences.getLengthUnit().getFormat().format((Float)object);
                        this.setHorizontalAlignment(4);
                        return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    }
                }
                case WIDTH: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getWidth()), bl, bl2, n, n2);
                        }
                    };
                }
                case DEPTH: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getDepth()), bl, bl2, n, n2);
                        }
                    };
                }
                case HEIGHT: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getHeight()), bl, bl2, n, n2);
                        }
                    };
                }
                case X: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getX()), bl, bl2, n, n2);
                        }
                    };
                }
                case Y: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getY()), bl, bl2, n, n2);
                        }
                    };
                }
                case ELEVATION: {
                    return new SizeRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, Float.valueOf(((HomePieceOfFurniture)object).getElevation()), bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a size column");
        }

        private TableCellRenderer getPriceRenderer(HomePieceOfFurniture.SortableProperty sortableProperty, final UserPreferences userPreferences) {
            switch (sortableProperty) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class PriceRenderer
                extends DefaultTableCellRenderer {
                    final /* synthetic */ UserPreferences val$preferences;

                    PriceRenderer() {
                        this.val$preferences = userPreferences;
                    }

                    public Component getTableCellRendererComponent(JTable jTable, BigDecimal bigDecimal, String string, boolean bl, boolean bl2, int n, int n2) {
                        String string2;
                        String string3 = this.val$preferences.getCurrency();
                        if (bigDecimal != null && string3 != null) {
                            NumberFormat numberFormat = DecimalFormat.getCurrencyInstance();
                            numberFormat.setCurrency(Currency.getInstance(string != null ? string : string3));
                            string2 = numberFormat.format(bigDecimal);
                        } else {
                            string2 = "";
                        }
                        this.setHorizontalAlignment(4);
                        return super.getTableCellRendererComponent(jTable, string2, bl, bl2, n, n2);
                    }
                }
                case PRICE: {
                    return new PriceRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            return super.getTableCellRendererComponent(jTable, homePieceOfFurniture.getPrice(), homePieceOfFurniture.getCurrency(), bl, bl2, n, n2);
                        }
                    };
                }
                case VALUE_ADDED_TAX: {
                    return new PriceRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            return super.getTableCellRendererComponent(jTable, homePieceOfFurniture.getValueAddedTax(), homePieceOfFurniture.getCurrency(), bl, bl2, n, n2);
                        }
                    };
                }
                case PRICE_VALUE_ADDED_TAX_INCLUDED: {
                    return new PriceRenderer(){
                        {
                            super(FurnitureTableColumnModel.this, userPreferences2);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                            return super.getTableCellRendererComponent(jTable, homePieceOfFurniture.getPriceValueAddedTaxIncluded(), homePieceOfFurniture.getCurrency(), bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a price column");
        }

        private TableCellRenderer getAngleRenderer() {
            return new DefaultTableCellRenderer(){
                private TableCellRenderer integerRenderer;

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.integerRenderer == null) {
                        this.integerRenderer = jTable.getDefaultRenderer(Integer.class);
                    }
                    int n3 = (int)(Math.round(Math.toDegrees(((HomePieceOfFurniture)object).getAngle()) + 360.0) % 360L);
                    return this.integerRenderer.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getValueAddedTaxPercentageRenderer() {
            return new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    BigDecimal bigDecimal = ((HomePieceOfFurniture)object).getValueAddedTaxPercentage();
                    if (bigDecimal != null) {
                        NumberFormat numberFormat = DecimalFormat.getPercentInstance();
                        numberFormat.setMinimumFractionDigits(bigDecimal.scale() - 2);
                        object = numberFormat.format(bigDecimal);
                    } else {
                        object = "";
                    }
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                }
            };
        }

        private TableCellRenderer getColorRenderer() {
            return new DefaultTableCellRenderer(){
                private Icon squareIcon = new Icon(){

                    public int getIconHeight() {
                        return this.getFont().getSize();
                    }

                    public int getIconWidth() {
                        return this.getIconHeight();
                    }

                    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                        int n3 = this.getIconHeight();
                        graphics.setColor(component.getForeground());
                        graphics.fillRect(n + 2, n2 + 2, n3 - 3, n3 - 3);
                        graphics.setColor(component.getParent().getParent().getForeground());
                        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n3 - 2);
                    }
                };

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Integer n3 = ((HomePieceOfFurniture)object).getColor();
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, n3, bl, bl2, n, n2);
                    if (n3 != null) {
                        jLabel.setText(null);
                        jLabel.setIcon(this.squareIcon);
                        jLabel.setForeground(new Color(n3));
                    } else {
                        jLabel.setText("-");
                        jLabel.setIcon(null);
                        jLabel.setForeground(jTable.getForeground());
                    }
                    jLabel.setHorizontalAlignment(0);
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getTextureRenderer() {
            return new DefaultTableCellRenderer(){
                {
                    this.setHorizontalAlignment(0);
                }

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)object;
                    JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, null, bl, bl2, n, n2);
                    HomeTexture homeTexture = homePieceOfFurniture.getTexture();
                    if (homeTexture != null) {
                        Content content = homeTexture.getImage();
                        jLabel.setIcon(IconManager.getInstance().getIcon(content, jTable.getRowHeight() - 2, jTable));
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private TableCellRenderer getBooleanRenderer(HomePieceOfFurniture.SortableProperty sortableProperty) {
            switch (sortableProperty) {
                class BooleanRenderer
                implements TableCellRenderer {
                    private TableCellRenderer booleanRenderer;
                    private final boolean enabled;

                    public BooleanRenderer(boolean bl) {
                        this.enabled = bl;
                    }

                    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                        if (this.booleanRenderer == null) {
                            this.booleanRenderer = jTable.getDefaultRenderer(Boolean.class);
                        }
                        Component component = this.booleanRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        component.setEnabled(this.enabled);
                        return component;
                    }
                }
                case MOVABLE: {
                    return new BooleanRenderer(false){
                        {
                            super(bl);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).isMovable(), bl, bl2, n, n2);
                        }
                    };
                }
                case DOOR_OR_WINDOW: {
                    return new BooleanRenderer(false){
                        {
                            super(bl);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).isDoorOrWindow(), bl, bl2, n, n2);
                        }
                    };
                }
                case VISIBLE: {
                    return new BooleanRenderer(true){
                        {
                            super(bl);
                        }

                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            return super.getTableCellRendererComponent(jTable, ((HomePieceOfFurniture)object).isVisible(), bl, bl2, n, n2);
                        }
                    };
                }
            }
            throw new IllegalArgumentException((Object)((Object)sortableProperty) + " column not a boolean column");
        }

        private TableCellRenderer getHeaderRenderer(final Home home) {
            return new TableCellRenderer(){
                private TableCellRenderer headerRenderer;
                private ImageIcon ascendingSortIcon = new ImageIcon(this.getClass().getResource("resources/ascending.png"));
                private ImageIcon descendingSortIcon = new ImageIcon(this.getClass().getResource("resources/descending.png"));

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (this.headerRenderer == null) {
                        this.headerRenderer = jTable.getTableHeader().getDefaultRenderer();
                    }
                    JLabel jLabel = (JLabel)this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (FurnitureTableColumnModel.this.getColumn(n2).getIdentifier().equals((Object)home.getFurnitureSortedProperty())) {
                        jLabel.setHorizontalTextPosition(10);
                        if (home.isFurnitureDescendingSorted()) {
                            jLabel.setIcon(this.descendingSortIcon);
                        } else {
                            jLabel.setIcon(this.ascendingSortIcon);
                        }
                    } else {
                        jLabel.setIcon(null);
                    }
                    return jLabel;
                }
            };
        }

        private static class LanguageChangeListener
        implements PropertyChangeListener {
            private WeakReference<FurnitureTableColumnModel> furnitureTableColumnModel;

            public LanguageChangeListener(FurnitureTableColumnModel furnitureTableColumnModel) {
                this.furnitureTableColumnModel = new WeakReference<FurnitureTableColumnModel>(furnitureTableColumnModel);
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureTableColumnModel furnitureTableColumnModel = (FurnitureTableColumnModel)this.furnitureTableColumnModel.get();
                UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
                if (furnitureTableColumnModel == null) {
                    userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
                } else {
                    for (TableColumn tableColumn : furnitureTableColumnModel.availableColumns.values()) {
                        HomePieceOfFurniture.SortableProperty sortableProperty = (HomePieceOfFurniture.SortableProperty)((Object)tableColumn.getIdentifier());
                        tableColumn.setHeaderValue(furnitureTableColumnModel.getColumnName(sortableProperty, userPreferences));
                        tableColumn.setCellRenderer(furnitureTableColumnModel.getColumnRenderer(sortableProperty, userPreferences));
                    }
                }
            }
        }
    }

    private static class UserPreferencesChangeListener
    implements PropertyChangeListener {
        private WeakReference<FurnitureTable> furnitureTable;

        public UserPreferencesChangeListener(FurnitureTable furnitureTable) {
            this.furnitureTable = new WeakReference<FurnitureTable>(furnitureTable);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            FurnitureTable furnitureTable = (FurnitureTable)this.furnitureTable.get();
            if (furnitureTable == null) {
                ((UserPreferences)propertyChangeEvent.getSource()).removePropertyChangeListener(UserPreferences.Property.valueOf(propertyChangeEvent.getPropertyName()), this);
            } else {
                furnitureTable.repaint();
                furnitureTable.getTableHeader().repaint();
            }
        }
    }
}

