/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.MusicTreeNode;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Collection;
import com.pugh.sockso.music.CollectionManagerListener;
import com.pugh.sockso.music.MusicItem;
import com.pugh.sockso.music.Track;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class MusicTree
extends JTree
implements DragSourceListener,
DragGestureListener,
CollectionManagerListener,
TreeExpansionListener {
    private static Logger log = Logger.getLogger(MusicTree.class);
    private DragSource dragSource;
    private final Database db;

    public MusicTree(Database db) {
        super(new MusicTreeNode(new Collection()));
        this.db = db;
    }

    public void init() {
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.setShowsRootHandles(true);
        this.refresh();
        this.addTreeExpansionListener(this);
    }

    public void treeCollapsed(TreeExpansionEvent evt) {
    }

    public void treeExpanded(TreeExpansionEvent evt) {
        TreePath path = evt.getPath();
        try {
            MusicTreeNode node = (MusicTreeNode)path.getLastPathComponent();
            MusicItem item = (MusicItem)node.getUserObject();
            if (item.getType().equals("artist")) {
                this.fillArtistNode(node, item);
            } else if (item.getType().equals("album")) {
                this.fillAlbumNode(node, item);
            }
        }
        catch (SQLException e) {
            log.debug((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillCollectionNode(DefaultMutableTreeNode root) throws SQLException {
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            String sql = " select ar.id, ar.name  from artists ar  order by ar.name asc ";
            st = this.db.prepare(" select ar.id, ar.name  from artists ar  order by ar.name asc ");
            rs = st.executeQuery();
            while (rs.next()) {
                Artist artist = new Artist(rs.getInt("id"), rs.getString("name"));
                MusicTreeNode node = new MusicTreeNode(artist);
                node.add(new DefaultMutableTreeNode());
                root.add(node);
            }
            this.reloadNode(root);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillArtistNode(MusicTreeNode node, MusicItem item) throws SQLException {
        ResultSet rs = null;
        Statement st = null;
        try {
            Artist artist = new Artist(item.getId(), item.getName());
            String sql = " select al.id, al.name, al.year  from albums al  where al.artist_id = ?  order by al.name asc ";
            st = this.db.prepare(" select al.id, al.name, al.year  from albums al  where al.artist_id = ?  order by al.name asc ");
            st.setInt(1, item.getId());
            rs = st.executeQuery();
            node.removeAllChildren();
            while (rs.next()) {
                Album album = new Album(artist, rs.getInt("id"), rs.getString("name"), rs.getString("year"));
                MusicTreeNode child = new MusicTreeNode(album);
                child.add(new DefaultMutableTreeNode());
                node.add(child);
            }
            this.reloadNode(node);
        }
        finally {
            rs.close();
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAlbumNode(MusicTreeNode node, MusicItem item) throws SQLException {
        ResultSet rs = null;
        Statement st = null;
        try {
            String sql = Track.getSelectFromSql() + " where t.album_id = ? " + " order by t.track_no asc, t.name asc ";
            st = this.db.prepare(sql);
            st.setInt(1, item.getId());
            rs = st.executeQuery();
            node.removeAllChildren();
            while (rs.next()) {
                Track track = Track.createFromResultSet(rs);
                MusicTreeNode child = new MusicTreeNode(track);
                node.add(child);
            }
            this.reloadNode(node);
        }
        finally {
            rs.close();
            st.close();
        }
    }

    public void refresh() {
        try {
            DefaultTreeModel model = (DefaultTreeModel)this.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            root.removeAllChildren();
            this.fillCollectionNode(root);
            this.reloadNode(root);
            this.expandNode(root);
        }
        catch (SQLException e) {
            log.error((Object)e);
        }
    }

    protected void expandNode(TreeNode node) {
        TreePath path = new TreePath(((DefaultMutableTreeNode)node).getPath());
        this.expandPath(path);
        this.fireTreeExpanded(path);
    }

    private void reloadNode(TreeNode node) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.nodeStructureChanged(node);
    }

    public void collectionManagerChangePerformed(int type, String message) {
        if (type == 6) {
            this.refresh();
        }
    }

    public void dragGestureRecognized(DragGestureEvent evt) {
        try {
            MusicTreeNode node = (MusicTreeNode)this.getSelectionPath().getLastPathComponent();
            this.dragSource.startDrag(evt, DragSource.DefaultMoveDrop, (MusicItem)node.getUserObject(), this);
        }
        catch (ClassCastException e) {
            log.error((Object)("Error starting drag: " + e.getMessage()));
        }
    }

    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    public void dragExit(DragSourceEvent evt) {
    }

    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    public void dragOver(DragSourceDragEvent evt) {
    }

    public void dragEnter(DragSourceDragEvent evt) {
    }
}

