/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.pugh.sockso.Validater;
import com.pugh.sockso.ValidationException;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.UsersPanel;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.User;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class CreateUserDialog
extends JDialog {
    private static Logger log = Logger.getLogger(CreateUserDialog.class);
    private Database db;
    private Resources r;
    private UsersPanel usersPanel;
    private JTextField txtName;
    private JTextField txtEmail;
    private JPasswordField txtPass1;
    private JPasswordField txtPass2;
    private JCheckBox isAdmin;

    public CreateUserDialog(JFrame parent, Database db, Resources r, UsersPanel usersPanel) {
        super((Frame)parent, r.getCurrentLocale().getString("gui.title.creatingUser"));
        this.db = db;
        this.r = r;
        this.usersPanel = usersPanel;
        this.createComponents();
        this.setDefaultCloseOperation(2);
        this.setBounds(30, 30, 400, 300);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getMainPane(), "Center");
        this.add((Component)this.getButtonPane(), "South");
        this.pack();
        this.setVisible(true);
    }

    private void createComponents() {
        this.txtName = new JTextField();
        this.txtEmail = new JTextField();
        this.txtPass1 = new JPasswordField();
        this.txtPass2 = new JPasswordField();
        this.isAdmin = new JCheckBox();
    }

    private JPanel getMainPane() {
        Locale locale = this.r.getCurrentLocale();
        FormLayout layout = new FormLayout(" right:max(40dlu;pref), 3dlu, 150dlu, 7dlu ");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(locale.getString("gui.label.username"), (Component)this.txtName);
        builder.nextLine();
        builder.append(locale.getString("gui.label.password"), (Component)this.txtPass1);
        builder.nextLine();
        builder.append(locale.getString("gui.label.passwordRepeat"), (Component)this.txtPass2);
        builder.nextLine();
        builder.append(locale.getString("gui.label.email"), (Component)this.txtEmail);
        builder.nextLine();
        builder.append(locale.getString("gui.label.isAdmin"), (Component)this.isAdmin);
        builder.nextLine();
        return builder.getPanel();
    }

    private JPanel getButtonPane() {
        Locale locale = this.r.getCurrentLocale();
        JButton create = new JButton(locale.getString("gui.label.createUser"), new ImageIcon(this.r.getImage("icons/22x22/ok.png")));
        create.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateUserDialog.this.createUser();
            }
        });
        JButton cancel = new JButton(locale.getString("gui.label.cancel"), new ImageIcon(this.r.getImage("icons/22x22/cancel.png")));
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CreateUserDialog.this.close();
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout(2));
        p.add(cancel);
        p.add(create);
        return p;
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void validateInputFields() throws ValidationException {
        String pass2;
        Locale locale = this.r.getCurrentLocale();
        Validater v = new Validater(this.db);
        if (!v.checkRequiredFields(new JTextComponent[]{this.txtName, this.txtPass1, this.txtEmail})) {
            throw new ValidationException(locale.getString("gui.error.missingField"));
        }
        if (!v.isValidEmail(this.txtEmail.getText())) {
            throw new ValidationException(locale.getString("gui.error.invalidEmail"));
        }
        String pass1 = new String(this.txtPass1.getPassword());
        if (!pass1.equals(pass2 = new String(this.txtPass2.getPassword()))) {
            throw new ValidationException(locale.getString("gui.error.passwordsDontMatch"));
        }
        if (v.usernameExists(this.txtName.getText())) {
            throw new ValidationException(locale.getString("gui.error.duplicateUsername"));
        }
        if (v.emailExists(this.txtEmail.getText())) {
            throw new ValidationException(locale.getString("gui.error.duplicateEmail"));
        }
    }

    private void createUser() {
        try {
            this.validateInputFields();
            User newUser = new User(this.txtName.getText(), new String(this.txtPass1.getPassword()), this.txtEmail.getText(), this.isAdmin.isSelected());
            newUser.save(this.db);
            this.usersPanel.refreshUsers();
            this.close();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
        catch (ValidationException e) {
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }
}

