/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Dispatcher;
import com.pugh.sockso.web.EmptyRequestException;
import com.pugh.sockso.web.HttpRequest;
import com.pugh.sockso.web.HttpResponse;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.Session;
import com.pugh.sockso.web.User;
import com.pugh.sockso.web.action.Errorer;
import com.pugh.sockso.web.action.WebAction;
import com.pugh.sockso.web.log.DbRequestLogger;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Logger;

public class ServerThread
extends Thread {
    private static final Logger log = Logger.getLogger(ServerThread.class);
    private final Socket client;
    private final Server sv;
    private final Database db;
    private final Properties p;
    private final Resources r;
    private final Dispatcher dispatcher;

    public ServerThread(Server server, Socket client, Database db, Properties p, Resources r, Dispatcher dispatcher) {
        this.sv = server;
        this.client = client;
        this.db = db;
        this.p = p;
        this.r = r;
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HttpResponse res = null;
        HttpRequest req = null;
        User user = null;
        Locale locale = this.r.getCurrentLocale();
        try {
            WebAction action;
            req = new HttpRequest(this.sv);
            req.process(this.client.getInputStream());
            locale = this.r.getLocale(req.getPreferredLangCode());
            Session session = new Session(this.db, req, null);
            user = session.getCurrentUser();
            res = new HttpResponse(this.client.getOutputStream(), this.db, this.p, locale, user, req.getHeader("Accept-Encoding").contains("gzip") && !req.getHeader("User-Agent").contains("Safari"));
            if (this.p.get("log.requests.enable").equals("yes")) {
                DbRequestLogger logger = new DbRequestLogger(this.db);
                logger.log(user, this.client.getInetAddress().getHostAddress(), req.getResource(), req.getHeader("User-Agent"), req.getHeader("Referer"), req.getHeader("Cookie"));
            }
            if ((action = this.dispatcher.getAction(req)) == null) {
                throw new BadRequestException(locale.getString("www.error.unknownRequest"), 400);
            }
            action.init(req, res, user, locale);
            if (this.p.get("users.requireLogin").equals("yes") && user == null && action.requiresLogin()) {
                res.redirect("/user/login");
            } else {
                action.handleRequest();
            }
        }
        catch (SocketException e) {
        }
        catch (EmptyRequestException e) {
        }
        catch (BadRequestException e) {
            this.showException(e, req, res, false);
        }
        catch (Exception e) {
            BadRequestException exception = new BadRequestException(e.getMessage(), 500);
            exception.setStackTrace(e.getStackTrace());
            this.showException(exception, req, res, true);
        }
        finally {
            try {
                this.client.close();
            }
            catch (Exception e) {}
        }
        this.sv.requestComplete(this);
    }

    private void showException(BadRequestException e, Request req, Response res, boolean showStackTrace) {
        log.error((Object)e);
        if (showStackTrace) {
            e.printStackTrace();
        }
        Errorer err = new Errorer(e, showStackTrace);
        err.setRequest(req);
        err.setResponse(res);
        try {
            err.handleRequest();
        }
        catch (Exception e2) {
            // empty catch block
        }
    }

    public void shutdown() {
        log.info((Object)"Shutting Down");
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

