/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;

public class IpFinder {
    public static Logger log = Logger.getLogger(IpFinder.class);
    public static final String LOOPBACK = "127.0.0.1";
    private final OptionSet options;
    private final Properties p;
    private String ip;

    public IpFinder(Properties p) {
        this(p, null);
    }

    public IpFinder(Properties p, OptionSet options) {
        this.options = options;
        this.p = p;
        this.ip = LOOPBACK;
    }

    public void init() {
        this.ip = this.getIpFromOptions();
        if (this.ip == null) {
            new Thread(){

                public void run() {
                    while (true) {
                        IpFinder.this.update();
                        try {
                            Thread.sleep(1200000L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            }.start();
        }
    }

    public void refresh() {
        this.p.set("server.host.lastUpdated", 0L);
        this.update();
    }

    protected void update() {
        this.ip = null;
        if (this.ip == null) {
            this.ip = this.getIpFromProperties();
        }
        if (this.ip == null) {
            this.ip = this.getIpFromInternet();
        }
        if (this.ip == null) {
            this.ip = this.getIpFromIntranet();
        }
        if (this.ip == null) {
            this.ip = LOOPBACK;
        }
        this.save();
        log.debug((Object)("Using IP " + this.ip));
    }

    protected void save() {
        this.p.set("server.host", this.ip);
        this.p.set("server.host.lastUpdated", Long.toString(new Date().getTime()));
        this.p.save();
    }

    protected String getIpFromOptions() {
        log.debug((Object)"Get IP from options");
        return this.options != null && this.options.has("ip") ? this.options.valueOf("ip").toString() : null;
    }

    protected String getIpFromProperties() {
        log.debug((Object)"Get IP from properties");
        String possibleIp = this.p.get("server.host");
        long lastUpdated = this.p.get("server.host.lastUpdated", 0L);
        long ipTimeout = new Date().getTime() - 1200000L;
        return possibleIp.equals("") || lastUpdated < ipTimeout ? null : possibleIp;
    }

    private String getIpFromInternet() {
        log.debug((Object)"Get IP from internet");
        try {
            String natUrl = "http://sockso.pu-gh.com/nat/ip/";
            log.info((Object)"Fetching IP from http://sockso.pu-gh.com/nat/ip/");
            URL url = new URL("http://sockso.pu-gh.com/nat/ip/");
            HttpURLConnection cnn = (HttpURLConnection)url.openConnection();
            cnn.setRequestMethod("GET");
            return this.getIpFromUrl(cnn);
        }
        catch (SocketTimeoutException e) {
            log.warn((Object)e);
        }
        catch (UnknownHostException e) {
            log.warn((Object)e);
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return null;
    }

    private String getIpFromIntranet() {
        log.debug((Object)"Get IP from intranet");
        try {
            return Utils.getLocalIp();
        }
        catch (UnknownHostException e) {
            log.warn((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getIpFromUrl(HttpURLConnection cnn) throws IOException {
        String string;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
            String s = in.readLine();
            if (!this.isValidIpFormat(s)) {
                throw new IOException("Invalid response: " + s);
            }
            string = s;
        }
        catch (Throwable throwable) {
            Utils.close(in);
            throw throwable;
        }
        Utils.close(in);
        return string;
    }

    protected boolean isValidIpFormat(String possibleIp) {
        Matcher m = Pattern.compile("\\d+.\\d+.\\d+.\\d+").matcher(possibleIp);
        return m.matches();
    }

    public String getIp() {
        return this.ip;
    }
}

