/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.Info;
import com.pugh.sockso.music.tag.AudioTag;
import com.pugh.sockso.music.tag.State;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class OggTag
extends AudioTag {
    private static final Logger log = Logger.getLogger(OggTag.class);
    private State state = null;
    private static int CHUNKSIZE = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(File file) throws IOException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.state = new State();
            this.read(in);
            for (int i = 0; i < this.state.vc.comments; ++i) {
                String value;
                String c = this.state.vc.getComment(i);
                String[] parts = c.split("=");
                String name = parts.length > 0 ? parts[0].toLowerCase() : "";
                String string = value = parts.length > 1 ? parts[1] : "";
                if (name.equals("tracknumber")) {
                    this.setTrackNumber(value);
                    continue;
                }
                if (name.equals("artist")) {
                    this.artistTitle = value;
                    continue;
                }
                if (name.equals("album")) {
                    this.albumTitle = value;
                    continue;
                }
                if (!name.equals("title")) continue;
                this.trackTitle = value;
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (Exception exception) {}
        }
    }

    private void read(InputStream in) {
        this.state.in = in;
        Page og = new Page();
        int bytes = 0;
        this.state.oy = new SyncState();
        this.state.oy.init();
        int index = this.state.oy.buffer(CHUNKSIZE);
        byte[] buffer = this.state.oy.data;
        try {
            bytes = this.state.in.read(buffer, index, CHUNKSIZE);
        }
        catch (Exception e) {
            log.error((Object)e);
            return;
        }
        this.state.oy.wrote(bytes);
        if (this.state.oy.pageout(og) != 1) {
            if (bytes < CHUNKSIZE) {
                log.error((Object)"Input truncated or empty.");
            } else {
                log.error((Object)"Input is not an Ogg bitstream.");
            }
            return;
        }
        this.state.serial = og.serialno();
        this.state.os = new StreamState();
        this.state.os.init(this.state.serial);
        this.state.vi = new Info();
        this.state.vi.init();
        this.state.vc = new Comment();
        this.state.vc.init();
        if (this.state.os.pagein(og) < 0) {
            log.error((Object)"Error reading first page of Ogg bitstream data.");
            return;
        }
        Packet header_main = new Packet();
        if (this.state.os.packetout(header_main) != 1) {
            log.error((Object)"Error reading initial header packet.");
            return;
        }
        if (this.state.vi.synthesis_headerin(this.state.vc, header_main) < 0) {
            log.error((Object)"This Ogg bitstream does not contain Vorbis data.");
            return;
        }
        this.state.mainlen = header_main.bytes;
        this.state.mainbuf = new byte[this.state.mainlen];
        System.arraycopy(header_main.packet_base, header_main.packet, this.state.mainbuf, 0, this.state.mainlen);
        int i = 0;
        Packet header_comments = new Packet();
        Packet header_codebooks = new Packet();
        Packet header = header_comments;
        while (i < 2) {
            int result;
            while (i < 2 && (result = this.state.oy.pageout(og)) != 0) {
                if (result != 1) continue;
                this.state.os.pagein(og);
                while (i < 2 && (result = this.state.os.packetout(header)) != 0) {
                    if (result == -1) {
                        log.debug((Object)"Corrupt secondary header.");
                        return;
                    }
                    this.state.vi.synthesis_headerin(this.state.vc, header);
                    if (i == 1) {
                        this.state.booklen = header.bytes;
                        this.state.bookbuf = new byte[this.state.booklen];
                        System.arraycopy(header.packet_base, header.packet, this.state.bookbuf, 0, header.bytes);
                    }
                    ++i;
                    header = header_codebooks;
                }
            }
            index = this.state.oy.buffer(CHUNKSIZE);
            buffer = this.state.oy.data;
            try {
                bytes = this.state.in.read(buffer, index, CHUNKSIZE);
            }
            catch (Exception e) {
                log.error((Object)e);
                return;
            }
            if (bytes == 0 && i < 2) {
                log.debug((Object)"EOF before end of vorbis headers.");
                return;
            }
            this.state.oy.wrote(bytes);
        }
        log.debug((Object)this.state.vi);
    }
}

