/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.MusicList;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.MusicItem;
import com.pugh.sockso.music.Playlist;
import com.pugh.sockso.music.Track;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class PlaylistPanel
extends MusicList
implements DropTargetListener {
    private static Logger log = Logger.getLogger(PlaylistPanel.class);
    private JFrame parent;
    private Database db;
    private CollectionManager cm;
    private DefaultListModel model;
    private DropTarget dropTarget;
    private int dummyIndex;
    private Track dragItem;

    public PlaylistPanel(JFrame parent, Database db, CollectionManager cm) {
        super(2);
        this.parent = parent;
        this.db = db;
        this.cm = cm;
        this.dummyIndex = -1;
        this.model = new DefaultListModel();
        this.dropTarget = new DropTarget(this, 3, this);
        this.setModel(this.model);
        this.setCellRenderer(new MyCellRenderer());
        this.setSelectionMode(0);
    }

    public void drop(DropTargetDropEvent evt) {
        try {
            Transferable trans = evt.getTransferable();
            MusicItem item = (MusicItem)trans.getTransferData(MusicItem.MUSIC_ITEM_FLAVOR);
            if (this.dummyIndex != -1) {
                this.model.removeElementAt(this.dummyIndex);
                this.model.insertElementAt(this.dragItem, this.dummyIndex);
                this.dragItem = null;
                this.dummyIndex = -1;
            } else {
                this.insertIntoPlaylist(evt.getLocation(), item);
            }
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
        }
        catch (UnsupportedFlavorException e) {
            log.error((Object)e.getMessage());
        }
        catch (ClassCastException e) {
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoPlaylist(Point location, MusicItem item) {
        block15: {
            try {
                String sql = null;
                String type = item.getType();
                if (type.equals("collection")) {
                    sql = Track.getSelectFromSql();
                } else if (type.equals("playlist")) {
                    Playlist playlist = (Playlist)item;
                    sql = Playlist.getSelectTracksSql(playlist.getId(), "");
                } else if (type.equals("artist")) {
                    Artist artist = (Artist)item;
                    sql = Track.getSelectFromSql() + " where t.artist_id = '" + artist.getId() + "' ";
                } else if (type.equals("album")) {
                    Album album = (Album)item;
                    sql = Track.getSelectFromSql() + " where t.album_id = '" + album.getId() + "' ";
                } else if (type.equals("track")) {
                    Track track = (Track)item;
                    sql = Track.getSelectFromSql() + " where t.id = '" + track.getId() + "' ";
                }
                if (sql == null) break block15;
                ResultSet rs = null;
                PreparedStatement st = null;
                try {
                    st = this.db.prepare(sql);
                    rs = st.executeQuery();
                    int index = this.locationToIndex(location);
                    while (rs.next()) {
                        Track track = Track.createFromResultSet(rs);
                        if (index < 1) {
                            this.model.addElement(track);
                            continue;
                        }
                        this.model.insertElementAt(track, index + 1);
                    }
                }
                catch (Throwable throwable) {
                    Utils.close(rs);
                    Utils.close(st);
                    throw throwable;
                }
                Utils.close(rs);
                Utils.close(st);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
            }
        }
    }

    public void dragEnter(DropTargetDragEvent evt) {
        evt.acceptDrag(3);
    }

    public void dragExit(DropTargetEvent evt) {
    }

    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    public void dragOver(DropTargetDragEvent evt) {
        if (this.dummyIndex == -1) {
            return;
        }
        int index = this.locationToIndex(evt.getLocation());
        if (this.model.getSize() >= this.dummyIndex) {
            this.model.removeElementAt(this.dummyIndex);
        }
        this.model.insertElementAt("", index);
        this.dummyIndex = index;
    }

    private MusicItem getValue(Point where) {
        int idx = this.locationToIndex(where);
        return (MusicItem)this.model.getElementAt(idx);
    }

    private Track[] getTracks() {
        int size = this.model.getSize();
        Track[] tracks = new Track[size];
        for (int i = 0; i < size; ++i) {
            tracks[i] = (Track)this.model.getElementAt(i);
        }
        return tracks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        PreparedStatement st;
        ResultSet rs;
        Track[] tracks;
        String playlistName;
        block6: {
            playlistName = JOptionPane.showInputDialog(this.parent, (Object)"Please enter a name for the playlist:");
            if (playlistName == null) {
                return;
            }
            tracks = this.getTracks();
            rs = null;
            st = null;
            String sql = " select id  from playlists p  where name = ? ";
            st = this.db.prepare(" select id  from playlists p  where name = ? ");
            st.setString(1, playlistName);
            rs = st.executeQuery();
            if (!rs.next() || JOptionPane.showConfirmDialog(this, "That playlist already exists, replace it?", "Overwrite Playlist", 0) == 0) break block6;
            Utils.close(rs);
            Utils.close(st);
            return;
        }
        try {
            this.cm.savePlaylist(playlistName, tracks);
        }
        catch (SQLException e) {
            try {
                JOptionPane.showMessageDialog(this.parent, e.getMessage());
                log.error((Object)e.getMessage());
            }
            catch (Throwable throwable) {
                Utils.close(rs);
                Utils.close(st);
                throw throwable;
            }
            Utils.close(rs);
            Utils.close(st);
        }
        Utils.close(rs);
        Utils.close(st);
    }

    public void removeSelection() {
        int[] indexes = this.getSelectedIndices();
        for (int i = 0; i < indexes.length; ++i) {
            this.model.removeElementAt(indexes[i]);
        }
    }

    public void clear() {
        this.model.clear();
    }

    public void dragGestureRecognized(DragGestureEvent evt) {
        if (this.getSelectedValue() == null) {
            return;
        }
        super.dragGestureRecognized(evt);
        this.dummyIndex = this.getSelectedIndex();
        this.dragItem = (Track)this.model.getElementAt(this.dummyIndex);
        this.model.removeElementAt(this.dummyIndex);
        this.model.insertElementAt("", this.dummyIndex);
    }

    private final class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean focus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, focus);
            if (value instanceof Track) {
                Track track = (Track)value;
                c.setText(this.getTrackDisplay(track));
            } else {
                c.setBackground(list.getSelectionBackground());
                c.setText(this.getTrackDisplay(PlaylistPanel.this.dragItem));
            }
            return c;
        }

        private String getTrackDisplay(Track track) {
            return track.getName() + " - " + track.getArtist().getName() + " (" + track.getAlbum().getName() + ")";
        }
    }
}

