/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Properties;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.web.BadRequestException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class Utils {
    private static final Logger log = Logger.getLogger(Utils.class);
    private static String APPLICATION_DIRECTORY;

    public static void setApplicationDirectory(File directory) {
        APPLICATION_DIRECTORY = directory.getAbsolutePath();
    }

    public static String getApplicationDirectory() {
        return APPLICATION_DIRECTORY;
    }

    public static String getCoversDirectory() {
        return APPLICATION_DIRECTORY + "/covers";
    }

    public static String getExt(File file) {
        return Utils.getExt(file.getName());
    }

    public static String getExt(String name) {
        return name.substring(name.lastIndexOf(".") + 1).toLowerCase();
    }

    public static String getRandomString(int length) {
        StringBuffer sb = new StringBuffer();
        Random rand = new Random();
        for (int i = 0; i < length; ++i) {
            sb.append((char)(Math.abs(rand.nextInt()) % 26 + 65));
        }
        return sb.toString();
    }

    public static void close(Statement s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception e) {
            log.error((Object)("Error closing statement: " + e.getMessage()));
        }
    }

    public static void close(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)("Error closing result set: " + e.getMessage()));
        }
    }

    public static void close(InputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception e) {
            log.error((Object)("Error closing input stream: " + e.getMessage()));
        }
    }

    public static void close(OutputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception e) {
            log.error((Object)("Error closing output stream: " + e.getMessage()));
        }
    }

    public static void close(BufferedReader s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (Exception e) {
            log.error((Object)("Error closing buffered reader: " + e.getMessage()));
        }
    }

    public static String URLEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            return "";
        }
    }

    public static String URLDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage());
            return "";
        }
    }

    public static String getLocalIp() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostAddress();
    }

    public static String md5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] md5hash = new byte[32];
            md.update(text.getBytes("iso-8859-1"), 0, text.length());
            md5hash = md.digest();
            return Utils.convertToHex(md5hash);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String formatDate(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE MMM dd, yyyy");
        return formatter.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUploadsPath(Database db, Properties p) {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String strCollId = p.get("uploads.collectionId").trim();
            if (strCollId.matches("^\\d+$")) {
                int uploadsCollId = Integer.parseInt(strCollId);
                String sql = " select path  from collection  where id = ?  limit 1 ";
                st = db.prepare(" select path  from collection  where id = ?  limit 1 ");
                st.setInt(1, uploadsCollId);
                rs = st.executeQuery();
                if (rs.next()) {
                    String string = rs.getString("path");
                    Utils.close(rs);
                    Utils.close(st);
                    return string;
                }
            }
            Utils.close(rs);
        }
        catch (SQLException e) {
            log.error((Object)e);
            return "";
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (NumberFormatException e2) {
                log.debug((Object)("No valid uploads collection ID defined: " + e2));
                return "";
            }
        }
        finally {
            Utils.close(rs);
            Utils.close(st);
        }
        Utils.close(st);
        return "";
    }

    public static String XMLEncode(String value) {
        String newValue = value.toString();
        String[] reps = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;", "'", "&apos;"};
        for (int i = 0; i < reps.length; i += 2) {
            newValue = newValue.replace(reps[i], reps[i + 1]);
        }
        return newValue;
    }

    public static String getPathWithSlash(File file) {
        return Utils.getPathWithSlash(file.getAbsolutePath());
    }

    public static String getPathWithSlash(String path) {
        String separator = System.getProperty("file.separator");
        return Utils.getPathWithSlash(path, separator);
    }

    protected static String getPathWithSlash(String path, String separator) {
        return !path.matches(".*\\" + separator + "$") ? path + separator : path;
    }

    public static String escapeJs(String str) {
        return str.replaceAll("\\\\", "\\\\\\\\").replaceAll("'", "\\\\'");
    }

    public static void checkFeatureEnabled(Properties p, String property) throws BadRequestException {
        if (!Utils.isFeatureEnabled(p, property)) {
            throw new BadRequestException("feature not enabled", 403);
        }
    }

    public static boolean isFeatureEnabled(Properties p, String property) {
        return p.get(property).equals("yes");
    }

    public static String replaceAll(String regex, String replaceWith, String subject) {
        Pattern p = Pattern.compile(regex, 2);
        Matcher m = p.matcher(subject);
        return m.replaceAll(replaceWith);
    }

    public static String u2e(String orig) {
        int length = orig.length();
        StringBuffer buffer = new StringBuffer(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = orig.charAt(i);
            char code = c;
            buffer.append(code < '\u0080' ? Character.valueOf(c) : "&#" + c + ';');
        }
        return buffer.toString();
    }

    public static String joinArray(String[] array, String glue, int start, int end) {
        StringBuffer sb = new StringBuffer();
        for (int i = start; i <= end; ++i) {
            if (i > start) {
                sb.append(glue);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    static {
        Utils.setApplicationDirectory(new File(System.getProperty("user.home") + "/.sockso"));
    }
}

