/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Properties;
import com.pugh.sockso.PropertiesListener;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringProperties
implements Properties {
    protected final Hashtable<String, String> data = new Hashtable();
    private final Vector<PropertiesListener> listeners = new Vector();

    @Override
    public void init() throws Exception {
    }

    @Override
    public String[] getProperties() {
        Set<String> props = this.data.keySet();
        return props.toArray(new String[0]);
    }

    @Override
    public void addPropertiesListener(PropertiesListener listener) {
        this.listeners.add(listener);
    }

    protected void firePropertiesSavedEvent() {
        for (PropertiesListener listener : this.listeners) {
            listener.propertiesSaved(this);
        }
    }

    @Override
    public void set(String name, String value) {
        this.data.put(name, value);
    }

    @Override
    public void set(String name, boolean value) {
        this.set(name, value ? "yes" : "no");
    }

    @Override
    public void set(String name, long value) {
        this.set(name, Long.toString(value));
    }

    @Override
    public String get(String name) {
        return this.get(name, "");
    }

    @Override
    public String get(String name, String defaultValue) {
        String value = this.data.get(name);
        return value == null || value.equals("") ? defaultValue : value;
    }

    @Override
    public long get(String name, long defaultValue) {
        long returnValue = defaultValue;
        try {
            returnValue = Long.parseLong(this.get(name, Long.toString(defaultValue)));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return returnValue;
    }

    @Override
    public Hashtable<String, String> getMatches(String name) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        int nameLength = name.length();
        for (String key : this.data.keySet()) {
            if (key.length() < nameLength || !key.substring(0, nameLength).equals(name)) continue;
            hash.put(key.substring(nameLength + 1), this.get(key));
        }
        return hash;
    }

    @Override
    public void save() {
        this.firePropertiesSavedEvent();
    }

    @Override
    public void delete(String name) {
        this.data.remove(name);
    }

    @Override
    public boolean exists(String name) {
        return this.data.get(name) != null;
    }
}

