/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso;

import com.pugh.sockso.Console;
import com.pugh.sockso.DBProperties;
import com.pugh.sockso.Manager;
import com.pugh.sockso.Options;
import com.pugh.sockso.Properties;
import com.pugh.sockso.Shutdown;
import com.pugh.sockso.UPNP;
import com.pugh.sockso.Utils;
import com.pugh.sockso.VersionChecker;
import com.pugh.sockso.db.DBExporter;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.db.DatabaseConnectionException;
import com.pugh.sockso.db.HSQLDatabase;
import com.pugh.sockso.db.MySQLDatabase;
import com.pugh.sockso.db.SQLiteDatabase;
import com.pugh.sockso.gui.AppFrame;
import com.pugh.sockso.gui.Splash;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.DBCollectionManager;
import com.pugh.sockso.music.indexing.Indexer;
import com.pugh.sockso.music.indexing.TrackIndexer;
import com.pugh.sockso.music.scheduling.CronScheduler;
import com.pugh.sockso.music.scheduling.ManualScheduler;
import com.pugh.sockso.music.scheduling.Scheduler;
import com.pugh.sockso.music.scheduling.SimpleScheduler;
import com.pugh.sockso.resources.FileResources;
import com.pugh.sockso.resources.JarResources;
import com.pugh.sockso.resources.Resources;
import com.pugh.sockso.web.Dispatcher;
import com.pugh.sockso.web.HttpServer;
import com.pugh.sockso.web.HttpsServer;
import com.pugh.sockso.web.IpFinder;
import com.pugh.sockso.web.Server;
import com.pugh.sockso.web.SessionCleaner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Main {
    private static final Logger log = Logger.getLogger(Main.class);
    private static volatile boolean shutdownStarted = false;
    private static Dispatcher dispatcher;
    private static Database db;
    private static Properties p;
    private static Server sv;
    private static CollectionManager cm;
    private static Manager manager;
    private static Resources r;
    private static Indexer indexer;
    private static Scheduler sched;

    public static void main(String[] args) throws Exception {
        Runtime.getRuntime().addShutdownHook(new Shutdown());
        Main.initLogger(Main.getLogPropsFile("default"));
        OptionParser parser = Options.getParser();
        OptionSet options = null;
        try {
            options = parser.parse(args);
        }
        catch (Exception e) {
            System.err.println("Invalid command line switch!\n");
        }
        if (options == null || options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            Main.exit(false);
        }
        if (options.has("version")) {
            System.out.println("Sockso 1.2.3");
            Main.exit(false);
        }
        if (options.hasArgument("datadir")) {
            File dir = new File((String)options.valueOf("datadir"));
            if (!dir.exists()) {
                log.error((Object)(dir.getAbsolutePath() + " does not exist"));
                Main.exit(1);
            }
            Utils.setApplicationDirectory(dir);
        }
        Main.setupAppDirectory();
        try {
            db = Main.getDatabase(options);
            db.connect(options);
        }
        catch (Exception e) {
            log.error((Object)e);
            Main.exit(1);
        }
        if (options.hasArgument("logtype")) {
            PropertyConfigurator.configure((String)Main.getLogPropsFile(options.valueOf("logtype").toString()));
        }
        if (options.has("query")) {
            Main.actionQuery(options);
        } else if (options.has("admin")) {
            Main.actionAdmin(options);
        } else {
            Main.actionDefault(options);
        }
    }

    private static void actionAdmin(OptionSet options) throws Exception {
        boolean useGui = Main.getUseGui(options);
        String locale = Main.getLocale(options);
        log.info((Object)("Initializing Resources (" + locale + ")"));
        r = Main.getResources(options);
        r.init(locale);
        if (useGui) {
            Splash.start(r);
        }
        log.info((Object)"Loading Properties");
        p = new DBProperties(db);
        p.init();
        log.info((Object)"Starting Collection Manager");
        cm = new DBCollectionManager(db, p, Main.getIndexer());
        IpFinder ipFinder = new IpFinder(p, options);
        ipFinder.init();
        manager = useGui ? new AppFrame(db, p, null, cm, r, ipFinder) : new Console(db, p, cm, r);
        manager.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void actionQuery(OptionSet options) {
        BufferedReader in = null;
        try {
            String sql = "";
            String line = "";
            in = new BufferedReader(options.hasArgument("query") ? new FileReader(options.valueOf("query").toString()) : new InputStreamReader(System.in));
            while ((line = in.readLine()) != null) {
                sql = sql + line + "\n";
            }
            DBExporter exporter = new DBExporter(db);
            System.out.print(exporter.export(sql, DBExporter.Format.XML));
            Utils.close(in);
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        finally {
            Utils.close(in);
        }
    }

    private static void actionDefault(OptionSet options) throws Exception {
        boolean useGui = Main.getUseGui(options);
        String locale = Main.getLocale(options);
        log.info((Object)("Initializing Resources (" + locale + ")"));
        r = Main.getResources(options);
        r.init(locale);
        if (useGui) {
            Splash.start(r);
        }
        log.info((Object)"Loading Properties");
        p = new DBProperties(db);
        p.init();
        log.info((Object)"Creating Indexer");
        indexer = Main.getIndexer();
        log.info((Object)"Starting Scheduler");
        sched = Main.getScheduler(p);
        sched.start();
        log.debug((Object)("Using scheduler: " + sched.getClass().getSimpleName()));
        log.info((Object)"Starting Collection Manager");
        cm = new DBCollectionManager(db, p, indexer);
        indexer.addIndexListener((DBCollectionManager)cm);
        new SessionCleaner(db).init();
        IpFinder ipFinder = new IpFinder(p, options);
        ipFinder.init();
        int port = Main.getSavedPort(p);
        String protocol = Main.getProtocol(options);
        dispatcher = new Dispatcher(protocol, port, p, r, cm, db);
        log.info((Object)"Starting Web Server");
        sv = Main.getServer(port, options);
        sv.start(options);
        if (options.has("upnp")) {
            log.info((Object)"Trying UPNP Magic");
            UPNP.tryPortForwarding(sv.getPort());
        }
        manager = useGui ? new AppFrame(db, p, sv, cm, r, ipFinder) : new Console(db, p, cm, r);
        VersionChecker versionChecker = new VersionChecker(p);
        versionChecker.addLatestVersionListener(manager);
        versionChecker.fetchLatestVersion();
        manager.open();
    }

    protected static Database getDatabase(OptionSet options) throws DatabaseConnectionException {
        String dbtype;
        String string = dbtype = options.has("dbtype") ? options.valueOf("dbtype").toString() : "";
        if (dbtype.equals("mysql")) {
            log.info((Object)"Using MySQL Database");
            return new MySQLDatabase();
        }
        if (dbtype.equals("sqlite")) {
            log.info((Object)"Using sqlite Database");
            return new SQLiteDatabase();
        }
        log.info((Object)"Using HSQL Database");
        return new HSQLDatabase();
    }

    protected static boolean getUseGui(OptionSet options) {
        return !options.has("nogui");
    }

    protected static String getLocale(OptionSet options) {
        return options.has("locale") ? options.valueOf("locale").toString() : "en";
    }

    protected static Resources getResources(OptionSet options) {
        String resourceType = options.has("resourcestype") ? options.valueOf("resourcestype").toString() : "";
        log.debug((Object)("Resources type: " + resourceType));
        return resourceType.equals("jar") ? new JarResources() : new FileResources();
    }

    protected static String getProtocol(OptionSet options) {
        return options.has("ssl") ? "https" : "http";
    }

    protected static Server getServer(int port, OptionSet options) {
        return options.has("ssl") ? new HttpsServer(port, dispatcher, db, p, r) : new HttpServer(port, dispatcher, db, p, r);
    }

    protected static Indexer getIndexer() {
        return new TrackIndexer(db);
    }

    protected static Scheduler getScheduler(Properties p) {
        String scheduler = p.get("scheduler");
        if (scheduler.equals("cron")) {
            return new CronScheduler(indexer, p);
        }
        if (scheduler.equals("manual")) {
            return new ManualScheduler(indexer);
        }
        return new SimpleScheduler(indexer, p);
    }

    protected static int getSavedPort(Properties p) {
        int thePort = 4444;
        try {
            thePort = Integer.parseInt(p.get("server.port"));
        }
        catch (NumberFormatException e) {
            log.error((Object)("Invalid port number: " + e));
        }
        return thePort;
    }

    private static String getLogPropsFile(String type) {
        return "log/" + type + ".properties";
    }

    public static void exit() {
        Main.exit(0, true);
    }

    public static void exit(int status) {
        Main.exit(status, true);
    }

    public static void exit(boolean showOutput) {
        Main.exit(0, showOutput);
    }

    public static void exit(int status, boolean showOutput) {
        if (showOutput) {
            log.info((Object)"Shutting Down");
        }
        Main.shutdown();
        if (showOutput) {
            log.info((Object)"Thank you for your attention, bye!");
        }
        System.exit(status);
    }

    protected static void shutdown() {
        if (!shutdownStarted) {
            shutdownStarted = true;
            if (indexer != null) {
                // empty if block
            }
            if (sv != null) {
                sv.shutdown();
                sv = null;
            }
            if (manager != null) {
                manager.close();
                manager = null;
            }
            Main.shutdownDatabase();
        }
    }

    public static void shutdownDatabase() {
        if (db != null) {
            db.close();
            db = null;
        }
    }

    private static void setupAppDirectory() {
        String[] dirs;
        for (String dir : dirs = new String[]{Utils.getApplicationDirectory(), Utils.getCoversDirectory()}) {
            File file = new File(dir);
            if (file.exists() || file.mkdir()) continue;
            log.fatal((Object)("Unable to create directory: " + dir));
            Main.exit(1);
        }
    }

    public static void initTestLogger() {
        Main.initLogger("dist-files/log/test.properties");
    }

    private static void initLogger(String propsFile) {
        PropertyConfigurator.configure((String)propsFile);
    }
}

