/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag;

import com.pugh.sockso.music.tag.AudioTag;
import com.pugh.sockso.music.tag.ByteOrder;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class Mp3Tag
extends AudioTag {
    public static final String ISO_LATIN_1 = "8859_1";
    public static final String UNICODE = "Unicode";
    static final String TITLE_ID = "TIT2";
    static final String ARTIST_ID = "TPE1";
    static final String ALBUM_ID = "TALB";
    static final String TRACK_ID = "TRCK";

    public void parse(File file) throws IOException {
        this.parseID3v2Data(file);
        this.parseID3v1Data(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseID3v1Data(File file) {
        if (file.length() < 128L) {
            return;
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            long length = randomAccessFile.length();
            randomAccessFile.seek(length - 128L);
            byte[] buffer = new byte[30];
            randomAccessFile.readFully(buffer, 0, 3);
            String tag = new String(buffer, 0, 3);
            if (!tag.equals("TAG")) {
                return;
            }
            randomAccessFile.readFully(buffer, 0, 30);
            if (this.trackTitle.equals("")) {
                this.trackTitle = this.getString(buffer, 30);
            }
            randomAccessFile.readFully(buffer, 0, 30);
            if (this.artistTitle.equals("")) {
                this.artistTitle = this.getString(buffer, 30);
            }
            randomAccessFile.readFully(buffer, 0, 30);
            if (this.albumTitle.equals("")) {
                this.albumTitle = this.getString(buffer, 30);
            }
            randomAccessFile.readFully(buffer, 0, 30);
            if (buffer[28] == 0) {
                if (this.trackNumber == 0) {
                    this.trackNumber = ByteOrder.ubyte2int(buffer[29]);
                }
                int commentLength = 28;
            }
        }
        catch (IOException ignored) {
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    private int getTrimmedLength(byte[] bytes, int includedLength) {
        int i;
        for (i = includedLength - 1; i >= 0 && (bytes[i] == 0 || bytes[i] == 32); --i) {
        }
        for (int j = 0; j <= i; ++j) {
            if (bytes[j] != 0) continue;
            bytes[j] = 32;
        }
        return i + 1;
    }

    private String getString(byte[] buffer, int length) {
        try {
            return new String(buffer, 0, this.getTrimmedLength(buffer, length), ISO_LATIN_1);
        }
        catch (UnsupportedEncodingException err) {
            return null;
        }
    }

    private void parseID3v2Data(File file) {
        ID3v2 id3v2Parser = null;
        try {
            id3v2Parser = new ID3v2(file);
        }
        catch (ID3v2Exception idvx) {
            return;
        }
        catch (IOException iox) {
            return;
        }
        catch (ArrayIndexOutOfBoundsException ignored) {
            return;
        }
        Vector frames = null;
        try {
            frames = id3v2Parser.getFrames();
        }
        catch (NoID3v2TagException ntx) {
            return;
        }
        for (ID3v2Frame frame : frames) {
            String frameID = frame.getID();
            byte[] contentBytes = frame.getContent();
            String frameContent = null;
            if (contentBytes.length > 0) {
                try {
                    String enc = frame.isISOLatin1() ? ISO_LATIN_1 : UNICODE;
                    frameContent = new String(contentBytes, enc).trim();
                }
                catch (UnsupportedEncodingException err) {
                    // empty catch block
                }
            }
            if (frameContent == null || frameContent.trim().equals("")) continue;
            if (TITLE_ID.equals(frameID)) {
                this.trackTitle = frameContent;
                continue;
            }
            if (ARTIST_ID.equals(frameID)) {
                this.artistTitle = frameContent;
                continue;
            }
            if (ALBUM_ID.equals(frameID)) {
                this.albumTitle = frameContent;
                continue;
            }
            if (!TRACK_ID.equals(frameID)) continue;
            try {
                this.setTrackNumber(frameContent);
            }
            catch (NumberFormatException ignored) {}
        }
    }
}

