/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.io.IOException;
import javax.swing.Action;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.IOEvent;
import org.netbeans.core.output2.NbIO;
import org.netbeans.core.output2.NbWriter;
import org.netbeans.core.output2.PairMap;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOContainer;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public final class NbIOProvider
extends IOProvider {
    private static final PairMap namesToIos = new PairMap();
    private static final String STDOUT = NbBundle.getMessage(NbIOProvider.class, (String)"LBL_STDOUT");
    private static final String NAME = "output2";

    public OutputWriter getStdOut() {
        if (Controller.LOG) {
            Controller.log("NbIOProvider.getStdOut");
        }
        NbIO nbIO = (NbIO)this.getIO(STDOUT, false);
        NbWriter nbWriter = nbIO.writer();
        NbIO.post(new IOEvent(nbIO, 0, true));
        if (nbWriter != null && nbWriter.isClosed()) {
            try {
                nbWriter.reset();
                nbWriter = (NbWriter)nbIO.getOut();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                nbIO = (NbIO)this.getIO(STDOUT, true);
                nbWriter = (NbWriter)nbIO.getOut();
            }
        } else {
            nbWriter = (NbWriter)nbIO.getOut();
        }
        return nbWriter;
    }

    public InputOutput getIO(String string, boolean bl) {
        return this.getIO(string, bl, new Action[0], null);
    }

    public InputOutput getIO(String string, Action[] actionArray) {
        return this.getIO(string, true, actionArray, null);
    }

    public InputOutput getIO(String string, Action[] actionArray, IOContainer iOContainer) {
        return this.getIO(string, true, actionArray, iOContainer);
    }

    public String getName() {
        return NAME;
    }

    private InputOutput getIO(String string, boolean bl, Action[] actionArray, IOContainer iOContainer) {
        NbIO nbIO;
        if (Controller.LOG) {
            Controller.log("GETIO: " + string + " new:" + bl);
        }
        if ((nbIO = namesToIos.get(string)) == null || bl) {
            nbIO = new NbIO(string, actionArray, iOContainer);
            namesToIos.add(string, nbIO);
            NbIO.post(new IOEvent(nbIO, 0, bl));
        }
        return nbIO;
    }

    static void dispose(NbIO nbIO) {
        namesToIos.remove(nbIO);
    }

    static void setWeak(boolean bl) {
        namesToIos.setWeak(bl);
    }
}

