/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.reader.impl;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.procfs.api.PStatus;
import org.netbeans.modules.dlight.procfs.reader.impl.ProcessStatusProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;

public class ProcessStatusProvider64
implements ProcessStatusProvider {
    private final NativeProcessBuilder npb;
    private final Pattern lwpPattern;
    private final PStatus.PIDInfo pidInfo;

    public ProcessStatusProvider64(ExecutionEnvironment executionEnvironment, int n) {
        this.npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)executionEnvironment);
        this.npb.setExecutable("/bin/pflags").setArguments(new String[]{"" + n});
        this.lwpPattern = Pattern.compile("^[\t ]+\\/([0-9]+):.*");
        this.pidInfo = new PStatus.PIDInfo(n){};
    }

    public PStatus getProcessStatus() {
        PStatus pStatus = null;
        try {
            NativeProcess nativeProcess = this.npb.call();
            List list = ProcessUtils.readProcessOutput((Process)nativeProcess);
            int n = 0;
            for (String string : list) {
                Matcher matcher = this.lwpPattern.matcher(string);
                if (!matcher.matches()) continue;
                ++n;
            }
            int n2 = -1;
            try {
                n2 = nativeProcess.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n2 == 0) {
                final int n3 = n;
                pStatus = new PStatus(){

                    public PStatus.ThreadsInfo getThreadInfo() {
                        return new PStatus.ThreadsInfo(n3, 0){};
                    }

                    public PStatus.PIDInfo getPIDInfo() {
                        return ProcessStatusProvider64.this.pidInfo;
                    }
                };
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return pStatus;
    }
}

