/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.procfs.processinfo;

import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReader;
import org.netbeans.modules.dlight.procfs.reader.api.ProcReaderFactory;
import org.netbeans.modules.dlight.util.Computable;
import org.netbeans.modules.dlight.util.TasksCachedProcessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.ProcessInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.spi.ProcessInfoProvider;

class ProcBasedProcessInfoProvider
implements ProcessInfoProvider {
    private static final TasksCachedProcessor<FetchParams, ProcessInfo> cachedProcessor = new TasksCachedProcessor((Computable)new ProcessInfoFetcher(), false);
    private final FetchParams params;

    ProcBasedProcessInfoProvider(ExecutionEnvironment executionEnvironment, int n) {
        this.params = new FetchParams(executionEnvironment, n);
    }

    public ProcessInfo getProcessInfo() {
        ProcessInfo processInfo = null;
        try {
            processInfo = (ProcessInfo)cachedProcessor.compute((Object)this.params);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return processInfo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessInfoFetcher
    implements Computable<FetchParams, ProcessInfo> {
        private ProcessInfoFetcher() {
        }

        public ProcessInfo compute(FetchParams fetchParams) throws InterruptedException {
            ProcessInfo processInfo = null;
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)fetchParams.env);
                if (hostInfo.getOSFamily() != HostInfo.OSFamily.SUNOS) {
                    return null;
                }
                ProcReader procReader = ProcReaderFactory.getReader(fetchParams.env, fetchParams.pid);
                final long l = procReader.getProcessUsage().getUsageInfo().pr_create;
                if (l > 0L) {
                    processInfo = new ProcessInfo(){

                        public long getCreationTimestamp(TimeUnit timeUnit) {
                            return timeUnit.convert(l, TimeUnit.NANOSECONDS);
                        }
                    };
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return processInfo;
        }
    }

    private static class FetchParams {
        private final ExecutionEnvironment env;
        private final int pid;

        private FetchParams(ExecutionEnvironment executionEnvironment, int n) {
            this.env = executionEnvironment;
            this.pid = n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof FetchParams)) {
                return false;
            }
            FetchParams fetchParams = (FetchParams)object;
            return this.pid == fetchParams.pid && this.env.equals(fetchParams.env);
        }

        public int hashCode() {
            int n = 5;
            n = 71 * n + (this.env != null ? this.env.hashCode() : 0);
            n = 71 * n + this.pid;
            return n;
        }
    }
}

